(ns clojurewerkz.eventoverse.collector.udp
  (:require [clojure.tools.logging :as log]
            [clojure.stacktrace    :as strace]
            [clojure.data.json :as json]
            [clojurewerkz.eventoverse.collector.core :as proc]
            [lamina.core :as lamina]
            [gloss.core :as gloss]
            [aleph.udp :as udp]))

(defn event-handler
  "Handles messages that represent events"
  [payload]
  (log/infof "Handling a message: %s" payload)
  (try
    (let [parsed-payload (json/read-json payload true)]
      (proc/process parsed-payload))
    (catch Exception e
      (log/errorf "Handling a message %s resulted in an exception: %s" payload e)
      (.printStackTrace e))))

(defn connect
  [options]
  (let [timeout 10000
        socket  @(udp/udp-socket {:frame (gloss/string :utf-8)
                                  :buf-size 10000
                                  :netty {:options {"sendBufferSize" 10000}}
                                  :port (:port options)})]
    (try
      (event-handler (:message (lamina/wait-for-message socket timeout)))
      (catch Exception e
        (log/errorf "Handling an exception while receiving a UDP datagram: %s" e)
        (.printStackTrace e))
      (finally (lamina/close socket))))
  (recur options))
