var LiveFeed = new Class({
  initialize: function(el, baseURL, app, env) {
    this.element = el;
    this.tbody   = el.getElement("tbody");
    this.baseURL = baseURL;
    this.app     = app;
    this.env     = env;

    this.endpoint  = "ws://" + this.baseURL + "/apps/" + this.app + "/env/" + this.env + "/live/feed/";
    this.rowsLimit = 50;
  },

  onMessage: function(type, data, html) {
    Elements.from(html).inject(this.tbody, 'top');
    this.maybePruneLastRow();
  },

  dispatchMessage: function(evt) {
    var payload     = JSON.parse(evt.data);
    this.onMessage(payload.type, payload.data, payload.html);
  },

  watch: function() {
    this.socket  = new WebSocket(this.endpoint);
    this.socket.onmessage = this.dispatchMessage.bind(this);
  },

  maybePruneLastRow: function() {
    if(this.getRowCount() > this.rowsLimit) {
      var lastRow = this.tbody.getElements("tr").getLast();
      if(lastRow != undefined){
	lastRow.destroy();
      }
    }
  },

  getRowCount: function(tbody) {
    return this.element.getElementsByTagName("tbody")[0].getElementsByTagName("tr").length;
  }
});


var table = $("events");
var feed  = new LiveFeed(table, table.dataset["baseUrl"], table.dataset["application"], table.dataset["environment"]);
feed.watch();
