(ns clojurewerkz.eventoverse.client.in-memory
  (:require [cheshire.core :as json]
            [clojurewerkz.eventoverse.client])
  (:import java.util.Date))

(defn- publish-event*
  [client event-type attributes]
  (swap! (.store client) conj (merge (.defaults client)
                                    attributes
                                    {:emitted_at (now) :type event-type})))

;;
;; API
;;

(deftype InMemoryClient []
  clojurewerkz.eventoverse.client/Client
  (publish-event [client event-type attributes]
    (publish-event* client event-type attributes)))

(defn make [defaults]
  (InMemoryClient. defaults (atom [])))
