(ns clojurewerkz.eventoverse.client.udp
  (:require [clojurewerkz.eventoverse.client :refer :all]
            [taoensso.nippy :as nippy])
  (:import [java.net DatagramPacket DatagramSocket InetAddress]
           [java.util Date]))

(deftype UdpClient [^String host ^int port ^DatagramSocket socket]
  clojurewerkz.eventoverse.client/Client
  (publish-event [client payload-type attributes]
    (let [buf (nippy/freeze (merge attributes
                                   {:type payload-type
                                    :emitted_at (.getTime (Date.))}))]
      (.send
       socket
       (DatagramPacket. buf
                        (count buf)
                        (InetAddress/getByName host)
                        port)))))

(defn make
  [options]
  (UdpClient. (:host options) (:port options) (DatagramSocket.)))
