(ns clojurewerkz.eventoverse.json
  (:require cheshire.generate)
  (:import [org.joda.time DateTime DateTimeZone ReadableInstant]
           [org.joda.time.format ISODateTimeFormat]))

(cheshire.generate/add-encoder DateTime
                               (fn [^DateTime dt ^com.fasterxml.jackson.core.json.WriterBasedJsonGenerator generator]
                                 (.writeString generator (.print (ISODateTimeFormat/dateTime) ^ReadableInstant dt))))