(ns clojurewerkz.eventoverse.client)

(defprotocol Client
  (publish-event [client type attributes] "Publishes an event")
  (trace  [client msg] "Trace level logging")
  (debug  [client msg] "Debug level logging")
  (info   [client msg] "Info level logging")
  (warn   [client msg] "Warn info logging")
  (error  [client msg] "Error level logging")
  (fatal  [client msg] "Fatal level logging")
  (tracef [client msg & rest] "Trace level logging using format")
  (debugf [client msg & rest] "Debug level logging using format")
  (infof  [client msg & rest] "Info level logging using format")
  (warnf  [client msg & rest] "Warn level logging using format")
  (errorf [client msg & rest] "Error level logging using format")
  (fatalf [client msg & rest] "Fatal level logging using format"))
