(ns clojurewerkz.eventoverse.client.no-op
  (:require [clojurewerkz.eventoverse.client]))

;;
;; API
;;

(def ^{:dynamic true}
  *default-client*)

(deftype NoOpClient [defaults]
  clojurewerkz.eventoverse.client/Client
  (publish-event [client event-type attributes])
  (trace  [client msg])
  (debug  [client msg])
  (info   [client msg])
  (warn   [client msg])
  (error  [client msg])
  (fatal  [client msg])
  (tracef [client msg & rest])
  (debugf [client msg & rest])
  (infof  [client msg & rest])
  (warnf  [client msg & rest])
  (errorf [client msg & rest])
  (fatalf [client msg & rest])

  java.lang.Iterable
  (iterator [client]
    (.iterator []))

  clojure.lang.Counted
  (count [client]
    0)

  clojure.lang.IDeref
  (deref [client]
    [])

  Object
  (toString [_] "<NoOpClient>"))

(defn make
  ([defaults]
     (NoOpClient. defaults))
  ([defaults & rest]
     (NoOpClient. defaults)))

(defn initialize!
  ([defaults]
     (let [client (make defaults)]
       (alter-var-root (var *default-client* client))
       client))
  ([defaults & rest]
     (initialize! defaults)))