/*
 * Decompiled with CFR 0.152.
 */
package clojurewerkz.cassaforte;

import com.datastax.driver.core.DataType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.DateType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;

public class Codec {
    private Codec() {
    }

    public static <T> AbstractType<T> getCodec(DataType dataType) {
        return Codec.getCodecInternal(dataType);
    }

    private static AbstractType getCodecInternal(DataType dataType) {
        switch (dataType.getName()) {
            case ASCII: {
                return AsciiType.instance;
            }
            case BIGINT: {
                return LongType.instance;
            }
            case BLOB: {
                return BytesType.instance;
            }
            case BOOLEAN: {
                return BooleanType.instance;
            }
            case COUNTER: {
                return CounterColumnType.instance;
            }
            case DECIMAL: {
                return DecimalType.instance;
            }
            case DOUBLE: {
                return DoubleType.instance;
            }
            case FLOAT: {
                return FloatType.instance;
            }
            case INET: {
                return InetAddressType.instance;
            }
            case INT: {
                return Int32Type.instance;
            }
            case TEXT: {
                return UTF8Type.instance;
            }
            case TIMESTAMP: {
                return DateType.instance;
            }
            case UUID: {
                return UUIDType.instance;
            }
            case VARCHAR: {
                return UTF8Type.instance;
            }
            case VARINT: {
                return IntegerType.instance;
            }
            case TIMEUUID: {
                return TimeUUIDType.instance;
            }
            case LIST: {
                return ListType.getInstance(Codec.getCodec((DataType)dataType.getTypeArguments().get(0)));
            }
            case SET: {
                return SetType.getInstance(Codec.getCodec((DataType)dataType.getTypeArguments().get(0)));
            }
            case MAP: {
                return MapType.getInstance(Codec.getCodec((DataType)dataType.getTypeArguments().get(0)), Codec.getCodec((DataType)dataType.getTypeArguments().get(1)));
            }
        }
        throw new RuntimeException("Unknown type");
    }
}

