/*
 * Decompiled with CFR 0.152.
 */
package clojurewerkz.cassaforte;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.AuthenticationException;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.AuthorizationException;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.CqlPreparedResult;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.cassandra.thrift.SchemaDisagreementException;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.TBinaryProtocol;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.TokenRange;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class CassandraClient {
    private Cassandra.Client client;
    private TTransport transport;
    private static final int DEFAULT_PORT = 9160;
    private int port;
    private String hostname;

    public CassandraClient(Cassandra.Client client, TTransport tTransport) {
        this.client = client;
        this.transport = tTransport;
    }

    public CassandraClient(String string) throws TException, InvalidRequestException {
        this(string, 9160);
    }

    public CassandraClient(String string, int n) throws TException, InvalidRequestException {
        this.hostname = string;
        this.port = n;
        TFramedTransport tFramedTransport = new TFramedTransport((TTransport)new TSocket(string, n));
        this.transport = tFramedTransport;
        this.client = new Cassandra.Client((TProtocol)new TBinaryProtocol((TTransport)tFramedTransport));
        tFramedTransport.open();
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getHost() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public CqlResult executeCqlQuery(String string) throws TException, TimedOutException, SchemaDisagreementException, InvalidRequestException, UnavailableException, UnsupportedEncodingException {
        return this.executeCqlQuery(string, Compression.NONE);
    }

    public CqlResult executeCqlQuery(String string, Compression compression) throws UnsupportedEncodingException, TException, TimedOutException, SchemaDisagreementException, InvalidRequestException, UnavailableException {
        return this.client.execute_cql_query(ByteBuffer.wrap(string.getBytes("UTF-8")), compression);
    }

    public void login(AuthenticationRequest authenticationRequest) throws AuthenticationException, AuthorizationException, TException {
        this.client.login(authenticationRequest);
    }

    public void set_keyspace(String string) throws InvalidRequestException, TException {
        this.client.set_keyspace(string);
    }

    public ColumnOrSuperColumn get(ByteBuffer byteBuffer, ColumnPath columnPath, ConsistencyLevel consistencyLevel) throws InvalidRequestException, NotFoundException, UnavailableException, TimedOutException, TException {
        return this.client.get(byteBuffer, columnPath, consistencyLevel);
    }

    public int get_count(ByteBuffer byteBuffer, ColumnParent columnParent, SlicePredicate slicePredicate, ConsistencyLevel consistencyLevel) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        return this.client.get_count(byteBuffer, columnParent, slicePredicate, consistencyLevel);
    }

    public List<ColumnOrSuperColumn> get_slice(ByteBuffer byteBuffer, ColumnParent columnParent, SlicePredicate slicePredicate, ConsistencyLevel consistencyLevel) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        return this.client.get_slice(byteBuffer, columnParent, slicePredicate, consistencyLevel);
    }

    public Map<ByteBuffer, Integer> multiget_count(List<ByteBuffer> list, ColumnParent columnParent, SlicePredicate slicePredicate, ConsistencyLevel consistencyLevel) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        return this.client.multiget_count(list, columnParent, slicePredicate, consistencyLevel);
    }

    public Map<ByteBuffer, List<ColumnOrSuperColumn>> multiget_slice(List<ByteBuffer> list, ColumnParent columnParent, SlicePredicate slicePredicate, ConsistencyLevel consistencyLevel) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        return this.client.multiget_slice(list, columnParent, slicePredicate, consistencyLevel);
    }

    public void insert(ByteBuffer byteBuffer, ColumnParent columnParent, Column column, ConsistencyLevel consistencyLevel) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        this.client.insert(byteBuffer, columnParent, column, consistencyLevel);
    }

    public List<KeySlice> get_range_slices(ColumnParent columnParent, SlicePredicate slicePredicate, KeyRange keyRange, ConsistencyLevel consistencyLevel) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        return this.client.get_range_slices(columnParent, slicePredicate, keyRange, consistencyLevel);
    }

    public List<KeySlice> get_paged_slice(String string, KeyRange keyRange, ByteBuffer byteBuffer, ConsistencyLevel consistencyLevel) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        return this.client.get_paged_slice(string, keyRange, byteBuffer, consistencyLevel);
    }

    public List<KeySlice> get_indexed_slices(ColumnParent columnParent, IndexClause indexClause, SlicePredicate slicePredicate, ConsistencyLevel consistencyLevel) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        return this.client.get_indexed_slices(columnParent, indexClause, slicePredicate, consistencyLevel);
    }

    public CqlPreparedResult prepare_cql_query(ByteBuffer byteBuffer, Compression compression) throws InvalidRequestException, TException {
        return this.client.prepare_cql_query(byteBuffer, compression);
    }

    public CqlResult execute_prepared_cql_query(int n, List<ByteBuffer> list) throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, TException {
        return this.client.execute_prepared_cql_query(n, list);
    }

    public CqlResult execute_cql_query(ByteBuffer byteBuffer, Compression compression) throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, TException {
        return this.client.execute_cql_query(byteBuffer, compression);
    }

    public String describe_version() throws TException {
        return this.client.describe_version();
    }

    public String describe_snitch() throws TException {
        return this.client.describe_snitch();
    }

    public String describe_cluster_name() throws TException {
        return this.client.describe_cluster_name();
    }

    public KsDef describe_keyspace(String string) throws NotFoundException, InvalidRequestException, TException {
        return this.client.describe_keyspace(string);
    }

    public List<KsDef> describe_keyspaces() throws InvalidRequestException, TException {
        return this.client.describe_keyspaces();
    }

    public String describe_partitioner() throws TException {
        return this.client.describe_partitioner();
    }

    public List<TokenRange> describe_ring(String string) throws InvalidRequestException, TException {
        return this.client.describe_ring(string);
    }

    public Map<String, List<String>> describe_schema_versions() throws InvalidRequestException, TException {
        return this.client.describe_schema_versions();
    }

    public List<String> describe_splits(String string, String string2, String string3, int n) throws InvalidRequestException, TException {
        return this.client.describe_splits(string, string2, string3, n);
    }

    public void add(ByteBuffer byteBuffer, ColumnParent columnParent, CounterColumn counterColumn, ConsistencyLevel consistencyLevel) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        this.client.add(byteBuffer, columnParent, counterColumn, consistencyLevel);
    }

    public void batch_mutate(Map<ByteBuffer, Map<String, List<Mutation>>> map, ConsistencyLevel consistencyLevel) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        this.client.batch_mutate(map, consistencyLevel);
    }

    public void remove(ByteBuffer byteBuffer, ColumnPath columnPath, long l, ConsistencyLevel consistencyLevel) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        this.client.remove(byteBuffer, columnPath, l, consistencyLevel);
    }

    public void remove_counter(ByteBuffer byteBuffer, ColumnPath columnPath, ConsistencyLevel consistencyLevel) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        this.client.remove_counter(byteBuffer, columnPath, consistencyLevel);
    }

    public String system_add_column_family(CfDef cfDef) throws InvalidRequestException, SchemaDisagreementException, TException {
        return this.client.system_add_column_family(cfDef);
    }

    public String system_add_keyspace(KsDef ksDef) throws InvalidRequestException, SchemaDisagreementException, TException {
        return this.client.system_add_keyspace(ksDef);
    }

    public String system_drop_column_family(String string) throws InvalidRequestException, SchemaDisagreementException, TException {
        return this.client.system_drop_column_family(string);
    }

    public String system_drop_keyspace(String string) throws InvalidRequestException, SchemaDisagreementException, TException {
        return this.client.system_drop_keyspace(string);
    }

    public String system_update_column_family(CfDef cfDef) throws InvalidRequestException, SchemaDisagreementException, TException {
        return this.client.system_update_column_family(cfDef);
    }

    public String system_update_keyspace(KsDef ksDef) throws InvalidRequestException, SchemaDisagreementException, TException {
        return this.client.system_update_keyspace(ksDef);
    }

    public void truncate(String string) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        this.client.truncate(string);
    }

    public void open() throws TTransportException {
        this.transport.open();
    }

    public void close() {
        this.transport.close();
    }

    public void flush() throws TTransportException {
        this.transport.flush();
    }

    public boolean isOpen() {
        return this.transport.isOpen();
    }
}

