(ns clojurewerkz.cassaforte.client
  (:import [clojurewerkz.cassaforte CassandraClient]
   ))

;;
;; API
;;

(def ^{:cost true}
  default-port 9160)

(def ^{:dynamic true :tag CassandraClient}
  *cassandra-client*)


(defn ^CassandraClient connect
  "Connect to a Cassandra node"
  ([^String hostname]
     (connect hostname default-port))
  ([^String hostname ^long port]
     (let [client (CassandraClient. hostname port)]
       client)))


(defn ^CassandraClient connect!
  ([^String hostname]
     (connect! hostname default-port))
  ([^String hostname ^long port]
     (let [client (CassandraClient. hostname port)]
       (alter-var-root (var *cassandra-client*) (constantly client))
       client)))

(defn set-keyspace!
  ([^String keyspace]
     (.set_keyspace *cassandra-client* keyspace))
  ([^CassandraClient client ^String keyspace]
     (set-keyspace! client keyspace)))