(ns clojure.unicode
  (:require
    clojure.set))

(def ≠ not=)
(def ¬ not)
(def ^:macro ∧ #'and)
(def ^:macro ∨ #'or)

(def × *)
(def ÷ /)
(def − -)
(def ≤ <=)
(def ≥ >=)
(def ≡ ==)
(defn ≢ [& args] (¬ (apply == args)))
(def ∞ Double/POSITIVE_INFINITY)
(defn ∑ [coll] (reduce + coll))
(defn ∏ [coll] (reduce * coll))

(def ∋ contains?)
(defn ∌ [coll key] (¬ (∋ coll key)))
(defn ∈ [key coll] (∋ coll key))
(defn ∉ [key coll] (∌ coll key))
(def ∀ every?)
(def ∃ some)
(def ∄ not-any?)
(def ∪ clojure.set/union)
(def ∩ clojure.set/intersection)
(def ∖ clojure.set/difference)
(def ∅ #{})

(def ^:macro ↠ #'->>)
(def ^:macro → #'->)
(def ^:macro λ #'fn)
(def ∘ comp)
