# Bindings for org.nd4j.nativeblas

These bindings are created to simplify interaction with java classes from clojure.
For each java class was created a separate namespace.
Each method/field has its own function/field binding.
Their names are changed for a more native look in the clojure code. Each function has docstring - information about the parameters, return value and possible exceptions.

## Clojars

```
[clojure-interop/org.nd4j.nativeblas "1.0.0"]
```

## Class Members Naming Conventions

| Class Member | Java | Clojure |
|:--|:--|:--|
| constructor | new File() | (->file) |
| instance method | getAnyValue() | (get-any-value) |
| instance field | instanceField | (-instance-field) |
| static method | staticMethod() | (*static-method) |
| static field | ANY_STATIC_FIELD | (*-any-static-field) |
| boolean field/method | isExists(), canUse() | (exists?), (can-use?) |

## Classes

- class **org.nd4j.nativeblas.BaseNativeNDArrayFactory**
- class **org.nd4j.nativeblas.LongPointerWrapper**
- class **org.nd4j.nativeblas.NativeLapack**
- class **org.nd4j.nativeblas.NativeOps**
- class **org.nd4j.nativeblas.NativeOpsHolder**
- class **org.nd4j.nativeblas.Nd4jBlas**
- class **org.nd4j.nativeblas.Nd4jCpu$ArgumentsList**
- class **org.nd4j.nativeblas.Nd4jCpu$CurrentIndexing**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleBooleanOp**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleBroadcastableOp**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleContext**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleContextPrototype**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleDeclarableCustomOp**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleDeclarableListOp**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleDeclarableOp**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleDeclarableReductionOp**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleGraphState**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleLogicOp**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleNDArray**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleNDArrayList**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleNDArrayVector$Iterator**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleNDArrayVector**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleOpArgsHolder**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleResultSet**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleStash**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleVariable**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleVariableSpace**
- class **org.nd4j.nativeblas.Nd4jCpu$DoubleVariablesSet**
- class **org.nd4j.nativeblas.Nd4jCpu$ExternalWorkspace**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatBooleanOp**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatBroadcastableOp**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatContext**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatContextPrototype**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatDeclarableCustomOp**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatDeclarableListOp**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatDeclarableOp**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatDeclarableReductionOp**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatGraphState**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatLogicOp**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatNDArray**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatNDArrayList**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatNDArrayVector$Iterator**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatNDArrayVector**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatOpArgsHolder**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatResultSet**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatStash**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatVariable**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatVariableSpace**
- class **org.nd4j.nativeblas.Nd4jCpu$FloatVariablesSet**
- class **org.nd4j.nativeblas.Nd4jCpu$FlowPath**
- class **org.nd4j.nativeblas.Nd4jCpu$GraphProfile**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfBooleanOp**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfBroadcastableOp**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfContext**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfContextPrototype**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfDeclarableCustomOp**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfDeclarableListOp**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfDeclarableOp**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfDeclarableReductionOp**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfGraphState**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfLogicOp**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfNDArray**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfNDArrayList**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfNDArrayVector$Iterator**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfNDArrayVector**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfOpArgsHolder**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfResultSet**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfStash**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfVariable**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfVariableSpace**
- class **org.nd4j.nativeblas.Nd4jCpu$HalfVariablesSet**
- class **org.nd4j.nativeblas.Nd4jCpu$IGenerator**
- class **org.nd4j.nativeblas.Nd4jCpu$IndicesList**
- class **org.nd4j.nativeblas.Nd4jCpu$IntIntPair**
- class **org.nd4j.nativeblas.Nd4jCpu$IntVectorVector**
- class **org.nd4j.nativeblas.Nd4jCpu$Intervals**
- class **org.nd4j.nativeblas.Nd4jCpu$KeyPair**
- class **org.nd4j.nativeblas.Nd4jCpu$LongVectorVector**
- class **org.nd4j.nativeblas.Nd4jCpu$NDIndex**
- class **org.nd4j.nativeblas.Nd4jCpu$NDIndexAll**
- class **org.nd4j.nativeblas.Nd4jCpu$NDIndexInterval**
- class **org.nd4j.nativeblas.Nd4jCpu$NDIndexPoint**
- class **org.nd4j.nativeblas.Nd4jCpu$NativeOps**
- class **org.nd4j.nativeblas.Nd4jCpu$NodeProfile**
- class **org.nd4j.nativeblas.Nd4jCpu$OpDescriptor**
- class **org.nd4j.nativeblas.Nd4jCpu$OpRegistrator**
- class **org.nd4j.nativeblas.Nd4jCpu$Pair**
- class **org.nd4j.nativeblas.Nd4jCpu$RandomBuffer**
- class **org.nd4j.nativeblas.Nd4jCpu$ResultWrapper**
- class **org.nd4j.nativeblas.Nd4jCpu$ShapeInformation**
- class **org.nd4j.nativeblas.Nd4jCpu$ShapeList**
- class **org.nd4j.nativeblas.Nd4jCpu$Workspace**
- class **org.nd4j.nativeblas.Nd4jCpu$Xoroshiro128**
- class **org.nd4j.nativeblas.Nd4jCpu$_loader**
- class **org.nd4j.nativeblas.Nd4jCpu$double_Conditional**
- class **org.nd4j.nativeblas.Nd4jCpu$double_Floor**
- class **org.nd4j.nativeblas.Nd4jCpu$double_Log1p**
- class **org.nd4j.nativeblas.Nd4jCpu$double_Return**
- class **org.nd4j.nativeblas.Nd4jCpu$double_Scope**
- class **org.nd4j.nativeblas.Nd4jCpu$double_Switch**
- class **org.nd4j.nativeblas.Nd4jCpu$double_Where**
- class **org.nd4j.nativeblas.Nd4jCpu$double_While**
- class **org.nd4j.nativeblas.Nd4jCpu$double_absolute_difference_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$double_add**
- class **org.nd4j.nativeblas.Nd4jCpu$double_add_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_adjust_hue**
- class **org.nd4j.nativeblas.Nd4jCpu$double_adjust_saturation**
- class **org.nd4j.nativeblas.Nd4jCpu$double_apply_sgd**
- class **org.nd4j.nativeblas.Nd4jCpu$double_argmax**
- class **org.nd4j.nativeblas.Nd4jCpu$double_argmin**
- class **org.nd4j.nativeblas.Nd4jCpu$double_assign**
- class **org.nd4j.nativeblas.Nd4jCpu$double_assign_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_avgpool2d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_avgpool2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_avgpool3d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_avgpool3d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_avgpool3dnew**
- class **org.nd4j.nativeblas.Nd4jCpu$double_avgpool3dnew_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_axpy**
- class **org.nd4j.nativeblas.Nd4jCpu$double_batch_to_space**
- class **org.nd4j.nativeblas.Nd4jCpu$double_batched_gemm**
- class **org.nd4j.nativeblas.Nd4jCpu$double_batchnorm**
- class **org.nd4j.nativeblas.Nd4jCpu$double_batchnorm_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_betainc**
- class **org.nd4j.nativeblas.Nd4jCpu$double_biasadd**
- class **org.nd4j.nativeblas.Nd4jCpu$double_biasadd_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_bincount**
- class **org.nd4j.nativeblas.Nd4jCpu$double_boolean_and**
- class **org.nd4j.nativeblas.Nd4jCpu$double_boolean_or**
- class **org.nd4j.nativeblas.Nd4jCpu$double_broadcast_dynamic_shape**
- class **org.nd4j.nativeblas.Nd4jCpu$double_broadcastgradientargs**
- class **org.nd4j.nativeblas.Nd4jCpu$double_cast**
- class **org.nd4j.nativeblas.Nd4jCpu$double_choose**
- class **org.nd4j.nativeblas.Nd4jCpu$double_clip_by_global_norm**
- class **org.nd4j.nativeblas.Nd4jCpu$double_clipbyavgnorm**
- class **org.nd4j.nativeblas.Nd4jCpu$double_clipbynorm**
- class **org.nd4j.nativeblas.Nd4jCpu$double_clipbynorm_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_clipbyvalue**
- class **org.nd4j.nativeblas.Nd4jCpu$double_clone_list**
- class **org.nd4j.nativeblas.Nd4jCpu$double_col2im**
- class **org.nd4j.nativeblas.Nd4jCpu$double_concat**
- class **org.nd4j.nativeblas.Nd4jCpu$double_concat_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_confusion_matrix**
- class **org.nd4j.nativeblas.Nd4jCpu$double_conv1d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_conv1d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_conv2d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_conv2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_conv2d_input_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_conv3d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_conv3d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_conv3dnew**
- class **org.nd4j.nativeblas.Nd4jCpu$double_conv3dnew_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_cosine_distance_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$double_create_list**
- class **org.nd4j.nativeblas.Nd4jCpu$double_crelu**
- class **org.nd4j.nativeblas.Nd4jCpu$double_crelu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_cross**
- class **org.nd4j.nativeblas.Nd4jCpu$double_cube**
- class **org.nd4j.nativeblas.Nd4jCpu$double_cube_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_cumprod**
- class **org.nd4j.nativeblas.Nd4jCpu$double_cumprod_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_cumsum**
- class **org.nd4j.nativeblas.Nd4jCpu$double_cumsum_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_deconv2d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_deconv2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_deconv2d_tf**
- class **org.nd4j.nativeblas.Nd4jCpu$double_depth_to_space**
- class **org.nd4j.nativeblas.Nd4jCpu$double_depthwise_conv2d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_depthwise_conv2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_diag**
- class **org.nd4j.nativeblas.Nd4jCpu$double_diag_part**
- class **org.nd4j.nativeblas.Nd4jCpu$double_dilation2d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_divide**
- class **org.nd4j.nativeblas.Nd4jCpu$double_divide_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_dropout**
- class **org.nd4j.nativeblas.Nd4jCpu$double_dynamic_bidirectional_rnn**
- class **org.nd4j.nativeblas.Nd4jCpu$double_dynamic_partition**
- class **org.nd4j.nativeblas.Nd4jCpu$double_dynamic_rnn**
- class **org.nd4j.nativeblas.Nd4jCpu$double_dynamic_stitch**
- class **org.nd4j.nativeblas.Nd4jCpu$double_elu**
- class **org.nd4j.nativeblas.Nd4jCpu$double_elu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_embedding_lookup**
- class **org.nd4j.nativeblas.Nd4jCpu$double_eq_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$double_equals**
- class **org.nd4j.nativeblas.Nd4jCpu$double_expand_dims**
- class **org.nd4j.nativeblas.Nd4jCpu$double_expose**
- class **org.nd4j.nativeblas.Nd4jCpu$double_extract_image_patches**
- class **org.nd4j.nativeblas.Nd4jCpu$double_eye**
- class **org.nd4j.nativeblas.Nd4jCpu$double_fill**
- class **org.nd4j.nativeblas.Nd4jCpu$double_fill_as**
- class **org.nd4j.nativeblas.Nd4jCpu$double_firas_sparse**
- class **org.nd4j.nativeblas.Nd4jCpu$double_floordiv**
- class **org.nd4j.nativeblas.Nd4jCpu$double_floordiv_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_floormod**
- class **org.nd4j.nativeblas.Nd4jCpu$double_floormod_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_fullconv3d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_fullconv3d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_fullconv3d_grad**
- class **org.nd4j.nativeblas.Nd4jCpu$double_fused_batch_norm**
- class **org.nd4j.nativeblas.Nd4jCpu$double_gather**
- class **org.nd4j.nativeblas.Nd4jCpu$double_gather_list**
- class **org.nd4j.nativeblas.Nd4jCpu$double_gather_nd**
- class **org.nd4j.nativeblas.Nd4jCpu$double_get_seed**
- class **org.nd4j.nativeblas.Nd4jCpu$double_greater**
- class **org.nd4j.nativeblas.Nd4jCpu$double_greater_equal**
- class **org.nd4j.nativeblas.Nd4jCpu$double_gru**
- class **org.nd4j.nativeblas.Nd4jCpu$double_gruCell**
- class **org.nd4j.nativeblas.Nd4jCpu$double_gt_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$double_gte_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$double_hardsigmoid**
- class **org.nd4j.nativeblas.Nd4jCpu$double_hardsigmoid_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_hardtanh**
- class **org.nd4j.nativeblas.Nd4jCpu$double_hardtanh_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_hinge_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$double_huber_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$double_identity**
- class **org.nd4j.nativeblas.Nd4jCpu$double_identity_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_im2col**
- class **org.nd4j.nativeblas.Nd4jCpu$double_im2col_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_in_top_k**
- class **org.nd4j.nativeblas.Nd4jCpu$double_invert_permutation**
- class **org.nd4j.nativeblas.Nd4jCpu$double_is_non_decreasing**
- class **org.nd4j.nativeblas.Nd4jCpu$double_is_numeric_tensor**
- class **org.nd4j.nativeblas.Nd4jCpu$double_is_strictly_increasing**
- class **org.nd4j.nativeblas.Nd4jCpu$double_ismax**
- class **org.nd4j.nativeblas.Nd4jCpu$double_l2_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$double_less**
- class **org.nd4j.nativeblas.Nd4jCpu$double_less_equal**
- class **org.nd4j.nativeblas.Nd4jCpu$double_listdiff**
- class **org.nd4j.nativeblas.Nd4jCpu$double_log_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$double_log_poison_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$double_log_softmax**
- class **org.nd4j.nativeblas.Nd4jCpu$double_log_softmax_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_lrelu**
- class **org.nd4j.nativeblas.Nd4jCpu$double_lrelu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_lrn**
- class **org.nd4j.nativeblas.Nd4jCpu$double_lrn_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_lrn_old**
- class **org.nd4j.nativeblas.Nd4jCpu$double_lstm**
- class **org.nd4j.nativeblas.Nd4jCpu$double_lstmCell**
- class **org.nd4j.nativeblas.Nd4jCpu$double_lt_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$double_lte_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$double_matmul**
- class **org.nd4j.nativeblas.Nd4jCpu$double_matrix_determinant**
- class **org.nd4j.nativeblas.Nd4jCpu$double_matrix_diag**
- class **org.nd4j.nativeblas.Nd4jCpu$double_matrix_diag_part**
- class **org.nd4j.nativeblas.Nd4jCpu$double_matrix_inverse**
- class **org.nd4j.nativeblas.Nd4jCpu$double_matrix_set_diag**
- class **org.nd4j.nativeblas.Nd4jCpu$double_max_pool_with_argmax**
- class **org.nd4j.nativeblas.Nd4jCpu$double_maximum**
- class **org.nd4j.nativeblas.Nd4jCpu$double_maximum_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_maxpool2d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_maxpool2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_maxpool3d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_maxpool3d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_maxpool3dnew**
- class **org.nd4j.nativeblas.Nd4jCpu$double_maxpool3dnew_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_mean_pairwssqerr_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$double_mean_sqerr_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$double_mergeadd**
- class **org.nd4j.nativeblas.Nd4jCpu$double_mergeavg**
- class **org.nd4j.nativeblas.Nd4jCpu$double_mergemax**
- class **org.nd4j.nativeblas.Nd4jCpu$double_mergemaxindex**
- class **org.nd4j.nativeblas.Nd4jCpu$double_meshgrid**
- class **org.nd4j.nativeblas.Nd4jCpu$double_minimum**
- class **org.nd4j.nativeblas.Nd4jCpu$double_minimum_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_mirror_pad**
- class **org.nd4j.nativeblas.Nd4jCpu$double_mod**
- class **org.nd4j.nativeblas.Nd4jCpu$double_mod_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_moments**
- class **org.nd4j.nativeblas.Nd4jCpu$double_multiply**
- class **org.nd4j.nativeblas.Nd4jCpu$double_multiply_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_neq_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$double_noop**
- class **org.nd4j.nativeblas.Nd4jCpu$double_norm**
- class **org.nd4j.nativeblas.Nd4jCpu$double_normalize_moments**
- class **org.nd4j.nativeblas.Nd4jCpu$double_not_equals**
- class **org.nd4j.nativeblas.Nd4jCpu$double_onehot**
- class **org.nd4j.nativeblas.Nd4jCpu$double_ones_as**
- class **org.nd4j.nativeblas.Nd4jCpu$double_order**
- class **org.nd4j.nativeblas.Nd4jCpu$double_pad**
- class **org.nd4j.nativeblas.Nd4jCpu$double_parallel_stack**
- class **org.nd4j.nativeblas.Nd4jCpu$double_percentile**
- class **org.nd4j.nativeblas.Nd4jCpu$double_permute**
- class **org.nd4j.nativeblas.Nd4jCpu$double_pick_list**
- class **org.nd4j.nativeblas.Nd4jCpu$double_pnormpool2d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_pnormpool2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_pointwise_conv2d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_polygamma**
- class **org.nd4j.nativeblas.Nd4jCpu$double_pooling2d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_prelu**
- class **org.nd4j.nativeblas.Nd4jCpu$double_prelu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_random_bernoulli**
- class **org.nd4j.nativeblas.Nd4jCpu$double_random_crop**
- class **org.nd4j.nativeblas.Nd4jCpu$double_random_exponential**
- class **org.nd4j.nativeblas.Nd4jCpu$double_random_normal**
- class **org.nd4j.nativeblas.Nd4jCpu$double_random_shuffle**
- class **org.nd4j.nativeblas.Nd4jCpu$double_randomuniform**
- class **org.nd4j.nativeblas.Nd4jCpu$double_range**
- class **org.nd4j.nativeblas.Nd4jCpu$double_rank**
- class **org.nd4j.nativeblas.Nd4jCpu$double_rationaltanh**
- class **org.nd4j.nativeblas.Nd4jCpu$double_rationaltanh_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_read_list**
- class **org.nd4j.nativeblas.Nd4jCpu$double_realdiv**
- class **org.nd4j.nativeblas.Nd4jCpu$double_realdiv_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_rectifiedtanh**
- class **org.nd4j.nativeblas.Nd4jCpu$double_rectifiedtanh_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_dot_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_max**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_max_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_mean**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_mean_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_min**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_min_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_norm1**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_norm1_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_norm2**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_norm2_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_norm_max**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_norm_max_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_prod**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_prod_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_sqnorm**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_sqnorm_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_stdev**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_stdev_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_sum**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_sum_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_variance**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reduce_variance_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_relu**
- class **org.nd4j.nativeblas.Nd4jCpu$double_relu6**
- class **org.nd4j.nativeblas.Nd4jCpu$double_relu6_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_relu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_relu_layer**
- class **org.nd4j.nativeblas.Nd4jCpu$double_repeat**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reshape**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reshapeas**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reverse**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reverse_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reverse_sequence**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reversedivide**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reversedivide_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reversemod**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reversemod_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reversesubtract**
- class **org.nd4j.nativeblas.Nd4jCpu$double_reversesubtract_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_rint**
- class **org.nd4j.nativeblas.Nd4jCpu$double_roll**
- class **org.nd4j.nativeblas.Nd4jCpu$double_scatter_add**
- class **org.nd4j.nativeblas.Nd4jCpu$double_scatter_div**
- class **org.nd4j.nativeblas.Nd4jCpu$double_scatter_list**
- class **org.nd4j.nativeblas.Nd4jCpu$double_scatter_max**
- class **org.nd4j.nativeblas.Nd4jCpu$double_scatter_min**
- class **org.nd4j.nativeblas.Nd4jCpu$double_scatter_mul**
- class **org.nd4j.nativeblas.Nd4jCpu$double_scatter_sub**
- class **org.nd4j.nativeblas.Nd4jCpu$double_scatter_upd**
- class **org.nd4j.nativeblas.Nd4jCpu$double_scatter_update**
- class **org.nd4j.nativeblas.Nd4jCpu$double_sconv2d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_sconv2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_segment_max**
- class **org.nd4j.nativeblas.Nd4jCpu$double_segment_mean**
- class **org.nd4j.nativeblas.Nd4jCpu$double_segment_min**
- class **org.nd4j.nativeblas.Nd4jCpu$double_segment_prod**
- class **org.nd4j.nativeblas.Nd4jCpu$double_segment_sum**
- class **org.nd4j.nativeblas.Nd4jCpu$double_select**
- class **org.nd4j.nativeblas.Nd4jCpu$double_selu**
- class **org.nd4j.nativeblas.Nd4jCpu$double_selu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_sequence_mask**
- class **org.nd4j.nativeblas.Nd4jCpu$double_set_seed**
- class **org.nd4j.nativeblas.Nd4jCpu$double_shape_of**
- class **org.nd4j.nativeblas.Nd4jCpu$double_shapes_of**
- class **org.nd4j.nativeblas.Nd4jCpu$double_sigm_cross_entropy_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$double_sigmoid**
- class **org.nd4j.nativeblas.Nd4jCpu$double_sigmoid_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_size**
- class **org.nd4j.nativeblas.Nd4jCpu$double_size_at**
- class **org.nd4j.nativeblas.Nd4jCpu$double_size_list**
- class **org.nd4j.nativeblas.Nd4jCpu$double_slice**
- class **org.nd4j.nativeblas.Nd4jCpu$double_slice_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_softmax**
- class **org.nd4j.nativeblas.Nd4jCpu$double_softmax_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_softmax_cross_entropy_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$double_softmax_cross_entropy_loss_with_logits**
- class **org.nd4j.nativeblas.Nd4jCpu$double_softplus**
- class **org.nd4j.nativeblas.Nd4jCpu$double_softplus_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_softsign**
- class **org.nd4j.nativeblas.Nd4jCpu$double_softsign_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_space_to_batch**
- class **org.nd4j.nativeblas.Nd4jCpu$double_space_to_depth**
- class **org.nd4j.nativeblas.Nd4jCpu$double_split**
- class **org.nd4j.nativeblas.Nd4jCpu$double_split_list**
- class **org.nd4j.nativeblas.Nd4jCpu$double_split_v**
- class **org.nd4j.nativeblas.Nd4jCpu$double_square**
- class **org.nd4j.nativeblas.Nd4jCpu$double_squaredsubtract**
- class **org.nd4j.nativeblas.Nd4jCpu$double_squaredsubtract_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_squeeze**
- class **org.nd4j.nativeblas.Nd4jCpu$double_sru**
- class **org.nd4j.nativeblas.Nd4jCpu$double_sruCell**
- class **org.nd4j.nativeblas.Nd4jCpu$double_sru_bi**
- class **org.nd4j.nativeblas.Nd4jCpu$double_sru_bi_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_sru_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_sru_bp_logic**
- class **org.nd4j.nativeblas.Nd4jCpu$double_sru_logic**
- class **org.nd4j.nativeblas.Nd4jCpu$double_sru_old**
- class **org.nd4j.nativeblas.Nd4jCpu$double_stack**
- class **org.nd4j.nativeblas.Nd4jCpu$double_stack_list**
- class **org.nd4j.nativeblas.Nd4jCpu$double_static_bidirectional_rnn**
- class **org.nd4j.nativeblas.Nd4jCpu$double_static_rnn**
- class **org.nd4j.nativeblas.Nd4jCpu$double_stop_gradient**
- class **org.nd4j.nativeblas.Nd4jCpu$double_strided_slice**
- class **org.nd4j.nativeblas.Nd4jCpu$double_strided_slice_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_subtract**
- class **org.nd4j.nativeblas.Nd4jCpu$double_subtract_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_sufficient_statistics**
- class **org.nd4j.nativeblas.Nd4jCpu$double_svd**
- class **org.nd4j.nativeblas.Nd4jCpu$double_tanh**
- class **org.nd4j.nativeblas.Nd4jCpu$double_tanh_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_tear**
- class **org.nd4j.nativeblas.Nd4jCpu$double_tensormmul**
- class **org.nd4j.nativeblas.Nd4jCpu$double_test_output_reshape**
- class **org.nd4j.nativeblas.Nd4jCpu$double_test_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$double_testcustom**
- class **org.nd4j.nativeblas.Nd4jCpu$double_testop2i2o**
- class **org.nd4j.nativeblas.Nd4jCpu$double_testreduction**
- class **org.nd4j.nativeblas.Nd4jCpu$double_tf_atan2**
- class **org.nd4j.nativeblas.Nd4jCpu$double_thresholdedrelu**
- class **org.nd4j.nativeblas.Nd4jCpu$double_thresholdedrelu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_tile**
- class **org.nd4j.nativeblas.Nd4jCpu$double_tile_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_tile_to_shape**
- class **org.nd4j.nativeblas.Nd4jCpu$double_tile_to_shape_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_to_double**
- class **org.nd4j.nativeblas.Nd4jCpu$double_to_float16**
- class **org.nd4j.nativeblas.Nd4jCpu$double_to_float32**
- class **org.nd4j.nativeblas.Nd4jCpu$double_to_int32**
- class **org.nd4j.nativeblas.Nd4jCpu$double_to_int64**
- class **org.nd4j.nativeblas.Nd4jCpu$double_to_uint32**
- class **org.nd4j.nativeblas.Nd4jCpu$double_to_uint64**
- class **org.nd4j.nativeblas.Nd4jCpu$double_toggle_bits**
- class **org.nd4j.nativeblas.Nd4jCpu$double_top_k**
- class **org.nd4j.nativeblas.Nd4jCpu$double_trace**
- class **org.nd4j.nativeblas.Nd4jCpu$double_transpose**
- class **org.nd4j.nativeblas.Nd4jCpu$double_tri**
- class **org.nd4j.nativeblas.Nd4jCpu$double_triu**
- class **org.nd4j.nativeblas.Nd4jCpu$double_triu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_truncatediv**
- class **org.nd4j.nativeblas.Nd4jCpu$double_unique**
- class **org.nd4j.nativeblas.Nd4jCpu$double_unique_with_counts**
- class **org.nd4j.nativeblas.Nd4jCpu$double_unstack**
- class **org.nd4j.nativeblas.Nd4jCpu$double_unstack_list**
- class **org.nd4j.nativeblas.Nd4jCpu$double_upsampling2d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_upsampling2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_upsampling3d**
- class **org.nd4j.nativeblas.Nd4jCpu$double_upsampling3d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$double_weighted_cross_entropy_with_logits**
- class **org.nd4j.nativeblas.Nd4jCpu$double_where_np**
- class **org.nd4j.nativeblas.Nd4jCpu$double_write_list**
- class **org.nd4j.nativeblas.Nd4jCpu$double_xw_plus_b**
- class **org.nd4j.nativeblas.Nd4jCpu$double_zero_fraction**
- class **org.nd4j.nativeblas.Nd4jCpu$double_zeros_as**
- class **org.nd4j.nativeblas.Nd4jCpu$double_zeta**
- class **org.nd4j.nativeblas.Nd4jCpu$float_Conditional**
- class **org.nd4j.nativeblas.Nd4jCpu$float_Floor**
- class **org.nd4j.nativeblas.Nd4jCpu$float_Log1p**
- class **org.nd4j.nativeblas.Nd4jCpu$float_Return**
- class **org.nd4j.nativeblas.Nd4jCpu$float_Scope**
- class **org.nd4j.nativeblas.Nd4jCpu$float_Switch**
- class **org.nd4j.nativeblas.Nd4jCpu$float_Where**
- class **org.nd4j.nativeblas.Nd4jCpu$float_While**
- class **org.nd4j.nativeblas.Nd4jCpu$float_absolute_difference_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$float_add**
- class **org.nd4j.nativeblas.Nd4jCpu$float_add_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_adjust_hue**
- class **org.nd4j.nativeblas.Nd4jCpu$float_adjust_saturation**
- class **org.nd4j.nativeblas.Nd4jCpu$float_apply_sgd**
- class **org.nd4j.nativeblas.Nd4jCpu$float_argmax**
- class **org.nd4j.nativeblas.Nd4jCpu$float_argmin**
- class **org.nd4j.nativeblas.Nd4jCpu$float_assign**
- class **org.nd4j.nativeblas.Nd4jCpu$float_assign_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_avgpool2d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_avgpool2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_avgpool3d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_avgpool3d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_avgpool3dnew**
- class **org.nd4j.nativeblas.Nd4jCpu$float_avgpool3dnew_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_axpy**
- class **org.nd4j.nativeblas.Nd4jCpu$float_batch_to_space**
- class **org.nd4j.nativeblas.Nd4jCpu$float_batched_gemm**
- class **org.nd4j.nativeblas.Nd4jCpu$float_batchnorm**
- class **org.nd4j.nativeblas.Nd4jCpu$float_batchnorm_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_betainc**
- class **org.nd4j.nativeblas.Nd4jCpu$float_biasadd**
- class **org.nd4j.nativeblas.Nd4jCpu$float_biasadd_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_bincount**
- class **org.nd4j.nativeblas.Nd4jCpu$float_boolean_and**
- class **org.nd4j.nativeblas.Nd4jCpu$float_boolean_or**
- class **org.nd4j.nativeblas.Nd4jCpu$float_broadcast_dynamic_shape**
- class **org.nd4j.nativeblas.Nd4jCpu$float_broadcastgradientargs**
- class **org.nd4j.nativeblas.Nd4jCpu$float_cast**
- class **org.nd4j.nativeblas.Nd4jCpu$float_choose**
- class **org.nd4j.nativeblas.Nd4jCpu$float_clip_by_global_norm**
- class **org.nd4j.nativeblas.Nd4jCpu$float_clipbyavgnorm**
- class **org.nd4j.nativeblas.Nd4jCpu$float_clipbynorm**
- class **org.nd4j.nativeblas.Nd4jCpu$float_clipbynorm_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_clipbyvalue**
- class **org.nd4j.nativeblas.Nd4jCpu$float_clone_list**
- class **org.nd4j.nativeblas.Nd4jCpu$float_col2im**
- class **org.nd4j.nativeblas.Nd4jCpu$float_concat**
- class **org.nd4j.nativeblas.Nd4jCpu$float_concat_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_confusion_matrix**
- class **org.nd4j.nativeblas.Nd4jCpu$float_conv1d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_conv1d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_conv2d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_conv2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_conv2d_input_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_conv3d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_conv3d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_conv3dnew**
- class **org.nd4j.nativeblas.Nd4jCpu$float_conv3dnew_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_cosine_distance_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$float_create_list**
- class **org.nd4j.nativeblas.Nd4jCpu$float_crelu**
- class **org.nd4j.nativeblas.Nd4jCpu$float_crelu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_cross**
- class **org.nd4j.nativeblas.Nd4jCpu$float_cube**
- class **org.nd4j.nativeblas.Nd4jCpu$float_cube_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_cumprod**
- class **org.nd4j.nativeblas.Nd4jCpu$float_cumprod_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_cumsum**
- class **org.nd4j.nativeblas.Nd4jCpu$float_cumsum_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_deconv2d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_deconv2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_deconv2d_tf**
- class **org.nd4j.nativeblas.Nd4jCpu$float_depth_to_space**
- class **org.nd4j.nativeblas.Nd4jCpu$float_depthwise_conv2d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_depthwise_conv2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_diag**
- class **org.nd4j.nativeblas.Nd4jCpu$float_diag_part**
- class **org.nd4j.nativeblas.Nd4jCpu$float_dilation2d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_divide**
- class **org.nd4j.nativeblas.Nd4jCpu$float_divide_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_dropout**
- class **org.nd4j.nativeblas.Nd4jCpu$float_dynamic_bidirectional_rnn**
- class **org.nd4j.nativeblas.Nd4jCpu$float_dynamic_partition**
- class **org.nd4j.nativeblas.Nd4jCpu$float_dynamic_rnn**
- class **org.nd4j.nativeblas.Nd4jCpu$float_dynamic_stitch**
- class **org.nd4j.nativeblas.Nd4jCpu$float_elu**
- class **org.nd4j.nativeblas.Nd4jCpu$float_elu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_embedding_lookup**
- class **org.nd4j.nativeblas.Nd4jCpu$float_eq_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$float_equals**
- class **org.nd4j.nativeblas.Nd4jCpu$float_expand_dims**
- class **org.nd4j.nativeblas.Nd4jCpu$float_expose**
- class **org.nd4j.nativeblas.Nd4jCpu$float_extract_image_patches**
- class **org.nd4j.nativeblas.Nd4jCpu$float_eye**
- class **org.nd4j.nativeblas.Nd4jCpu$float_fill**
- class **org.nd4j.nativeblas.Nd4jCpu$float_fill_as**
- class **org.nd4j.nativeblas.Nd4jCpu$float_firas_sparse**
- class **org.nd4j.nativeblas.Nd4jCpu$float_floordiv**
- class **org.nd4j.nativeblas.Nd4jCpu$float_floordiv_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_floormod**
- class **org.nd4j.nativeblas.Nd4jCpu$float_floormod_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_fullconv3d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_fullconv3d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_fullconv3d_grad**
- class **org.nd4j.nativeblas.Nd4jCpu$float_fused_batch_norm**
- class **org.nd4j.nativeblas.Nd4jCpu$float_gather**
- class **org.nd4j.nativeblas.Nd4jCpu$float_gather_list**
- class **org.nd4j.nativeblas.Nd4jCpu$float_gather_nd**
- class **org.nd4j.nativeblas.Nd4jCpu$float_get_seed**
- class **org.nd4j.nativeblas.Nd4jCpu$float_greater**
- class **org.nd4j.nativeblas.Nd4jCpu$float_greater_equal**
- class **org.nd4j.nativeblas.Nd4jCpu$float_gru**
- class **org.nd4j.nativeblas.Nd4jCpu$float_gruCell**
- class **org.nd4j.nativeblas.Nd4jCpu$float_gt_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$float_gte_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$float_hardsigmoid**
- class **org.nd4j.nativeblas.Nd4jCpu$float_hardsigmoid_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_hardtanh**
- class **org.nd4j.nativeblas.Nd4jCpu$float_hardtanh_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_hinge_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$float_huber_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$float_identity**
- class **org.nd4j.nativeblas.Nd4jCpu$float_identity_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_im2col**
- class **org.nd4j.nativeblas.Nd4jCpu$float_im2col_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_in_top_k**
- class **org.nd4j.nativeblas.Nd4jCpu$float_invert_permutation**
- class **org.nd4j.nativeblas.Nd4jCpu$float_is_non_decreasing**
- class **org.nd4j.nativeblas.Nd4jCpu$float_is_numeric_tensor**
- class **org.nd4j.nativeblas.Nd4jCpu$float_is_strictly_increasing**
- class **org.nd4j.nativeblas.Nd4jCpu$float_ismax**
- class **org.nd4j.nativeblas.Nd4jCpu$float_l2_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$float_less**
- class **org.nd4j.nativeblas.Nd4jCpu$float_less_equal**
- class **org.nd4j.nativeblas.Nd4jCpu$float_listdiff**
- class **org.nd4j.nativeblas.Nd4jCpu$float_log_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$float_log_poison_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$float_log_softmax**
- class **org.nd4j.nativeblas.Nd4jCpu$float_log_softmax_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_lrelu**
- class **org.nd4j.nativeblas.Nd4jCpu$float_lrelu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_lrn**
- class **org.nd4j.nativeblas.Nd4jCpu$float_lrn_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_lrn_old**
- class **org.nd4j.nativeblas.Nd4jCpu$float_lstm**
- class **org.nd4j.nativeblas.Nd4jCpu$float_lstmCell**
- class **org.nd4j.nativeblas.Nd4jCpu$float_lt_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$float_lte_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$float_matmul**
- class **org.nd4j.nativeblas.Nd4jCpu$float_matrix_determinant**
- class **org.nd4j.nativeblas.Nd4jCpu$float_matrix_diag**
- class **org.nd4j.nativeblas.Nd4jCpu$float_matrix_diag_part**
- class **org.nd4j.nativeblas.Nd4jCpu$float_matrix_inverse**
- class **org.nd4j.nativeblas.Nd4jCpu$float_matrix_set_diag**
- class **org.nd4j.nativeblas.Nd4jCpu$float_max_pool_with_argmax**
- class **org.nd4j.nativeblas.Nd4jCpu$float_maximum**
- class **org.nd4j.nativeblas.Nd4jCpu$float_maximum_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_maxpool2d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_maxpool2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_maxpool3d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_maxpool3d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_maxpool3dnew**
- class **org.nd4j.nativeblas.Nd4jCpu$float_maxpool3dnew_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_mean_pairwssqerr_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$float_mean_sqerr_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$float_mergeadd**
- class **org.nd4j.nativeblas.Nd4jCpu$float_mergeavg**
- class **org.nd4j.nativeblas.Nd4jCpu$float_mergemax**
- class **org.nd4j.nativeblas.Nd4jCpu$float_mergemaxindex**
- class **org.nd4j.nativeblas.Nd4jCpu$float_meshgrid**
- class **org.nd4j.nativeblas.Nd4jCpu$float_minimum**
- class **org.nd4j.nativeblas.Nd4jCpu$float_minimum_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_mirror_pad**
- class **org.nd4j.nativeblas.Nd4jCpu$float_mod**
- class **org.nd4j.nativeblas.Nd4jCpu$float_mod_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_moments**
- class **org.nd4j.nativeblas.Nd4jCpu$float_multiply**
- class **org.nd4j.nativeblas.Nd4jCpu$float_multiply_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_neq_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$float_noop**
- class **org.nd4j.nativeblas.Nd4jCpu$float_norm**
- class **org.nd4j.nativeblas.Nd4jCpu$float_normalize_moments**
- class **org.nd4j.nativeblas.Nd4jCpu$float_not_equals**
- class **org.nd4j.nativeblas.Nd4jCpu$float_onehot**
- class **org.nd4j.nativeblas.Nd4jCpu$float_ones_as**
- class **org.nd4j.nativeblas.Nd4jCpu$float_order**
- class **org.nd4j.nativeblas.Nd4jCpu$float_pad**
- class **org.nd4j.nativeblas.Nd4jCpu$float_parallel_stack**
- class **org.nd4j.nativeblas.Nd4jCpu$float_percentile**
- class **org.nd4j.nativeblas.Nd4jCpu$float_permute**
- class **org.nd4j.nativeblas.Nd4jCpu$float_pick_list**
- class **org.nd4j.nativeblas.Nd4jCpu$float_pnormpool2d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_pnormpool2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_pointwise_conv2d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_polygamma**
- class **org.nd4j.nativeblas.Nd4jCpu$float_pooling2d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_prelu**
- class **org.nd4j.nativeblas.Nd4jCpu$float_prelu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_random_bernoulli**
- class **org.nd4j.nativeblas.Nd4jCpu$float_random_crop**
- class **org.nd4j.nativeblas.Nd4jCpu$float_random_exponential**
- class **org.nd4j.nativeblas.Nd4jCpu$float_random_normal**
- class **org.nd4j.nativeblas.Nd4jCpu$float_random_shuffle**
- class **org.nd4j.nativeblas.Nd4jCpu$float_randomuniform**
- class **org.nd4j.nativeblas.Nd4jCpu$float_range**
- class **org.nd4j.nativeblas.Nd4jCpu$float_rank**
- class **org.nd4j.nativeblas.Nd4jCpu$float_rationaltanh**
- class **org.nd4j.nativeblas.Nd4jCpu$float_rationaltanh_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_read_list**
- class **org.nd4j.nativeblas.Nd4jCpu$float_realdiv**
- class **org.nd4j.nativeblas.Nd4jCpu$float_realdiv_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_rectifiedtanh**
- class **org.nd4j.nativeblas.Nd4jCpu$float_rectifiedtanh_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_dot_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_max**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_max_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_mean**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_mean_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_min**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_min_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_norm1**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_norm1_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_norm2**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_norm2_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_norm_max**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_norm_max_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_prod**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_prod_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_sqnorm**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_sqnorm_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_stdev**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_stdev_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_sum**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_sum_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_variance**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reduce_variance_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_relu**
- class **org.nd4j.nativeblas.Nd4jCpu$float_relu6**
- class **org.nd4j.nativeblas.Nd4jCpu$float_relu6_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_relu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_relu_layer**
- class **org.nd4j.nativeblas.Nd4jCpu$float_repeat**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reshape**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reshapeas**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reverse**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reverse_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reverse_sequence**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reversedivide**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reversedivide_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reversemod**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reversemod_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reversesubtract**
- class **org.nd4j.nativeblas.Nd4jCpu$float_reversesubtract_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_rint**
- class **org.nd4j.nativeblas.Nd4jCpu$float_roll**
- class **org.nd4j.nativeblas.Nd4jCpu$float_scatter_add**
- class **org.nd4j.nativeblas.Nd4jCpu$float_scatter_div**
- class **org.nd4j.nativeblas.Nd4jCpu$float_scatter_list**
- class **org.nd4j.nativeblas.Nd4jCpu$float_scatter_max**
- class **org.nd4j.nativeblas.Nd4jCpu$float_scatter_min**
- class **org.nd4j.nativeblas.Nd4jCpu$float_scatter_mul**
- class **org.nd4j.nativeblas.Nd4jCpu$float_scatter_sub**
- class **org.nd4j.nativeblas.Nd4jCpu$float_scatter_upd**
- class **org.nd4j.nativeblas.Nd4jCpu$float_scatter_update**
- class **org.nd4j.nativeblas.Nd4jCpu$float_sconv2d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_sconv2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_segment_max**
- class **org.nd4j.nativeblas.Nd4jCpu$float_segment_mean**
- class **org.nd4j.nativeblas.Nd4jCpu$float_segment_min**
- class **org.nd4j.nativeblas.Nd4jCpu$float_segment_prod**
- class **org.nd4j.nativeblas.Nd4jCpu$float_segment_sum**
- class **org.nd4j.nativeblas.Nd4jCpu$float_select**
- class **org.nd4j.nativeblas.Nd4jCpu$float_selu**
- class **org.nd4j.nativeblas.Nd4jCpu$float_selu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_sequence_mask**
- class **org.nd4j.nativeblas.Nd4jCpu$float_set_seed**
- class **org.nd4j.nativeblas.Nd4jCpu$float_shape_of**
- class **org.nd4j.nativeblas.Nd4jCpu$float_shapes_of**
- class **org.nd4j.nativeblas.Nd4jCpu$float_sigm_cross_entropy_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$float_sigmoid**
- class **org.nd4j.nativeblas.Nd4jCpu$float_sigmoid_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_size**
- class **org.nd4j.nativeblas.Nd4jCpu$float_size_at**
- class **org.nd4j.nativeblas.Nd4jCpu$float_size_list**
- class **org.nd4j.nativeblas.Nd4jCpu$float_slice**
- class **org.nd4j.nativeblas.Nd4jCpu$float_slice_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_softmax**
- class **org.nd4j.nativeblas.Nd4jCpu$float_softmax_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_softmax_cross_entropy_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$float_softmax_cross_entropy_loss_with_logits**
- class **org.nd4j.nativeblas.Nd4jCpu$float_softplus**
- class **org.nd4j.nativeblas.Nd4jCpu$float_softplus_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_softsign**
- class **org.nd4j.nativeblas.Nd4jCpu$float_softsign_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_space_to_batch**
- class **org.nd4j.nativeblas.Nd4jCpu$float_space_to_depth**
- class **org.nd4j.nativeblas.Nd4jCpu$float_split**
- class **org.nd4j.nativeblas.Nd4jCpu$float_split_list**
- class **org.nd4j.nativeblas.Nd4jCpu$float_split_v**
- class **org.nd4j.nativeblas.Nd4jCpu$float_square**
- class **org.nd4j.nativeblas.Nd4jCpu$float_squaredsubtract**
- class **org.nd4j.nativeblas.Nd4jCpu$float_squaredsubtract_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_squeeze**
- class **org.nd4j.nativeblas.Nd4jCpu$float_sru**
- class **org.nd4j.nativeblas.Nd4jCpu$float_sruCell**
- class **org.nd4j.nativeblas.Nd4jCpu$float_sru_bi**
- class **org.nd4j.nativeblas.Nd4jCpu$float_sru_bi_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_sru_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_sru_bp_logic**
- class **org.nd4j.nativeblas.Nd4jCpu$float_sru_logic**
- class **org.nd4j.nativeblas.Nd4jCpu$float_sru_old**
- class **org.nd4j.nativeblas.Nd4jCpu$float_stack**
- class **org.nd4j.nativeblas.Nd4jCpu$float_stack_list**
- class **org.nd4j.nativeblas.Nd4jCpu$float_static_bidirectional_rnn**
- class **org.nd4j.nativeblas.Nd4jCpu$float_static_rnn**
- class **org.nd4j.nativeblas.Nd4jCpu$float_stop_gradient**
- class **org.nd4j.nativeblas.Nd4jCpu$float_strided_slice**
- class **org.nd4j.nativeblas.Nd4jCpu$float_strided_slice_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_subtract**
- class **org.nd4j.nativeblas.Nd4jCpu$float_subtract_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_sufficient_statistics**
- class **org.nd4j.nativeblas.Nd4jCpu$float_svd**
- class **org.nd4j.nativeblas.Nd4jCpu$float_tanh**
- class **org.nd4j.nativeblas.Nd4jCpu$float_tanh_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_tear**
- class **org.nd4j.nativeblas.Nd4jCpu$float_tensormmul**
- class **org.nd4j.nativeblas.Nd4jCpu$float_test_output_reshape**
- class **org.nd4j.nativeblas.Nd4jCpu$float_test_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$float_testcustom**
- class **org.nd4j.nativeblas.Nd4jCpu$float_testop2i2o**
- class **org.nd4j.nativeblas.Nd4jCpu$float_testreduction**
- class **org.nd4j.nativeblas.Nd4jCpu$float_tf_atan2**
- class **org.nd4j.nativeblas.Nd4jCpu$float_thresholdedrelu**
- class **org.nd4j.nativeblas.Nd4jCpu$float_thresholdedrelu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_tile**
- class **org.nd4j.nativeblas.Nd4jCpu$float_tile_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_tile_to_shape**
- class **org.nd4j.nativeblas.Nd4jCpu$float_tile_to_shape_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_to_double**
- class **org.nd4j.nativeblas.Nd4jCpu$float_to_float16**
- class **org.nd4j.nativeblas.Nd4jCpu$float_to_float32**
- class **org.nd4j.nativeblas.Nd4jCpu$float_to_int32**
- class **org.nd4j.nativeblas.Nd4jCpu$float_to_int64**
- class **org.nd4j.nativeblas.Nd4jCpu$float_to_uint32**
- class **org.nd4j.nativeblas.Nd4jCpu$float_to_uint64**
- class **org.nd4j.nativeblas.Nd4jCpu$float_toggle_bits**
- class **org.nd4j.nativeblas.Nd4jCpu$float_top_k**
- class **org.nd4j.nativeblas.Nd4jCpu$float_trace**
- class **org.nd4j.nativeblas.Nd4jCpu$float_transpose**
- class **org.nd4j.nativeblas.Nd4jCpu$float_tri**
- class **org.nd4j.nativeblas.Nd4jCpu$float_triu**
- class **org.nd4j.nativeblas.Nd4jCpu$float_triu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_truncatediv**
- class **org.nd4j.nativeblas.Nd4jCpu$float_unique**
- class **org.nd4j.nativeblas.Nd4jCpu$float_unique_with_counts**
- class **org.nd4j.nativeblas.Nd4jCpu$float_unstack**
- class **org.nd4j.nativeblas.Nd4jCpu$float_unstack_list**
- class **org.nd4j.nativeblas.Nd4jCpu$float_upsampling2d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_upsampling2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_upsampling3d**
- class **org.nd4j.nativeblas.Nd4jCpu$float_upsampling3d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$float_weighted_cross_entropy_with_logits**
- class **org.nd4j.nativeblas.Nd4jCpu$float_where_np**
- class **org.nd4j.nativeblas.Nd4jCpu$float_write_list**
- class **org.nd4j.nativeblas.Nd4jCpu$float_xw_plus_b**
- class **org.nd4j.nativeblas.Nd4jCpu$float_zero_fraction**
- class **org.nd4j.nativeblas.Nd4jCpu$float_zeros_as**
- class **org.nd4j.nativeblas.Nd4jCpu$float_zeta**
- class **org.nd4j.nativeblas.Nd4jCpu$half_Conditional**
- class **org.nd4j.nativeblas.Nd4jCpu$half_Floor**
- class **org.nd4j.nativeblas.Nd4jCpu$half_Log1p**
- class **org.nd4j.nativeblas.Nd4jCpu$half_Return**
- class **org.nd4j.nativeblas.Nd4jCpu$half_Scope**
- class **org.nd4j.nativeblas.Nd4jCpu$half_Switch**
- class **org.nd4j.nativeblas.Nd4jCpu$half_Where**
- class **org.nd4j.nativeblas.Nd4jCpu$half_While**
- class **org.nd4j.nativeblas.Nd4jCpu$half_absolute_difference_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$half_add**
- class **org.nd4j.nativeblas.Nd4jCpu$half_add_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_adjust_hue**
- class **org.nd4j.nativeblas.Nd4jCpu$half_adjust_saturation**
- class **org.nd4j.nativeblas.Nd4jCpu$half_apply_sgd**
- class **org.nd4j.nativeblas.Nd4jCpu$half_argmax**
- class **org.nd4j.nativeblas.Nd4jCpu$half_argmin**
- class **org.nd4j.nativeblas.Nd4jCpu$half_assign**
- class **org.nd4j.nativeblas.Nd4jCpu$half_assign_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_avgpool2d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_avgpool2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_avgpool3d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_avgpool3d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_avgpool3dnew**
- class **org.nd4j.nativeblas.Nd4jCpu$half_avgpool3dnew_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_axpy**
- class **org.nd4j.nativeblas.Nd4jCpu$half_batch_to_space**
- class **org.nd4j.nativeblas.Nd4jCpu$half_batched_gemm**
- class **org.nd4j.nativeblas.Nd4jCpu$half_batchnorm**
- class **org.nd4j.nativeblas.Nd4jCpu$half_batchnorm_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_betainc**
- class **org.nd4j.nativeblas.Nd4jCpu$half_biasadd**
- class **org.nd4j.nativeblas.Nd4jCpu$half_biasadd_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_bincount**
- class **org.nd4j.nativeblas.Nd4jCpu$half_boolean_and**
- class **org.nd4j.nativeblas.Nd4jCpu$half_boolean_or**
- class **org.nd4j.nativeblas.Nd4jCpu$half_broadcast_dynamic_shape**
- class **org.nd4j.nativeblas.Nd4jCpu$half_broadcastgradientargs**
- class **org.nd4j.nativeblas.Nd4jCpu$half_cast**
- class **org.nd4j.nativeblas.Nd4jCpu$half_choose**
- class **org.nd4j.nativeblas.Nd4jCpu$half_clip_by_global_norm**
- class **org.nd4j.nativeblas.Nd4jCpu$half_clipbyavgnorm**
- class **org.nd4j.nativeblas.Nd4jCpu$half_clipbynorm**
- class **org.nd4j.nativeblas.Nd4jCpu$half_clipbynorm_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_clipbyvalue**
- class **org.nd4j.nativeblas.Nd4jCpu$half_clone_list**
- class **org.nd4j.nativeblas.Nd4jCpu$half_col2im**
- class **org.nd4j.nativeblas.Nd4jCpu$half_concat**
- class **org.nd4j.nativeblas.Nd4jCpu$half_concat_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_confusion_matrix**
- class **org.nd4j.nativeblas.Nd4jCpu$half_conv1d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_conv1d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_conv2d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_conv2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_conv2d_input_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_conv3d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_conv3d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_conv3dnew**
- class **org.nd4j.nativeblas.Nd4jCpu$half_conv3dnew_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_cosine_distance_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$half_create_list**
- class **org.nd4j.nativeblas.Nd4jCpu$half_crelu**
- class **org.nd4j.nativeblas.Nd4jCpu$half_crelu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_cross**
- class **org.nd4j.nativeblas.Nd4jCpu$half_cube**
- class **org.nd4j.nativeblas.Nd4jCpu$half_cube_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_cumprod**
- class **org.nd4j.nativeblas.Nd4jCpu$half_cumprod_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_cumsum**
- class **org.nd4j.nativeblas.Nd4jCpu$half_cumsum_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_deconv2d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_deconv2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_deconv2d_tf**
- class **org.nd4j.nativeblas.Nd4jCpu$half_depth_to_space**
- class **org.nd4j.nativeblas.Nd4jCpu$half_depthwise_conv2d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_depthwise_conv2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_diag**
- class **org.nd4j.nativeblas.Nd4jCpu$half_diag_part**
- class **org.nd4j.nativeblas.Nd4jCpu$half_dilation2d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_divide**
- class **org.nd4j.nativeblas.Nd4jCpu$half_divide_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_dropout**
- class **org.nd4j.nativeblas.Nd4jCpu$half_dynamic_bidirectional_rnn**
- class **org.nd4j.nativeblas.Nd4jCpu$half_dynamic_partition**
- class **org.nd4j.nativeblas.Nd4jCpu$half_dynamic_rnn**
- class **org.nd4j.nativeblas.Nd4jCpu$half_dynamic_stitch**
- class **org.nd4j.nativeblas.Nd4jCpu$half_elu**
- class **org.nd4j.nativeblas.Nd4jCpu$half_elu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_embedding_lookup**
- class **org.nd4j.nativeblas.Nd4jCpu$half_eq_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$half_equals**
- class **org.nd4j.nativeblas.Nd4jCpu$half_expand_dims**
- class **org.nd4j.nativeblas.Nd4jCpu$half_expose**
- class **org.nd4j.nativeblas.Nd4jCpu$half_extract_image_patches**
- class **org.nd4j.nativeblas.Nd4jCpu$half_eye**
- class **org.nd4j.nativeblas.Nd4jCpu$half_fill**
- class **org.nd4j.nativeblas.Nd4jCpu$half_fill_as**
- class **org.nd4j.nativeblas.Nd4jCpu$half_firas_sparse**
- class **org.nd4j.nativeblas.Nd4jCpu$half_floordiv**
- class **org.nd4j.nativeblas.Nd4jCpu$half_floordiv_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_floormod**
- class **org.nd4j.nativeblas.Nd4jCpu$half_floormod_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_fullconv3d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_fullconv3d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_fullconv3d_grad**
- class **org.nd4j.nativeblas.Nd4jCpu$half_fused_batch_norm**
- class **org.nd4j.nativeblas.Nd4jCpu$half_gather**
- class **org.nd4j.nativeblas.Nd4jCpu$half_gather_list**
- class **org.nd4j.nativeblas.Nd4jCpu$half_gather_nd**
- class **org.nd4j.nativeblas.Nd4jCpu$half_get_seed**
- class **org.nd4j.nativeblas.Nd4jCpu$half_greater**
- class **org.nd4j.nativeblas.Nd4jCpu$half_greater_equal**
- class **org.nd4j.nativeblas.Nd4jCpu$half_gru**
- class **org.nd4j.nativeblas.Nd4jCpu$half_gruCell**
- class **org.nd4j.nativeblas.Nd4jCpu$half_gt_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$half_gte_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$half_hardsigmoid**
- class **org.nd4j.nativeblas.Nd4jCpu$half_hardsigmoid_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_hardtanh**
- class **org.nd4j.nativeblas.Nd4jCpu$half_hardtanh_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_hinge_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$half_huber_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$half_identity**
- class **org.nd4j.nativeblas.Nd4jCpu$half_identity_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_im2col**
- class **org.nd4j.nativeblas.Nd4jCpu$half_im2col_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_in_top_k**
- class **org.nd4j.nativeblas.Nd4jCpu$half_invert_permutation**
- class **org.nd4j.nativeblas.Nd4jCpu$half_is_non_decreasing**
- class **org.nd4j.nativeblas.Nd4jCpu$half_is_numeric_tensor**
- class **org.nd4j.nativeblas.Nd4jCpu$half_is_strictly_increasing**
- class **org.nd4j.nativeblas.Nd4jCpu$half_ismax**
- class **org.nd4j.nativeblas.Nd4jCpu$half_l2_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$half_less**
- class **org.nd4j.nativeblas.Nd4jCpu$half_less_equal**
- class **org.nd4j.nativeblas.Nd4jCpu$half_listdiff**
- class **org.nd4j.nativeblas.Nd4jCpu$half_log_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$half_log_poison_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$half_log_softmax**
- class **org.nd4j.nativeblas.Nd4jCpu$half_log_softmax_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_lrelu**
- class **org.nd4j.nativeblas.Nd4jCpu$half_lrelu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_lrn**
- class **org.nd4j.nativeblas.Nd4jCpu$half_lrn_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_lrn_old**
- class **org.nd4j.nativeblas.Nd4jCpu$half_lstm**
- class **org.nd4j.nativeblas.Nd4jCpu$half_lstmCell**
- class **org.nd4j.nativeblas.Nd4jCpu$half_lt_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$half_lte_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$half_matmul**
- class **org.nd4j.nativeblas.Nd4jCpu$half_matrix_determinant**
- class **org.nd4j.nativeblas.Nd4jCpu$half_matrix_diag**
- class **org.nd4j.nativeblas.Nd4jCpu$half_matrix_diag_part**
- class **org.nd4j.nativeblas.Nd4jCpu$half_matrix_inverse**
- class **org.nd4j.nativeblas.Nd4jCpu$half_matrix_set_diag**
- class **org.nd4j.nativeblas.Nd4jCpu$half_max_pool_with_argmax**
- class **org.nd4j.nativeblas.Nd4jCpu$half_maximum**
- class **org.nd4j.nativeblas.Nd4jCpu$half_maximum_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_maxpool2d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_maxpool2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_maxpool3d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_maxpool3d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_maxpool3dnew**
- class **org.nd4j.nativeblas.Nd4jCpu$half_maxpool3dnew_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_mean_pairwssqerr_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$half_mean_sqerr_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$half_mergeadd**
- class **org.nd4j.nativeblas.Nd4jCpu$half_mergeavg**
- class **org.nd4j.nativeblas.Nd4jCpu$half_mergemax**
- class **org.nd4j.nativeblas.Nd4jCpu$half_mergemaxindex**
- class **org.nd4j.nativeblas.Nd4jCpu$half_meshgrid**
- class **org.nd4j.nativeblas.Nd4jCpu$half_minimum**
- class **org.nd4j.nativeblas.Nd4jCpu$half_minimum_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_mirror_pad**
- class **org.nd4j.nativeblas.Nd4jCpu$half_mod**
- class **org.nd4j.nativeblas.Nd4jCpu$half_mod_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_moments**
- class **org.nd4j.nativeblas.Nd4jCpu$half_multiply**
- class **org.nd4j.nativeblas.Nd4jCpu$half_multiply_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_neq_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$half_noop**
- class **org.nd4j.nativeblas.Nd4jCpu$half_norm**
- class **org.nd4j.nativeblas.Nd4jCpu$half_normalize_moments**
- class **org.nd4j.nativeblas.Nd4jCpu$half_not_equals**
- class **org.nd4j.nativeblas.Nd4jCpu$half_onehot**
- class **org.nd4j.nativeblas.Nd4jCpu$half_ones_as**
- class **org.nd4j.nativeblas.Nd4jCpu$half_order**
- class **org.nd4j.nativeblas.Nd4jCpu$half_pad**
- class **org.nd4j.nativeblas.Nd4jCpu$half_parallel_stack**
- class **org.nd4j.nativeblas.Nd4jCpu$half_percentile**
- class **org.nd4j.nativeblas.Nd4jCpu$half_permute**
- class **org.nd4j.nativeblas.Nd4jCpu$half_pick_list**
- class **org.nd4j.nativeblas.Nd4jCpu$half_pnormpool2d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_pnormpool2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_pointwise_conv2d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_polygamma**
- class **org.nd4j.nativeblas.Nd4jCpu$half_pooling2d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_prelu**
- class **org.nd4j.nativeblas.Nd4jCpu$half_prelu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_random_bernoulli**
- class **org.nd4j.nativeblas.Nd4jCpu$half_random_crop**
- class **org.nd4j.nativeblas.Nd4jCpu$half_random_exponential**
- class **org.nd4j.nativeblas.Nd4jCpu$half_random_normal**
- class **org.nd4j.nativeblas.Nd4jCpu$half_random_shuffle**
- class **org.nd4j.nativeblas.Nd4jCpu$half_randomuniform**
- class **org.nd4j.nativeblas.Nd4jCpu$half_range**
- class **org.nd4j.nativeblas.Nd4jCpu$half_rank**
- class **org.nd4j.nativeblas.Nd4jCpu$half_rationaltanh**
- class **org.nd4j.nativeblas.Nd4jCpu$half_rationaltanh_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_read_list**
- class **org.nd4j.nativeblas.Nd4jCpu$half_realdiv**
- class **org.nd4j.nativeblas.Nd4jCpu$half_realdiv_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_rectifiedtanh**
- class **org.nd4j.nativeblas.Nd4jCpu$half_rectifiedtanh_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_dot_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_max**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_max_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_mean**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_mean_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_min**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_min_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_norm1**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_norm1_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_norm2**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_norm2_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_norm_max**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_norm_max_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_prod**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_prod_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_sqnorm**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_sqnorm_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_stdev**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_stdev_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_sum**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_sum_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_variance**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reduce_variance_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_relu**
- class **org.nd4j.nativeblas.Nd4jCpu$half_relu6**
- class **org.nd4j.nativeblas.Nd4jCpu$half_relu6_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_relu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_relu_layer**
- class **org.nd4j.nativeblas.Nd4jCpu$half_repeat**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reshape**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reshapeas**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reverse**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reverse_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reverse_sequence**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reversedivide**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reversedivide_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reversemod**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reversemod_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reversesubtract**
- class **org.nd4j.nativeblas.Nd4jCpu$half_reversesubtract_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_rint**
- class **org.nd4j.nativeblas.Nd4jCpu$half_roll**
- class **org.nd4j.nativeblas.Nd4jCpu$half_scatter_add**
- class **org.nd4j.nativeblas.Nd4jCpu$half_scatter_div**
- class **org.nd4j.nativeblas.Nd4jCpu$half_scatter_list**
- class **org.nd4j.nativeblas.Nd4jCpu$half_scatter_max**
- class **org.nd4j.nativeblas.Nd4jCpu$half_scatter_min**
- class **org.nd4j.nativeblas.Nd4jCpu$half_scatter_mul**
- class **org.nd4j.nativeblas.Nd4jCpu$half_scatter_sub**
- class **org.nd4j.nativeblas.Nd4jCpu$half_scatter_upd**
- class **org.nd4j.nativeblas.Nd4jCpu$half_scatter_update**
- class **org.nd4j.nativeblas.Nd4jCpu$half_sconv2d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_sconv2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_segment_max**
- class **org.nd4j.nativeblas.Nd4jCpu$half_segment_mean**
- class **org.nd4j.nativeblas.Nd4jCpu$half_segment_min**
- class **org.nd4j.nativeblas.Nd4jCpu$half_segment_prod**
- class **org.nd4j.nativeblas.Nd4jCpu$half_segment_sum**
- class **org.nd4j.nativeblas.Nd4jCpu$half_select**
- class **org.nd4j.nativeblas.Nd4jCpu$half_selu**
- class **org.nd4j.nativeblas.Nd4jCpu$half_selu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_sequence_mask**
- class **org.nd4j.nativeblas.Nd4jCpu$half_set_seed**
- class **org.nd4j.nativeblas.Nd4jCpu$half_shape_of**
- class **org.nd4j.nativeblas.Nd4jCpu$half_shapes_of**
- class **org.nd4j.nativeblas.Nd4jCpu$half_sigm_cross_entropy_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$half_sigmoid**
- class **org.nd4j.nativeblas.Nd4jCpu$half_sigmoid_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_size**
- class **org.nd4j.nativeblas.Nd4jCpu$half_size_at**
- class **org.nd4j.nativeblas.Nd4jCpu$half_size_list**
- class **org.nd4j.nativeblas.Nd4jCpu$half_slice**
- class **org.nd4j.nativeblas.Nd4jCpu$half_slice_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_softmax**
- class **org.nd4j.nativeblas.Nd4jCpu$half_softmax_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_softmax_cross_entropy_loss**
- class **org.nd4j.nativeblas.Nd4jCpu$half_softmax_cross_entropy_loss_with_logits**
- class **org.nd4j.nativeblas.Nd4jCpu$half_softplus**
- class **org.nd4j.nativeblas.Nd4jCpu$half_softplus_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_softsign**
- class **org.nd4j.nativeblas.Nd4jCpu$half_softsign_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_space_to_batch**
- class **org.nd4j.nativeblas.Nd4jCpu$half_space_to_depth**
- class **org.nd4j.nativeblas.Nd4jCpu$half_split**
- class **org.nd4j.nativeblas.Nd4jCpu$half_split_list**
- class **org.nd4j.nativeblas.Nd4jCpu$half_split_v**
- class **org.nd4j.nativeblas.Nd4jCpu$half_square**
- class **org.nd4j.nativeblas.Nd4jCpu$half_squaredsubtract**
- class **org.nd4j.nativeblas.Nd4jCpu$half_squaredsubtract_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_squeeze**
- class **org.nd4j.nativeblas.Nd4jCpu$half_sru**
- class **org.nd4j.nativeblas.Nd4jCpu$half_sruCell**
- class **org.nd4j.nativeblas.Nd4jCpu$half_sru_bi**
- class **org.nd4j.nativeblas.Nd4jCpu$half_sru_bi_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_sru_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_sru_bp_logic**
- class **org.nd4j.nativeblas.Nd4jCpu$half_sru_logic**
- class **org.nd4j.nativeblas.Nd4jCpu$half_sru_old**
- class **org.nd4j.nativeblas.Nd4jCpu$half_stack**
- class **org.nd4j.nativeblas.Nd4jCpu$half_stack_list**
- class **org.nd4j.nativeblas.Nd4jCpu$half_static_bidirectional_rnn**
- class **org.nd4j.nativeblas.Nd4jCpu$half_static_rnn**
- class **org.nd4j.nativeblas.Nd4jCpu$half_stop_gradient**
- class **org.nd4j.nativeblas.Nd4jCpu$half_strided_slice**
- class **org.nd4j.nativeblas.Nd4jCpu$half_strided_slice_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_subtract**
- class **org.nd4j.nativeblas.Nd4jCpu$half_subtract_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_sufficient_statistics**
- class **org.nd4j.nativeblas.Nd4jCpu$half_svd**
- class **org.nd4j.nativeblas.Nd4jCpu$half_tanh**
- class **org.nd4j.nativeblas.Nd4jCpu$half_tanh_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_tear**
- class **org.nd4j.nativeblas.Nd4jCpu$half_tensormmul**
- class **org.nd4j.nativeblas.Nd4jCpu$half_test_output_reshape**
- class **org.nd4j.nativeblas.Nd4jCpu$half_test_scalar**
- class **org.nd4j.nativeblas.Nd4jCpu$half_testcustom**
- class **org.nd4j.nativeblas.Nd4jCpu$half_testop2i2o**
- class **org.nd4j.nativeblas.Nd4jCpu$half_testreduction**
- class **org.nd4j.nativeblas.Nd4jCpu$half_tf_atan2**
- class **org.nd4j.nativeblas.Nd4jCpu$half_thresholdedrelu**
- class **org.nd4j.nativeblas.Nd4jCpu$half_thresholdedrelu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_tile**
- class **org.nd4j.nativeblas.Nd4jCpu$half_tile_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_tile_to_shape**
- class **org.nd4j.nativeblas.Nd4jCpu$half_tile_to_shape_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_to_double**
- class **org.nd4j.nativeblas.Nd4jCpu$half_to_float16**
- class **org.nd4j.nativeblas.Nd4jCpu$half_to_float32**
- class **org.nd4j.nativeblas.Nd4jCpu$half_to_int32**
- class **org.nd4j.nativeblas.Nd4jCpu$half_to_int64**
- class **org.nd4j.nativeblas.Nd4jCpu$half_to_uint32**
- class **org.nd4j.nativeblas.Nd4jCpu$half_to_uint64**
- class **org.nd4j.nativeblas.Nd4jCpu$half_toggle_bits**
- class **org.nd4j.nativeblas.Nd4jCpu$half_top_k**
- class **org.nd4j.nativeblas.Nd4jCpu$half_trace**
- class **org.nd4j.nativeblas.Nd4jCpu$half_transpose**
- class **org.nd4j.nativeblas.Nd4jCpu$half_tri**
- class **org.nd4j.nativeblas.Nd4jCpu$half_triu**
- class **org.nd4j.nativeblas.Nd4jCpu$half_triu_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_truncatediv**
- class **org.nd4j.nativeblas.Nd4jCpu$half_unique**
- class **org.nd4j.nativeblas.Nd4jCpu$half_unique_with_counts**
- class **org.nd4j.nativeblas.Nd4jCpu$half_unstack**
- class **org.nd4j.nativeblas.Nd4jCpu$half_unstack_list**
- class **org.nd4j.nativeblas.Nd4jCpu$half_upsampling2d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_upsampling2d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_upsampling3d**
- class **org.nd4j.nativeblas.Nd4jCpu$half_upsampling3d_bp**
- class **org.nd4j.nativeblas.Nd4jCpu$half_weighted_cross_entropy_with_logits**
- class **org.nd4j.nativeblas.Nd4jCpu$half_where_np**
- class **org.nd4j.nativeblas.Nd4jCpu$half_write_list**
- class **org.nd4j.nativeblas.Nd4jCpu$half_xw_plus_b**
- class **org.nd4j.nativeblas.Nd4jCpu$half_zero_fraction**
- class **org.nd4j.nativeblas.Nd4jCpu$half_zeros_as**
- class **org.nd4j.nativeblas.Nd4jCpu$half_zeta**
- class **org.nd4j.nativeblas.Nd4jCpu**
- class **org.nd4j.nativeblas.Nd4jCpuPresets**
- class **org.nd4j.nativeblas.Nd4jCuda$ArgumentsList**
- class **org.nd4j.nativeblas.Nd4jCuda$CurrentIndexing**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleBooleanOp**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleBroadcastableOp**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleContext**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleContextPrototype**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleDeclarableCustomOp**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleDeclarableListOp**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleDeclarableOp**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleDeclarableReductionOp**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleGraphState**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleLogicOp**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleNDArray**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleNDArrayList**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleNDArrayVector$Iterator**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleNDArrayVector**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleOpArgsHolder**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleResultSet**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleStash**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleVariable**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleVariableSpace**
- class **org.nd4j.nativeblas.Nd4jCuda$DoubleVariablesSet**
- class **org.nd4j.nativeblas.Nd4jCuda$ExternalWorkspace**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatBooleanOp**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatBroadcastableOp**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatContext**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatContextPrototype**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatDeclarableCustomOp**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatDeclarableListOp**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatDeclarableOp**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatDeclarableReductionOp**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatGraphState**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatLogicOp**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatNDArray**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatNDArrayList**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatNDArrayVector$Iterator**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatNDArrayVector**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatOpArgsHolder**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatResultSet**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatStash**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatVariable**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatVariableSpace**
- class **org.nd4j.nativeblas.Nd4jCuda$FloatVariablesSet**
- class **org.nd4j.nativeblas.Nd4jCuda$FlowPath**
- class **org.nd4j.nativeblas.Nd4jCuda$GraphProfile**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfBooleanOp**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfBroadcastableOp**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfContext**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfContextPrototype**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfDeclarableCustomOp**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfDeclarableListOp**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfDeclarableOp**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfDeclarableReductionOp**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfGraphState**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfLogicOp**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfNDArray**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfNDArrayList**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfNDArrayVector$Iterator**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfNDArrayVector**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfOpArgsHolder**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfResultSet**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfStash**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfVariable**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfVariableSpace**
- class **org.nd4j.nativeblas.Nd4jCuda$HalfVariablesSet**
- class **org.nd4j.nativeblas.Nd4jCuda$IGenerator**
- class **org.nd4j.nativeblas.Nd4jCuda$IndicesList**
- class **org.nd4j.nativeblas.Nd4jCuda$IntIntPair**
- class **org.nd4j.nativeblas.Nd4jCuda$IntVectorVector**
- class **org.nd4j.nativeblas.Nd4jCuda$Intervals**
- class **org.nd4j.nativeblas.Nd4jCuda$KeyPair**
- class **org.nd4j.nativeblas.Nd4jCuda$LongVectorVector**
- class **org.nd4j.nativeblas.Nd4jCuda$NDIndex**
- class **org.nd4j.nativeblas.Nd4jCuda$NDIndexAll**
- class **org.nd4j.nativeblas.Nd4jCuda$NDIndexInterval**
- class **org.nd4j.nativeblas.Nd4jCuda$NDIndexPoint**
- class **org.nd4j.nativeblas.Nd4jCuda$NativeOps**
- class **org.nd4j.nativeblas.Nd4jCuda$NodeProfile**
- class **org.nd4j.nativeblas.Nd4jCuda$OpDescriptor**
- class **org.nd4j.nativeblas.Nd4jCuda$OpRegistrator**
- class **org.nd4j.nativeblas.Nd4jCuda$Pair**
- class **org.nd4j.nativeblas.Nd4jCuda$RandomBuffer**
- class **org.nd4j.nativeblas.Nd4jCuda$ResultWrapper**
- class **org.nd4j.nativeblas.Nd4jCuda$ShapeInformation**
- class **org.nd4j.nativeblas.Nd4jCuda$ShapeList**
- class **org.nd4j.nativeblas.Nd4jCuda$Workspace**
- class **org.nd4j.nativeblas.Nd4jCuda$Xoroshiro128**
- class **org.nd4j.nativeblas.Nd4jCuda$_loader**
- class **org.nd4j.nativeblas.Nd4jCuda**
- class **org.nd4j.nativeblas.Nd4jCudaPresets**
- class **org.nd4j.nativeblas.ResultWrapperAbstraction**
- class **org.nd4j.nativeblas.SparseNd4jBlas**

## Contributors

[Eugene Potapenko](https://github.com/potapenko/)

## License

Distributed under the Eclipse Public License, the same as Clojure.
