(ns jdk.util.AbstractSet
  "This class provides a skeletal implementation of the Set
  interface to minimize the effort required to implement this
  interface.

  The process of implementing a set by extending this class is identical
  to that of implementing a Collection by extending AbstractCollection,
  except that all of the methods and constructors in subclasses of this
  class must obey the additional constraints imposed by the Set
  interface (for instance, the add method must not permit addition of
  multiple instances of an object to a set).

  Note that this class does not override any of the implementations from
  the AbstractCollection class.  It merely adds implementations
  for equals and hashCode.

  This class is a member of the

  Java Collections Framework."
  (:refer-clojure :only [require comment defn ->])
  (:import [java.util AbstractSet]))

(defn equals
  "Compares the specified object with this set for equality.  Returns
   true if the given object is also a set, the two sets have
   the same size, and every member of the given set is contained in
   this set.  This ensures that the equals method works
   properly across different implementations of the Set
   interface.

   This implementation first checks if the specified object is this
   set; if so it returns true.  Then, it checks if the
   specified object is a set whose size is identical to the size of
   this set; if not, it returns false.  If so, it returns
   containsAll((Collection) o).

  o - object to be compared for equality with this set - `java.lang.Object`

  returns: true if the specified object is equal to this set - `boolean`"
  (^Boolean [^java.util.AbstractSet this ^java.lang.Object o]
    (-> this (.equals o))))

(defn hash-code
  "Returns the hash code value for this set.  The hash code of a set is
   defined to be the sum of the hash codes of the elements in the set,
   where the hash code of a null element is defined to be zero.
   This ensures that s1.equals(s2) implies that
   s1.hashCode()==s2.hashCode() for any two sets s1
   and s2, as required by the general contract of
   Object.hashCode().

   This implementation iterates over the set, calling the
   hashCode method on each element in the set, and adding up
   the results.

  returns: the hash code value for this set - `int`"
  (^Integer [^java.util.AbstractSet this]
    (-> this (.hashCode))))

(defn remove-all
  "Removes from this set all of its elements that are contained in the
   specified collection (optional operation).  If the specified
   collection is also a set, this operation effectively modifies this
   set so that its value is the asymmetric set difference of
   the two sets.

   This implementation determines which is the smaller of this set
   and the specified collection, by invoking the size
   method on each.  If this set has fewer elements, then the
   implementation iterates over this set, checking each element
   returned by the iterator in turn to see if it is contained in
   the specified collection.  If it is so contained, it is removed
   from this set with the iterator's remove method.  If
   the specified collection has fewer elements, then the
   implementation iterates over the specified collection, removing
   from this set each element returned by the iterator, using this
   set's remove method.

   Note that this implementation will throw an
   UnsupportedOperationException if the iterator returned by the
   iterator method does not implement the remove method.

  c - collection containing elements to be removed from this set - `java.util.Collection<?>`

  returns: true if this set changed as a result of the call - `boolean`

  throws: java.lang.UnsupportedOperationException - if the removeAll operation is not supported by this set"
  (^Boolean [^java.util.AbstractSet this ^java.util.Collection c]
    (-> this (.removeAll c))))

