(ns jdk.util.SplittableRandom
  "A generator of uniform pseudorandom values applicable for use in
  (among other contexts) isolated parallel computations that may
  generate subtasks. Class SplittableRandom supports methods for
  producing pseudorandom numbers of type int, long,
  and double with similar usages as for class
  Random but differs in the following ways:



  Series of generated values pass the DieHarder suite testing
  independence and uniformity properties of random number generators.
  (Most recently validated with  version
  3.31.1.) These tests validate only the methods for certain
  types and ranges, but similar properties are expected to hold, at
  least approximately, for others as well. The period
  (length of any series of generated values before it repeats) is at
  least 264.

   Method split() constructs and returns a new
  SplittableRandom instance that shares no mutable state with the
  current instance. However, with very high probability, the
  values collectively generated by the two objects have the same
  statistical properties as if the same quantity of values were
  generated by a single thread using a single SplittableRandom object.

  Instances of SplittableRandom are not thread-safe.
  They are designed to be split, not shared, across threads. For
  example, a fork/join-style computation using random numbers might include a
  construction of the form new
  Subtask(aSplittableRandom.split()).fork().

  This class provides additional methods for generating random
  streams, that employ the above techniques when used in stream.parallel() mode.



  Instances of SplittableRandom are not cryptographically
  secure.  Consider instead using SecureRandom
  in security-sensitive applications. Additionally,
  default-constructed instances do not use a cryptographically random
  seed unless the system property
  java.util.secureRandomSeed is set to true."
  (:refer-clojure :only [require comment defn ->])
  (:import [java.util SplittableRandom]))

(defn ->splittable-random
  "Constructor.

  Creates a new SplittableRandom instance using the specified
   initial seed. SplittableRandom instances created with the same
   seed in the same program generate identical sequences of values.

  seed - the initial seed - `long`"
  ([^Long seed]
    (new SplittableRandom seed))
  ([]
    (new SplittableRandom )))

(defn split
  "Constructs and returns a new SplittableRandom instance that
   shares no mutable state with this instance. However, with very
   high probability, the set of values collectively generated by
   the two objects has the same statistical properties as if the
   same quantity of values were generated by a single thread using
   a single SplittableRandom object.  Either or both of the two
   objects may be further split using the split() method,
   and the same expected statistical properties apply to the
   entire set of generators constructed by such recursive
   splitting.

  returns: the new SplittableRandom instance - `java.util.SplittableRandom`"
  ([^java.util.SplittableRandom this]
    (-> this (.split))))

(defn next-int
  "Returns a pseudorandom int value between the specified
   origin (inclusive) and the specified bound (exclusive).

  origin - the least value returned - `int`
  bound - the upper bound (exclusive) - `int`

  returns: a pseudorandom int value between the origin
           (inclusive) and the bound (exclusive) - `int`

  throws: java.lang.IllegalArgumentException - if origin is greater than or equal to bound"
  ([^java.util.SplittableRandom this ^Integer origin ^Integer bound]
    (-> this (.nextInt origin bound)))
  ([^java.util.SplittableRandom this ^Integer bound]
    (-> this (.nextInt bound)))
  ([^java.util.SplittableRandom this]
    (-> this (.nextInt))))

(defn next-long
  "Returns a pseudorandom long value between the specified
   origin (inclusive) and the specified bound (exclusive).

  origin - the least value returned - `long`
  bound - the upper bound (exclusive) - `long`

  returns: a pseudorandom long value between the origin
           (inclusive) and the bound (exclusive) - `long`

  throws: java.lang.IllegalArgumentException - if origin is greater than or equal to bound"
  ([^java.util.SplittableRandom this ^Long origin ^Long bound]
    (-> this (.nextLong origin bound)))
  ([^java.util.SplittableRandom this ^Long bound]
    (-> this (.nextLong bound)))
  ([^java.util.SplittableRandom this]
    (-> this (.nextLong))))

(defn next-double
  "Returns a pseudorandom double value between the specified
   origin (inclusive) and bound (exclusive).

  origin - the least value returned - `double`
  bound - the upper bound (exclusive) - `double`

  returns: a pseudorandom double value between the origin
           (inclusive) and the bound (exclusive) - `double`

  throws: java.lang.IllegalArgumentException - if origin is greater than or equal to bound"
  ([^java.util.SplittableRandom this ^Double origin ^Double bound]
    (-> this (.nextDouble origin bound)))
  ([^java.util.SplittableRandom this ^Double bound]
    (-> this (.nextDouble bound)))
  ([^java.util.SplittableRandom this]
    (-> this (.nextDouble))))

(defn next-boolean
  "Returns a pseudorandom boolean value.

  returns: a pseudorandom boolean value - `boolean`"
  ([^java.util.SplittableRandom this]
    (-> this (.nextBoolean))))

(defn ints
  "Returns a stream producing the given streamSize number
   of pseudorandom int values from this generator and/or one split
   from it; each value conforms to the given origin (inclusive) and bound
   (exclusive).

  stream-size - the number of values to generate - `long`
  random-number-origin - the origin (inclusive) of each random value - `int`
  random-number-bound - the bound (exclusive) of each random value - `int`

  returns: a stream of pseudorandom int values,
           each with the given origin (inclusive) and bound (exclusive) - `java.util.stream.IntStream`

  throws: java.lang.IllegalArgumentException - if streamSize is less than zero, or randomNumberOrigin is greater than or equal to randomNumberBound"
  ([^java.util.SplittableRandom this ^Long stream-size ^Integer random-number-origin ^Integer random-number-bound]
    (-> this (.ints stream-size random-number-origin random-number-bound)))
  ([^java.util.SplittableRandom this ^Integer random-number-origin ^Integer random-number-bound]
    (-> this (.ints random-number-origin random-number-bound)))
  ([^java.util.SplittableRandom this ^Long stream-size]
    (-> this (.ints stream-size)))
  ([^java.util.SplittableRandom this]
    (-> this (.ints))))

(defn longs
  "Returns a stream producing the given streamSize number of
   pseudorandom long values from this generator and/or one split
   from it; each value conforms to the given origin (inclusive) and bound
   (exclusive).

  stream-size - the number of values to generate - `long`
  random-number-origin - the origin (inclusive) of each random value - `long`
  random-number-bound - the bound (exclusive) of each random value - `long`

  returns: a stream of pseudorandom long values,
           each with the given origin (inclusive) and bound (exclusive) - `java.util.stream.LongStream`

  throws: java.lang.IllegalArgumentException - if streamSize is less than zero, or randomNumberOrigin is greater than or equal to randomNumberBound"
  ([^java.util.SplittableRandom this ^Long stream-size ^Long random-number-origin ^Long random-number-bound]
    (-> this (.longs stream-size random-number-origin random-number-bound)))
  ([^java.util.SplittableRandom this ^Long random-number-origin ^Long random-number-bound]
    (-> this (.longs random-number-origin random-number-bound)))
  ([^java.util.SplittableRandom this ^Long stream-size]
    (-> this (.longs stream-size)))
  ([^java.util.SplittableRandom this]
    (-> this (.longs))))

(defn doubles
  "Returns a stream producing the given streamSize number of
   pseudorandom double values from this generator and/or one split
   from it; each value conforms to the given origin (inclusive) and bound
   (exclusive).

  stream-size - the number of values to generate - `long`
  random-number-origin - the origin (inclusive) of each random value - `double`
  random-number-bound - the bound (exclusive) of each random value - `double`

  returns: a stream of pseudorandom double values,
           each with the given origin (inclusive) and bound (exclusive) - `java.util.stream.DoubleStream`

  throws: java.lang.IllegalArgumentException - if randomNumberOrigin is greater than or equal to randomNumberBound"
  ([^java.util.SplittableRandom this ^Long stream-size ^Double random-number-origin ^Double random-number-bound]
    (-> this (.doubles stream-size random-number-origin random-number-bound)))
  ([^java.util.SplittableRandom this ^Double random-number-origin ^Double random-number-bound]
    (-> this (.doubles random-number-origin random-number-bound)))
  ([^java.util.SplittableRandom this ^Long stream-size]
    (-> this (.doubles stream-size)))
  ([^java.util.SplittableRandom this]
    (-> this (.doubles))))

