(ns jdk.time.ZoneOffset
  "A time-zone offset from Greenwich/UTC, such as +02:00.

  A time-zone offset is the amount of time that a time-zone differs from Greenwich/UTC.
  This is usually a fixed number of hours and minutes.

  Different parts of the world have different time-zone offsets.
  The rules for how offsets vary by place and time of year are captured in the
  ZoneId class.

  For example, Paris is one hour ahead of Greenwich/UTC in winter and two hours
  ahead in summer. The ZoneId instance for Paris will reference two
  ZoneOffset instances - a +01:00 instance for winter,
  and a +02:00 instance for summer.

  In 2008, time-zone offsets around the world extended from -12:00 to 14:00.
  To prevent any problems with that range being extended, yet still provide
  validation, the range of offsets is restricted to -18:00 to 18:00 inclusive.

  This class is designed for use with the ISO calendar system.
  The fields of hours, minutes and seconds make assumptions that are valid for the
  standard ISO definitions of those fields. This class may be used with other
  calendar systems providing the definition of the time fields matches those
  of the ISO calendar system.

  Instances of ZoneOffset must be compared using equals(java.lang.Object).
  Implementations may choose to cache certain common offsets, however
  applications must not rely on such caching.


  This is a value-based
  class; use of identity-sensitive operations (including reference equality
  (==), identity hash code, or synchronization) on instances of
  ZoneOffset may have unpredictable results and should be avoided.
  The equals method should be used for comparisons."
  (:refer-clojure :only [require comment defn ->])
  (:import [java.time ZoneOffset]))

(def *-utc
  "Static Constant.

  The time-zone offset for UTC, with an ID of 'Z'.

  type: java.time.ZoneOffset"
  ZoneOffset/UTC)

(def *-min
  "Static Constant.

  Constant for the maximum supported offset.

  type: java.time.ZoneOffset"
  ZoneOffset/MIN)

(def *-max
  "Static Constant.

  Constant for the maximum supported offset.

  type: java.time.ZoneOffset"
  ZoneOffset/MAX)

(defn *of
  "Obtains an instance of ZoneOffset using the ID.

   This method parses the string ID of a ZoneOffset to
   return an instance. The parsing accepts all the formats generated by
   getId(), plus some additional formats:

   Z - for UTC
   +h
   +hh
   +hh:mm
   -hh:mm
   +hhmm
   -hhmm
   +hh:mm:ss
   -hh:mm:ss
   +hhmmss
   -hhmmss

   Note that ± means either the plus or minus symbol.

   The ID of the returned offset will be normalized to one of the formats
   described by getId().

   The maximum supported range is from 18:00 to -18:00 inclusive.

  offset-id - the offset ID, not null - `java.lang.String`

  returns: the zone-offset, not null - `java.time.ZoneOffset`

  throws: java.time.DateTimeException - if the offset ID is invalid"
  (^java.time.ZoneOffset [^java.lang.String offset-id]
    (ZoneOffset/of offset-id)))

(defn *of-hours
  "Obtains an instance of ZoneOffset using an offset in hours.

  hours - the time-zone offset in hours, from -18 to 18 - `int`

  returns: the zone-offset, not null - `java.time.ZoneOffset`

  throws: java.time.DateTimeException - if the offset is not in the required range"
  (^java.time.ZoneOffset [^Integer hours]
    (ZoneOffset/ofHours hours)))

(defn *of-hours-minutes
  "Obtains an instance of ZoneOffset using an offset in
   hours and minutes.

   The sign of the hours and minutes components must match.
   Thus, if the hours is negative, the minutes must be negative or zero.
   If the hours is zero, the minutes may be positive, negative or zero.

  hours - the time-zone offset in hours, from -18 to 18 - `int`
  minutes - the time-zone offset in minutes, from 0 to ±59, sign matches hours - `int`

  returns: the zone-offset, not null - `java.time.ZoneOffset`

  throws: java.time.DateTimeException - if the offset is not in the required range"
  (^java.time.ZoneOffset [^Integer hours ^Integer minutes]
    (ZoneOffset/ofHoursMinutes hours minutes)))

(defn *of-hours-minutes-seconds
  "Obtains an instance of ZoneOffset using an offset in
   hours, minutes and seconds.

   The sign of the hours, minutes and seconds components must match.
   Thus, if the hours is negative, the minutes and seconds must be negative or zero.

  hours - the time-zone offset in hours, from -18 to 18 - `int`
  minutes - the time-zone offset in minutes, from 0 to ±59, sign matches hours and seconds - `int`
  seconds - the time-zone offset in seconds, from 0 to ±59, sign matches hours and minutes - `int`

  returns: the zone-offset, not null - `java.time.ZoneOffset`

  throws: java.time.DateTimeException - if the offset is not in the required range"
  (^java.time.ZoneOffset [^Integer hours ^Integer minutes ^Integer seconds]
    (ZoneOffset/ofHoursMinutesSeconds hours minutes seconds)))

(defn *from
  "Obtains an instance of ZoneOffset from a temporal object.

   This obtains an offset based on the specified temporal.
   A TemporalAccessor represents an arbitrary set of date and time information,
   which this factory converts to an instance of ZoneOffset.

   A TemporalAccessor represents some form of date and time information.
   This factory converts the arbitrary temporal object to an instance of ZoneOffset.

   The conversion uses the TemporalQueries.offset() query, which relies
   on extracting the OFFSET_SECONDS field.

   This method matches the signature of the functional interface TemporalQuery
   allowing it to be used as a query via method reference, ZoneOffset::from.

  temporal - the temporal object to convert, not null - `java.time.temporal.TemporalAccessor`

  returns: the zone-offset, not null - `java.time.ZoneOffset`

  throws: java.time.DateTimeException - if unable to convert to an ZoneOffset"
  (^java.time.ZoneOffset [^java.time.temporal.TemporalAccessor temporal]
    (ZoneOffset/from temporal)))

(defn *of-total-seconds
  "Obtains an instance of ZoneOffset specifying the total offset in seconds

   The offset must be in the range -18:00 to +18:00, which corresponds to -64800 to 64800.

  total-seconds - the total time-zone offset in seconds, from -64800 to 64800 - `int`

  returns: the ZoneOffset, not null - `java.time.ZoneOffset`

  throws: java.time.DateTimeException - if the offset is not in the required range"
  (^java.time.ZoneOffset [^Integer total-seconds]
    (ZoneOffset/ofTotalSeconds total-seconds)))

(defn range
  "Gets the range of valid values for the specified field.

   The range object expresses the minimum and maximum valid values for a field.
   This offset is used to enhance the accuracy of the returned range.
   If it is not possible to return the range, because the field is not supported
   or for some other reason, an exception is thrown.

   If the field is a ChronoField then the query is implemented here.
   The supported fields will return
   appropriate range instances.
   All other ChronoField instances will throw an UnsupportedTemporalTypeException.

   If the field is not a ChronoField, then the result of this method
   is obtained by invoking TemporalField.rangeRefinedBy(TemporalAccessor)
   passing this as the argument.
   Whether the range can be obtained is determined by the field.

  field - the field to query the range for, not null - `java.time.temporal.TemporalField`

  returns: the range of valid values for the field, not null - `java.time.temporal.ValueRange`

  throws: java.time.DateTimeException - if the range for the field cannot be obtained"
  (^java.time.temporal.ValueRange [^ZoneOffset this ^java.time.temporal.TemporalField field]
    (-> this (.range field))))

(defn query
  "Queries this offset using the specified query.

   This queries this offset using the specified query strategy object.
   The TemporalQuery object defines the logic to be used to
   obtain the result. Read the documentation of the query to understand
   what the result of this method will be.

   The result of this method is obtained by invoking the
   TemporalQuery.queryFrom(TemporalAccessor) method on the
   specified query passing this as the argument.

  query - the query to invoke, not null - `java.time.temporal.TemporalQuery`

  returns: the query result, null may be returned (defined by the query) - `<R> R`

  throws: java.time.DateTimeException - if unable to query (defined by the query)"
  ([^ZoneOffset this ^java.time.temporal.TemporalQuery query]
    (-> this (.query query))))

(defn to-string
  "Outputs this offset as a String, using the normalized ID.

  returns: a string representation of this offset, not null - `java.lang.String`"
  (^java.lang.String [^ZoneOffset this]
    (-> this (.toString))))

(defn get-long
  "Gets the value of the specified field from this offset as a long.

   This queries this offset for the value of the specified field.
   If it is not possible to return the value, because the field is not supported
   or for some other reason, an exception is thrown.

   If the field is a ChronoField then the query is implemented here.
   The OFFSET_SECONDS field returns the value of the offset.
   All other ChronoField instances will throw an UnsupportedTemporalTypeException.

   If the field is not a ChronoField, then the result of this method
   is obtained by invoking TemporalField.getFrom(TemporalAccessor)
   passing this as the argument. Whether the value can be obtained,
   and what the value represents, is determined by the field.

  field - the field to get, not null - `java.time.temporal.TemporalField`

  returns: the value for the field - `long`

  throws: java.time.DateTimeException - if a value for the field cannot be obtained"
  (^Long [^ZoneOffset this ^java.time.temporal.TemporalField field]
    (-> this (.getLong field))))

(defn get-rules
  "Gets the associated time-zone rules.

   The rules will always return this offset when queried.
   The implementation class is immutable, thread-safe and serializable.

  returns: the rules, not null - `java.time.zone.ZoneRules`"
  (^java.time.zone.ZoneRules [^ZoneOffset this]
    (-> this (.getRules))))

(defn get-id
  "Gets the normalized zone offset ID.

   The ID is minor variation to the standard ISO-8601 formatted string
   for the offset. There are three formats:

   Z - for UTC (ISO-8601)
   +hh:mm or -hh:mm - if the seconds are zero (ISO-8601)
   +hh:mm:ss or -hh:mm:ss - if the seconds are non-zero (not ISO-8601)

  returns: the zone offset ID, not null - `java.lang.String`"
  (^java.lang.String [^ZoneOffset this]
    (-> this (.getId))))

(defn supported?
  "Checks if the specified field is supported.

   This checks if this offset can be queried for the specified field.
   If false, then calling the range and
   get methods will throw an exception.

   If the field is a ChronoField then the query is implemented here.
   The OFFSET_SECONDS field returns true.
   All other ChronoField instances will return false.

   If the field is not a ChronoField, then the result of this method
   is obtained by invoking TemporalField.isSupportedBy(TemporalAccessor)
   passing this as the argument.
   Whether the field is supported is determined by the field.

  field - the field to check, null returns false - `java.time.temporal.TemporalField`

  returns: true if the field is supported on this offset, false if not - `boolean`"
  (^Boolean [^ZoneOffset this ^java.time.temporal.TemporalField field]
    (-> this (.isSupported field))))

(defn hash-code
  "A hash code for this offset.

  returns: a suitable hash code - `int`"
  (^Integer [^ZoneOffset this]
    (-> this (.hashCode))))

(defn get-total-seconds
  "Gets the total zone offset in seconds.

   This is the primary way to access the offset amount.
   It returns the total of the hours, minutes and seconds fields as a
   single offset that can be added to a time.

  returns: the total zone offset amount in seconds - `int`"
  (^Integer [^ZoneOffset this]
    (-> this (.getTotalSeconds))))

(defn adjust-into
  "Adjusts the specified temporal object to have the same offset as this object.

   This returns a temporal object of the same observable type as the input
   with the offset changed to be the same as this.

   The adjustment is equivalent to using Temporal.with(TemporalField, long)
   passing ChronoField.OFFSET_SECONDS as the field.

   In most cases, it is clearer to reverse the calling pattern by using
   Temporal.with(TemporalAdjuster):


     // these two lines are equivalent, but the second approach is recommended
     temporal = thisOffset.adjustInto(temporal);
     temporal = temporal.with(thisOffset);

   This instance is immutable and unaffected by this method call.

  temporal - the target object to be adjusted, not null - `java.time.temporal.Temporal`

  returns: the adjusted object, not null - `java.time.temporal.Temporal`

  throws: java.time.DateTimeException - if unable to make the adjustment"
  (^java.time.temporal.Temporal [^ZoneOffset this ^java.time.temporal.Temporal temporal]
    (-> this (.adjustInto temporal))))

(defn compare-to
  "Compares this offset to another offset in descending order.

   The offsets are compared in the order that they occur for the same time
   of day around the world. Thus, an offset of +10:00 comes before an
   offset of +09:00 and so on down to -18:00.

   The comparison is `consistent with equals`, as defined by Comparable.

  other - the other date to compare to, not null - `java.time.ZoneOffset`

  returns: the comparator value, negative if less, positive if greater - `int`

  throws: java.lang.NullPointerException - if other is null"
  (^Integer [^ZoneOffset this ^java.time.ZoneOffset other]
    (-> this (.compareTo other))))

(defn get
  "Gets the value of the specified field from this offset as an int.

   This queries this offset for the value of the specified field.
   The returned value will always be within the valid range of values for the field.
   If it is not possible to return the value, because the field is not supported
   or for some other reason, an exception is thrown.

   If the field is a ChronoField then the query is implemented here.
   The OFFSET_SECONDS field returns the value of the offset.
   All other ChronoField instances will throw an UnsupportedTemporalTypeException.

   If the field is not a ChronoField, then the result of this method
   is obtained by invoking TemporalField.getFrom(TemporalAccessor)
   passing this as the argument. Whether the value can be obtained,
   and what the value represents, is determined by the field.

  field - the field to get, not null - `java.time.temporal.TemporalField`

  returns: the value for the field - `int`

  throws: java.time.DateTimeException - if a value for the field cannot be obtained or the value is outside the range of valid values for the field"
  (^Integer [^ZoneOffset this ^java.time.temporal.TemporalField field]
    (-> this (.get field))))

(defn equals
  "Checks if this offset is equal to another offset.

   The comparison is based on the amount of the offset in seconds.
   This is equivalent to a comparison by ID.

  obj - the object to check, null returns false - `java.lang.Object`

  returns: true if this is equal to the other offset - `boolean`"
  (^Boolean [^ZoneOffset this ^java.lang.Object obj]
    (-> this (.equals obj))))

