(ns jdk.text.NumberFormat$Field
  "Defines constants that are used as attribute keys in the
  AttributedCharacterIterator returned
  from NumberFormat.formatToCharacterIterator and as
  field identifiers in FieldPosition."
  (:refer-clojure :only [require comment defn ->])
  (:import [java.text NumberFormat$Field]))

(def *-integer
  "Static Constant.

  Constant identifying the integer field.

  type: java.text.NumberFormat$Field"
  NumberFormat$Field/INTEGER)

(def *-fraction
  "Static Constant.

  Constant identifying the fraction field.

  type: java.text.NumberFormat$Field"
  NumberFormat$Field/FRACTION)

(def *-exponent
  "Static Constant.

  Constant identifying the exponent field.

  type: java.text.NumberFormat$Field"
  NumberFormat$Field/EXPONENT)

(def *-decimal-separator
  "Static Constant.

  Constant identifying the decimal separator field.

  type: java.text.NumberFormat$Field"
  NumberFormat$Field/DECIMAL_SEPARATOR)

(def *-sign
  "Static Constant.

  Constant identifying the sign field.

  type: java.text.NumberFormat$Field"
  NumberFormat$Field/SIGN)

(def *-grouping-separator
  "Static Constant.

  Constant identifying the grouping separator field.

  type: java.text.NumberFormat$Field"
  NumberFormat$Field/GROUPING_SEPARATOR)

(def *-exponent-symbol
  "Static Constant.

  Constant identifying the exponent symbol field.

  type: java.text.NumberFormat$Field"
  NumberFormat$Field/EXPONENT_SYMBOL)

(def *-percent
  "Static Constant.

  Constant identifying the percent field.

  type: java.text.NumberFormat$Field"
  NumberFormat$Field/PERCENT)

(def *-permille
  "Static Constant.

  Constant identifying the permille field.

  type: java.text.NumberFormat$Field"
  NumberFormat$Field/PERMILLE)

(def *-currency
  "Static Constant.

  Constant identifying the currency field.

  type: java.text.NumberFormat$Field"
  NumberFormat$Field/CURRENCY)

(def *-exponent-sign
  "Static Constant.

  Constant identifying the exponent sign field.

  type: java.text.NumberFormat$Field"
  NumberFormat$Field/EXPONENT_SIGN)

