(ns jdk.sql.Statement
  "The object used for executing a static SQL statement
  and returning the results it produces.

  By default, only one ResultSet object per Statement
  object can be open at the same time. Therefore, if the reading of one
  ResultSet object is interleaved
  with the reading of another, each must have been generated by
  different Statement objects. All execution methods in the
  Statement interface implicitly close a current
  ResultSet object of the statement if an open one exists."
  (:refer-clojure :only [require comment defn ->])
  (:import [java.sql Statement]))

(defn set-fetch-size
  "Gives the JDBC driver a hint as to the number of rows that should
   be fetched from the database when more rows are needed for
   ResultSet objects generated by this Statement.
   If the value specified is zero, then the hint is ignored.
   The default value is zero.

  rows - the number of rows to fetch - `int`

  throws: java.sql.SQLException - if a database access error occurs, this method is called on a closed Statement or the condition rows >= 0 is not satisfied."
  ([^Statement this ^Integer rows]
    (-> this (.setFetchSize rows))))

(defn execute-large-update
  "Executes the given SQL statement and signals the driver with the
   given flag about whether the
   auto-generated keys produced by this Statement object
   should be made available for retrieval.  The driver will ignore the
   flag if the SQL statement
   is not an INSERT statement, or an SQL statement able to return
   auto-generated keys (the list of such statements is vendor-specific).

   This method should be used when the returned row count may exceed
   Integer.MAX_VALUE.

   Note:This method cannot be called on a
   PreparedStatement or CallableStatement.

   The default implementation will throw SQLFeatureNotSupportedException

  sql - an SQL Data Manipulation Language (DML) statement, such as INSERT, UPDATE or DELETE; or an SQL statement that returns nothing, such as a DDL statement. - `java.lang.String`
  auto-generated-keys - a flag indicating whether auto-generated keys should be made available for retrieval; one of the following constants: Statement.RETURN_GENERATED_KEYS Statement.NO_GENERATED_KEYS - `int`

  returns: either (1) the row count for SQL Data Manipulation Language (DML) statements
           or (2) 0 for SQL statements that return nothing - `default long`

  throws: java.sql.SQLException - if a database access error occurs, this method is called on a closed Statement, the given SQL statement returns a ResultSet object, the given constant is not one of those allowed, the method is called on a PreparedStatement or CallableStatement"
  ([^Statement this ^java.lang.String sql ^Integer auto-generated-keys]
    (-> this (.executeLargeUpdate sql auto-generated-keys)))
  ([^Statement this ^java.lang.String sql]
    (-> this (.executeLargeUpdate sql))))

(defn get-result-set-concurrency
  "Retrieves the result set concurrency for ResultSet objects
   generated by this Statement object.

  returns: either ResultSet.CONCUR_READ_ONLY or
   ResultSet.CONCUR_UPDATABLE - `int`

  throws: java.sql.SQLException - if a database access error occurs or this method is called on a closed Statement"
  (^Integer [^Statement this]
    (-> this (.getResultSetConcurrency))))

(defn execute-large-batch
  "Submits a batch of commands to the database for execution and
   if all commands execute successfully, returns an array of update counts.
   The long elements of the array that is returned are ordered
   to correspond to the commands in the batch, which are ordered
   according to the order in which they were added to the batch.
   The elements in the array returned by the method executeLargeBatch
   may be one of the following:

   A number greater than or equal to zero -- indicates that the
   command was processed successfully and is an update count giving the
   number of rows in the database that were affected by the command's
   execution
   A value of SUCCESS_NO_INFO -- indicates that the command was
   processed successfully but that the number of rows affected is
   unknown

   If one of the commands in a batch update fails to execute properly,
   this method throws a BatchUpdateException, and a JDBC
   driver may or may not continue to process the remaining commands in
   the batch.  However, the driver's behavior must be consistent with a
   particular DBMS, either always continuing to process commands or never
   continuing to process commands.  If the driver continues processing
   after a failure, the array returned by the method
   BatchUpdateException.getLargeUpdateCounts
   will contain as many elements as there are commands in the batch, and
   at least one of the elements will be the following:

   A value of EXECUTE_FAILED -- indicates that the command failed
   to execute successfully and occurs only if a driver continues to
   process commands after a command fails


   This method should be used when the returned row count may exceed
   Integer.MAX_VALUE.

   The default implementation will throw UnsupportedOperationException

  returns: an array of update counts containing one element for each
   command in the batch.  The elements of the array are ordered according
   to the order in which commands were added to the batch. - `default long[]`

  throws: java.sql.SQLException - if a database access error occurs, this method is called on a closed Statement or the driver does not support batch statements. Throws BatchUpdateException (a subclass of SQLException) if one of the commands sent to the database fails to execute properly or attempts to return a result set."
  ([^Statement this]
    (-> this (.executeLargeBatch))))

(defn poolable?
  "Returns a  value indicating whether the Statement
   is poolable or not.

  returns: true if the Statement
   is poolable; false otherwise - `boolean`

  throws: java.sql.SQLException - if this method is called on a closed Statement"
  (^Boolean [^Statement this]
    (-> this (.isPoolable))))

(defn close-on-completion?
  "Returns a value indicating whether this Statement will be
   closed when all its dependent result sets are closed.

  returns: true if the Statement will be closed when all
   of its dependent result sets are closed; false otherwise - `boolean`

  throws: java.sql.SQLException - if this method is called on a closed Statement"
  (^Boolean [^Statement this]
    (-> this (.isCloseOnCompletion))))

(defn cancel
  "Cancels this Statement object if both the DBMS and
   driver support aborting an SQL statement.
   This method can be used by one thread to cancel a statement that
   is being executed by another thread.

  throws: java.sql.SQLException - if a database access error occurs or this method is called on a closed Statement"
  ([^Statement this]
    (-> this (.cancel))))

(defn clear-batch
  "Empties this Statement object's current list of
   SQL commands.

  throws: java.sql.SQLException - if a database access error occurs, this method is called on a closed Statement or the driver does not support batch updates"
  ([^Statement this]
    (-> this (.clearBatch))))

(defn set-query-timeout
  "Sets the number of seconds the driver will wait for a
   Statement object to execute to the given number of seconds.
  By default there is no limit on the amount of time allowed for a running
   statement to complete. If the limit is exceeded, an
   SQLTimeoutException is thrown.
   A JDBC driver must apply this limit to the execute,
   executeQuery and executeUpdate methods.

   Note: JDBC driver implementations may also apply this
   limit to ResultSet methods
   (consult your driver vendor documentation for details).

   Note: In the case of Statement batching, it is
   implementation defined as to whether the time-out is applied to
   individual SQL commands added via the addBatch method or to
   the entire batch of SQL commands invoked by the executeBatch
   method (consult your driver vendor documentation for details).

  seconds - the new query timeout limit in seconds; zero means there is no limit - `int`

  throws: java.sql.SQLException - if a database access error occurs, this method is called on a closed Statement or the condition seconds >= 0 is not satisfied"
  ([^Statement this ^Integer seconds]
    (-> this (.setQueryTimeout seconds))))

(defn execute-batch
  "Submits a batch of commands to the database for execution and
   if all commands execute successfully, returns an array of update counts.
   The int elements of the array that is returned are ordered
   to correspond to the commands in the batch, which are ordered
   according to the order in which they were added to the batch.
   The elements in the array returned by the method executeBatch
   may be one of the following:

   A number greater than or equal to zero -- indicates that the
   command was processed successfully and is an update count giving the
   number of rows in the database that were affected by the command's
   execution
   A value of SUCCESS_NO_INFO -- indicates that the command was
   processed successfully but that the number of rows affected is
   unknown

   If one of the commands in a batch update fails to execute properly,
   this method throws a BatchUpdateException, and a JDBC
   driver may or may not continue to process the remaining commands in
   the batch.  However, the driver's behavior must be consistent with a
   particular DBMS, either always continuing to process commands or never
   continuing to process commands.  If the driver continues processing
   after a failure, the array returned by the method
   BatchUpdateException.getUpdateCounts
   will contain as many elements as there are commands in the batch, and
   at least one of the elements will be the following:

   A value of EXECUTE_FAILED -- indicates that the command failed
   to execute successfully and occurs only if a driver continues to
   process commands after a command fails


   The possible implementations and return values have been modified in
   the Java 2 SDK, Standard Edition, version 1.3 to
   accommodate the option of continuing to process commands in a batch
   update after a BatchUpdateException object has been thrown.

  returns: an array of update counts containing one element for each
   command in the batch.  The elements of the array are ordered according
   to the order in which commands were added to the batch. - `int[]`

  throws: java.sql.SQLException - if a database access error occurs, this method is called on a closed Statement or the driver does not support batch statements. Throws BatchUpdateException (a subclass of SQLException) if one of the commands sent to the database fails to execute properly or attempts to return a result set."
  ([^Statement this]
    (-> this (.executeBatch))))

(defn set-large-max-rows
  "Sets the limit for the maximum number of rows that any
   ResultSet object  generated by this Statement
   object can contain to the given number.
   If the limit is exceeded, the excess
   rows are silently dropped.

   This method should be used when the row limit may exceed
   Integer.MAX_VALUE.

   The default implementation will throw UnsupportedOperationException

  max - the new max rows limit; zero means there is no limit - `long`

  returns: `default void`

  throws: java.sql.SQLException - if a database access error occurs, this method is called on a closed Statement or the condition max >= 0 is not satisfied"
  ([^Statement this ^Long max]
    (-> this (.setLargeMaxRows max))))

(defn add-batch
  "Adds the given SQL command to the current list of commands for this
   Statement object. The commands in this list can be
   executed as a batch by calling the method executeBatch.

  Note:This method cannot be called on a
   PreparedStatement or CallableStatement.

  sql - typically this is a SQL INSERT or UPDATE statement - `java.lang.String`

  throws: java.sql.SQLException - if a database access error occurs, this method is called on a closed Statement, the driver does not support batch updates, the method is called on a PreparedStatement or CallableStatement"
  ([^Statement this ^java.lang.String sql]
    (-> this (.addBatch sql))))

(defn set-escape-processing
  "Sets escape processing on or off.
   If escape scanning is on (the default), the driver will do
   escape substitution before sending the SQL statement to the database.

   The Connection and DataSource property
   escapeProcessing may be used to change the default escape processing
   behavior.  A value of true (the default) enables escape Processing for
   all Statement objects. A value of false disables escape processing
   for all Statement objects.  The setEscapeProcessing
   method may be used to specify the escape processing behavior for an
   individual Statement object.

   Note: Since prepared statements have usually been parsed prior
   to making this call, disabling escape processing for
   PreparedStatements objects will have no effect.

  enable - true to enable escape processing; false to disable it - `boolean`

  throws: java.sql.SQLException - if a database access error occurs or this method is called on a closed Statement"
  ([^Statement this ^Boolean enable]
    (-> this (.setEscapeProcessing enable))))

(defn set-max-rows
  "Sets the limit for the maximum number of rows that any
   ResultSet object  generated by this Statement
   object can contain to the given number.
   If the limit is exceeded, the excess
   rows are silently dropped.

  max - the new max rows limit; zero means there is no limit - `int`

  throws: java.sql.SQLException - if a database access error occurs, this method is called on a closed Statement or the condition max >= 0 is not satisfied"
  ([^Statement this ^Integer max]
    (-> this (.setMaxRows max))))

(defn clear-warnings
  "Clears all the warnings reported on this Statement
   object. After a call to this method,
   the method getWarnings will return
   null until a new warning is reported for this
   Statement object.

  throws: java.sql.SQLException - if a database access error occurs or this method is called on a closed Statement"
  ([^Statement this]
    (-> this (.clearWarnings))))

(defn get-warnings
  "Retrieves the first warning reported by calls on this Statement object.
   Subsequent Statement object warnings will be chained to this
   SQLWarning object.

   The warning chain is automatically cleared each time
   a statement is (re)executed. This method may not be called on a closed
   Statement object; doing so will cause an SQLException
   to be thrown.

   Note: If you are processing a ResultSet object, any
   warnings associated with reads on that ResultSet object
   will be chained on it rather than on the Statement
   object that produced it.

  returns: the first SQLWarning object or null
           if there are no warnings - `java.sql.SQLWarning`

  throws: java.sql.SQLException - if a database access error occurs or this method is called on a closed Statement"
  (^java.sql.SQLWarning [^Statement this]
    (-> this (.getWarnings))))

(defn get-large-max-rows
  "Retrieves the maximum number of rows that a
   ResultSet object produced by this
   Statement object can contain.  If this limit is exceeded,
   the excess rows are silently dropped.

   This method should be used when the returned row limit may exceed
   Integer.MAX_VALUE.

   The default implementation will return 0

  returns: the current maximum number of rows for a ResultSet
           object produced by this Statement object;
           zero means there is no limit - `default long`

  throws: java.sql.SQLException - if a database access error occurs or this method is called on a closed Statement"
  ([^Statement this]
    (-> this (.getLargeMaxRows))))

(defn get-fetch-direction
  "Retrieves the direction for fetching rows from
   database tables that is the default for result sets
   generated from this Statement object.
   If this Statement object has not set
   a fetch direction by calling the method setFetchDirection,
   the return value is implementation-specific.

  returns: the default fetch direction for result sets generated
            from this Statement object - `int`

  throws: java.sql.SQLException - if a database access error occurs or this method is called on a closed Statement"
  (^Integer [^Statement this]
    (-> this (.getFetchDirection))))

(defn get-result-set-holdability
  "Retrieves the result set holdability for ResultSet objects
   generated by this Statement object.

  returns: either ResultSet.HOLD_CURSORS_OVER_COMMIT or
           ResultSet.CLOSE_CURSORS_AT_COMMIT - `int`

  throws: java.sql.SQLException - if a database access error occurs or this method is called on a closed Statement"
  (^Integer [^Statement this]
    (-> this (.getResultSetHoldability))))

(defn get-max-field-size
  "Retrieves the maximum number of bytes that can be
   returned for character and binary column values in a ResultSet
   object produced by this Statement object.
   This limit applies only to  BINARY, VARBINARY,
   LONGVARBINARY, CHAR, VARCHAR,
   NCHAR, NVARCHAR, LONGNVARCHAR
   and LONGVARCHAR columns.  If the limit is exceeded, the
   excess data is silently discarded.

  returns: the current column size limit for columns storing character and
           binary values; zero means there is no limit - `int`

  throws: java.sql.SQLException - if a database access error occurs or this method is called on a closed Statement"
  (^Integer [^Statement this]
    (-> this (.getMaxFieldSize))))

(defn get-generated-keys
  "Retrieves any auto-generated keys created as a result of executing this
   Statement object. If this Statement object did
   not generate any keys, an empty ResultSet
   object is returned.

  Note:If the columns which represent the auto-generated keys were not specified,
   the JDBC driver implementation will determine the columns which best represent the auto-generated keys.

  returns: a ResultSet object containing the auto-generated key(s)
           generated by the execution of this Statement object - `java.sql.ResultSet`

  throws: java.sql.SQLException - if a database access error occurs or this method is called on a closed Statement"
  (^java.sql.ResultSet [^Statement this]
    (-> this (.getGeneratedKeys))))

(defn close-on-completion
  "Specifies that this Statement will be closed when all its
   dependent result sets are closed. If execution of the Statement
   does not produce any result sets, this method has no effect.

   Note: Multiple calls to closeOnCompletion do
   not toggle the effect on this Statement. However, a call to
   closeOnCompletion does effect both the subsequent execution of
   statements, and statements that currently have open, dependent,
   result sets.

  throws: java.sql.SQLException - if this method is called on a closed Statement"
  ([^Statement this]
    (-> this (.closeOnCompletion))))

(defn closed?
  "Retrieves whether this Statement object has been closed. A Statement is closed if the
   method close has been called on it, or if it is automatically closed.

  returns: true if this Statement object is closed; false if it is still open - `boolean`

  throws: java.sql.SQLException - if a database access error occurs"
  (^Boolean [^Statement this]
    (-> this (.isClosed))))

(defn set-cursor-name
  "Sets the SQL cursor name to the given String, which
   will be used by subsequent Statement object
   execute methods. This name can then be
   used in SQL positioned update or delete statements to identify the
   current row in the ResultSet object generated by this
   statement.  If the database does not support positioned update/delete,
   this method is a noop.  To insure that a cursor has the proper isolation
   level to support updates, the cursor's SELECT statement
   should have the form SELECT FOR UPDATE.  If
   FOR UPDATE is not present, positioned updates may fail.

   Note: By definition, the execution of positioned updates and
   deletes must be done by a different Statement object than
   the one that generated the ResultSet object being used for
   positioning. Also, cursor names must be unique within a connection.

  name - the new cursor name, which must be unique within a connection - `java.lang.String`

  throws: java.sql.SQLException - if a database access error occurs or this method is called on a closed Statement"
  ([^Statement this ^java.lang.String name]
    (-> this (.setCursorName name))))

(defn set-max-field-size
  "Sets the limit for the maximum number of bytes that can be returned for
   character and binary column values in a ResultSet
   object produced by this Statement object.

   This limit applies
   only to BINARY, VARBINARY,
   LONGVARBINARY, CHAR, VARCHAR,
   NCHAR, NVARCHAR, LONGNVARCHAR and
   LONGVARCHAR fields.  If the limit is exceeded, the excess data
   is silently discarded. For maximum portability, use values
   greater than 256.

  max - the new column size limit in bytes; zero means there is no limit - `int`

  throws: java.sql.SQLException - if a database access error occurs, this method is called on a closed Statement or the condition max >= 0 is not satisfied"
  ([^Statement this ^Integer max]
    (-> this (.setMaxFieldSize max))))

(defn get-result-set-type
  "Retrieves the result set type for ResultSet objects
   generated by this Statement object.

  returns: one of ResultSet.TYPE_FORWARD_ONLY,
   ResultSet.TYPE_SCROLL_INSENSITIVE, or
   ResultSet.TYPE_SCROLL_SENSITIVE - `int`

  throws: java.sql.SQLException - if a database access error occurs or this method is called on a closed Statement"
  (^Integer [^Statement this]
    (-> this (.getResultSetType))))

(defn close
  "Releases this Statement object's database
   and JDBC resources immediately instead of waiting for
   this to happen when it is automatically closed.
   It is generally good practice to release resources as soon as
   you are finished with them to avoid tying up database
   resources.

   Calling the method close on a Statement
   object that is already closed has no effect.

   Note:When a Statement object is
   closed, its current ResultSet object, if one exists, is
   also closed.

  throws: java.sql.SQLException - if a database access error occurs"
  ([^Statement this]
    (-> this (.close))))

(defn get-more-results?
  "Moves to this Statement object's next result, deals with
   any current ResultSet object(s) according  to the instructions
   specified by the given flag, and returns
   true if the next result is a ResultSet object.

   There are no more results when the following is true:


       // stmt is a Statement object
       ((stmt.getMoreResults(current) == false) && (stmt.getUpdateCount() == -1))

  current - one of the following Statement constants indicating what should happen to current ResultSet objects obtained using the method getResultSet: Statement.CLOSE_CURRENT_RESULT, Statement.KEEP_CURRENT_RESULT, or Statement.CLOSE_ALL_RESULTS - `int`

  returns: true if the next result is a ResultSet
           object; false if it is an update count or there are no
           more results - `boolean`

  throws: java.sql.SQLException - if a database access error occurs, this method is called on a closed Statement or the argument supplied is not one of the following: Statement.CLOSE_CURRENT_RESULT, Statement.KEEP_CURRENT_RESULT or Statement.CLOSE_ALL_RESULTS"
  (^Boolean [^Statement this ^Integer current]
    (-> this (.getMoreResults current)))
  (^Boolean [^Statement this]
    (-> this (.getMoreResults))))

(defn set-poolable
  "Requests that a Statement be pooled or not pooled.  The value
   specified is a hint to the statement pool implementation indicating
   whether the application wants the statement to be pooled.  It is up to
   the statement pool manager as to whether the hint is used.

   The poolable value of a statement is applicable to both internal
   statement caches implemented by the driver and external statement caches
   implemented by application servers and other applications.

   By default, a Statement is not poolable when created, and
   a PreparedStatement and CallableStatement
   are poolable when created.

  poolable - requests that the statement be pooled if true and that the statement not be pooled if false - `boolean`

  throws: java.sql.SQLException - if this method is called on a closed Statement"
  ([^Statement this ^Boolean poolable]
    (-> this (.setPoolable poolable))))

(defn get-large-update-count
  "Retrieves the current result as an update count; if the result
   is a ResultSet object or there are no more results, -1
    is returned. This method should be called only once per result.

   This method should be used when the returned row count may exceed
   Integer.MAX_VALUE.

   The default implementation will throw UnsupportedOperationException

  returns: the current result as an update count; -1 if the current result
   is a ResultSet object or there are no more results - `default long`

  throws: java.sql.SQLException - if a database access error occurs or this method is called on a closed Statement"
  ([^Statement this]
    (-> this (.getLargeUpdateCount))))

(defn get-max-rows
  "Retrieves the maximum number of rows that a
   ResultSet object produced by this
   Statement object can contain.  If this limit is exceeded,
   the excess rows are silently dropped.

  returns: the current maximum number of rows for a ResultSet
           object produced by this Statement object;
           zero means there is no limit - `int`

  throws: java.sql.SQLException - if a database access error occurs or this method is called on a closed Statement"
  (^Integer [^Statement this]
    (-> this (.getMaxRows))))

(defn get-connection
  "Retrieves the Connection object
   that produced this Statement object.

  returns: the connection that produced this statement - `java.sql.Connection`

  throws: java.sql.SQLException - if a database access error occurs or this method is called on a closed Statement"
  (^java.sql.Connection [^Statement this]
    (-> this (.getConnection))))

(defn get-query-timeout
  "Retrieves the number of seconds the driver will
   wait for a Statement object to execute.
   If the limit is exceeded, a
   SQLException is thrown.

  returns: the current query timeout limit in seconds; zero means there is
           no limit - `int`

  throws: java.sql.SQLException - if a database access error occurs or this method is called on a closed Statement"
  (^Integer [^Statement this]
    (-> this (.getQueryTimeout))))

(defn execute
  "Executes the given SQL statement, which may return multiple results,
   and signals the driver that any
   auto-generated keys should be made available
   for retrieval.  The driver will ignore this signal if the SQL statement
   is not an INSERT statement, or an SQL statement able to return
   auto-generated keys (the list of such statements is vendor-specific).

   In some (uncommon) situations, a single SQL statement may return
   multiple result sets and/or update counts.  Normally you can ignore
   this unless you are (1) executing a stored procedure that you know may
   return multiple results or (2) you are dynamically executing an
   unknown SQL string.

   The execute method executes an SQL statement and indicates the
   form of the first result.  You must then use the methods
   getResultSet or getUpdateCount
   to retrieve the result, and getMoreResults to
   move to any subsequent result(s).

  Note:This method cannot be called on a
   PreparedStatement or CallableStatement.

  sql - any SQL statement - `java.lang.String`
  auto-generated-keys - a constant indicating whether auto-generated keys should be made available for retrieval using the method getGeneratedKeys; one of the following constants: Statement.RETURN_GENERATED_KEYS or Statement.NO_GENERATED_KEYS - `int`

  returns: true if the first result is a ResultSet
           object; false if it is an update count or there are
           no results - `boolean`

  throws: java.sql.SQLException - if a database access error occurs, this method is called on a closed Statement, the second parameter supplied to this method is not Statement.RETURN_GENERATED_KEYS or Statement.NO_GENERATED_KEYS, the method is called on a PreparedStatement or CallableStatement"
  (^Boolean [^Statement this ^java.lang.String sql ^Integer auto-generated-keys]
    (-> this (.execute sql auto-generated-keys)))
  (^Boolean [^Statement this ^java.lang.String sql]
    (-> this (.execute sql))))

(defn get-fetch-size
  "Retrieves the number of result set rows that is the default
   fetch size for ResultSet objects
   generated from this Statement object.
   If this Statement object has not set
   a fetch size by calling the method setFetchSize,
   the return value is implementation-specific.

  returns: the default fetch size for result sets generated
            from this Statement object - `int`

  throws: java.sql.SQLException - if a database access error occurs or this method is called on a closed Statement"
  (^Integer [^Statement this]
    (-> this (.getFetchSize))))

(defn get-update-count
  "Retrieves the current result as an update count;
    if the result is a ResultSet object or there are no more results, -1
    is returned. This method should be called only once per result.

  returns: the current result as an update count; -1 if the current result is a
   ResultSet object or there are no more results - `int`

  throws: java.sql.SQLException - if a database access error occurs or this method is called on a closed Statement"
  (^Integer [^Statement this]
    (-> this (.getUpdateCount))))

(defn execute-update
  "Executes the given SQL statement and signals the driver with the
   given flag about whether the
   auto-generated keys produced by this Statement object
   should be made available for retrieval.  The driver will ignore the
   flag if the SQL statement
   is not an INSERT statement, or an SQL statement able to return
   auto-generated keys (the list of such statements is vendor-specific).

   Note:This method cannot be called on a
   PreparedStatement or CallableStatement.

  sql - an SQL Data Manipulation Language (DML) statement, such as INSERT, UPDATE or DELETE; or an SQL statement that returns nothing, such as a DDL statement. - `java.lang.String`
  auto-generated-keys - a flag indicating whether auto-generated keys should be made available for retrieval; one of the following constants: Statement.RETURN_GENERATED_KEYS Statement.NO_GENERATED_KEYS - `int`

  returns: either (1) the row count for SQL Data Manipulation Language (DML) statements
           or (2) 0 for SQL statements that return nothing - `int`

  throws: java.sql.SQLException - if a database access error occurs, this method is called on a closed Statement, the given SQL statement returns a ResultSet object, the given constant is not one of those allowed, the method is called on a PreparedStatement or CallableStatement"
  (^Integer [^Statement this ^java.lang.String sql ^Integer auto-generated-keys]
    (-> this (.executeUpdate sql auto-generated-keys)))
  (^Integer [^Statement this ^java.lang.String sql]
    (-> this (.executeUpdate sql))))

(defn execute-query
  "Executes the given SQL statement, which returns a single
   ResultSet object.

   Note:This method cannot be called on a
   PreparedStatement or CallableStatement.

  sql - an SQL statement to be sent to the database, typically a static SQL SELECT statement - `java.lang.String`

  returns: a ResultSet object that contains the data produced
           by the given query; never null - `java.sql.ResultSet`

  throws: java.sql.SQLException - if a database access error occurs, this method is called on a closed Statement, the given SQL statement produces anything other than a single ResultSet object, the method is called on a PreparedStatement or CallableStatement"
  (^java.sql.ResultSet [^Statement this ^java.lang.String sql]
    (-> this (.executeQuery sql))))

(defn set-fetch-direction
  "Gives the driver a hint as to the direction in which
   rows will be processed in ResultSet
   objects created using this Statement object.  The
   default value is ResultSet.FETCH_FORWARD.

   Note that this method sets the default fetch direction for
   result sets generated by this Statement object.
   Each result set has its own methods for getting and setting
   its own fetch direction.

  direction - the initial direction for processing rows - `int`

  throws: java.sql.SQLException - if a database access error occurs, this method is called on a closed Statement or the given direction is not one of ResultSet.FETCH_FORWARD, ResultSet.FETCH_REVERSE, or ResultSet.FETCH_UNKNOWN"
  ([^Statement this ^Integer direction]
    (-> this (.setFetchDirection direction))))

(defn get-result-set
  "Retrieves the current result as a ResultSet object.
    This method should be called only once per result.

  returns: the current result as a ResultSet object or
   null if the result is an update count or there are no more results - `java.sql.ResultSet`

  throws: java.sql.SQLException - if a database access error occurs or this method is called on a closed Statement"
  (^java.sql.ResultSet [^Statement this]
    (-> this (.getResultSet))))

