(ns jdk.sql.Savepoint
  "The representation of a savepoint, which is a point within
  the current transaction that can be referenced from the
  Connection.rollback method. When a transaction
  is rolled back to a savepoint all changes made after that
  savepoint are undone.

  Savepoints can be either named or unnamed. Unnamed savepoints
  are identified by an ID generated by the underlying data source."
  (:refer-clojure :only [require comment defn ->])
  (:import [java.sql Savepoint]))

(defn get-savepoint-id
  "Retrieves the generated ID for the savepoint that this
   Savepoint object represents.

  returns: the numeric ID of this savepoint - `int`

  throws: java.sql.SQLException - if this is a named savepoint"
  ([^java.sql.Savepoint this]
    (-> this (.getSavepointId))))

(defn get-savepoint-name
  "Retrieves the name of the savepoint that this Savepoint
   object represents.

  returns: the name of this savepoint - `java.lang.String`

  throws: java.sql.SQLException - if this is an un-named savepoint"
  ([^java.sql.Savepoint this]
    (-> this (.getSavepointName))))

