(ns jdk.lang.Character$UnicodeBlock
  "A family of character subsets representing the character blocks in the
  Unicode specification. Character blocks generally define characters
  used for a specific script or purpose. A character is contained by
  at most one Unicode block."
  (:refer-clojure :only [require comment defn ->])
  (:import [java.lang Character$UnicodeBlock]))

(def *-basic-latin
  "Static Constant.

  Constant for the \"Basic Latin\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/BASIC_LATIN)

(def *-latin-1-supplement
  "Static Constant.

  Constant for the \"Latin-1 Supplement\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/LATIN_1_SUPPLEMENT)

(def *-latin-extended-a
  "Static Constant.

  Constant for the \"Latin Extended-A\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/LATIN_EXTENDED_A)

(def *-latin-extended-b
  "Static Constant.

  Constant for the \"Latin Extended-B\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/LATIN_EXTENDED_B)

(def *-ipa-extensions
  "Static Constant.

  Constant for the \"IPA Extensions\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/IPA_EXTENSIONS)

(def *-spacing-modifier-letters
  "Static Constant.

  Constant for the \"Spacing Modifier Letters\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/SPACING_MODIFIER_LETTERS)

(def *-combining-diacritical-marks
  "Static Constant.

  Constant for the \"Combining Diacritical Marks\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/COMBINING_DIACRITICAL_MARKS)

(def *-greek
  "Static Constant.

  Constant for the \"Greek and Coptic\" Unicode character block.

   This block was previously known as the \"Greek\" block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/GREEK)

(def *-cyrillic
  "Static Constant.

  Constant for the \"Cyrillic\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/CYRILLIC)

(def *-armenian
  "Static Constant.

  Constant for the \"Armenian\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/ARMENIAN)

(def *-hebrew
  "Static Constant.

  Constant for the \"Hebrew\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/HEBREW)

(def *-arabic
  "Static Constant.

  Constant for the \"Arabic\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/ARABIC)

(def *-devanagari
  "Static Constant.

  Constant for the \"Devanagari\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/DEVANAGARI)

(def *-bengali
  "Static Constant.

  Constant for the \"Bengali\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/BENGALI)

(def *-gurmukhi
  "Static Constant.

  Constant for the \"Gurmukhi\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/GURMUKHI)

(def *-gujarati
  "Static Constant.

  Constant for the \"Gujarati\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/GUJARATI)

(def *-oriya
  "Static Constant.

  Constant for the \"Oriya\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/ORIYA)

(def *-tamil
  "Static Constant.

  Constant for the \"Tamil\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/TAMIL)

(def *-telugu
  "Static Constant.

  Constant for the \"Telugu\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/TELUGU)

(def *-kannada
  "Static Constant.

  Constant for the \"Kannada\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/KANNADA)

(def *-malayalam
  "Static Constant.

  Constant for the \"Malayalam\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/MALAYALAM)

(def *-thai
  "Static Constant.

  Constant for the \"Thai\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/THAI)

(def *-lao
  "Static Constant.

  Constant for the \"Lao\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/LAO)

(def *-tibetan
  "Static Constant.

  Constant for the \"Tibetan\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/TIBETAN)

(def *-georgian
  "Static Constant.

  Constant for the \"Georgian\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/GEORGIAN)

(def *-hangul-jamo
  "Static Constant.

  Constant for the \"Hangul Jamo\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/HANGUL_JAMO)

(def *-latin-extended-additional
  "Static Constant.

  Constant for the \"Latin Extended Additional\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/LATIN_EXTENDED_ADDITIONAL)

(def *-greek-extended
  "Static Constant.

  Constant for the \"Greek Extended\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/GREEK_EXTENDED)

(def *-general-punctuation
  "Static Constant.

  Constant for the \"General Punctuation\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/GENERAL_PUNCTUATION)

(def *-superscripts-and-subscripts
  "Static Constant.

  Constant for the \"Superscripts and Subscripts\" Unicode character
   block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/SUPERSCRIPTS_AND_SUBSCRIPTS)

(def *-currency-symbols
  "Static Constant.

  Constant for the \"Currency Symbols\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/CURRENCY_SYMBOLS)

(def *-combining-marks-for-symbols
  "Static Constant.

  Constant for the \"Combining Diacritical Marks for Symbols\" Unicode
   character block.

   This block was previously known as \"Combining Marks for Symbols\".

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/COMBINING_MARKS_FOR_SYMBOLS)

(def *-letterlike-symbols
  "Static Constant.

  Constant for the \"Letterlike Symbols\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/LETTERLIKE_SYMBOLS)

(def *-number-forms
  "Static Constant.

  Constant for the \"Number Forms\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/NUMBER_FORMS)

(def *-arrows
  "Static Constant.

  Constant for the \"Arrows\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/ARROWS)

(def *-mathematical-operators
  "Static Constant.

  Constant for the \"Mathematical Operators\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/MATHEMATICAL_OPERATORS)

(def *-miscellaneous-technical
  "Static Constant.

  Constant for the \"Miscellaneous Technical\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/MISCELLANEOUS_TECHNICAL)

(def *-control-pictures
  "Static Constant.

  Constant for the \"Control Pictures\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/CONTROL_PICTURES)

(def *-optical-character-recognition
  "Static Constant.

  Constant for the \"Optical Character Recognition\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/OPTICAL_CHARACTER_RECOGNITION)

(def *-enclosed-alphanumerics
  "Static Constant.

  Constant for the \"Enclosed Alphanumerics\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/ENCLOSED_ALPHANUMERICS)

(def *-box-drawing
  "Static Constant.

  Constant for the \"Box Drawing\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/BOX_DRAWING)

(def *-block-elements
  "Static Constant.

  Constant for the \"Block Elements\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/BLOCK_ELEMENTS)

(def *-geometric-shapes
  "Static Constant.

  Constant for the \"Geometric Shapes\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/GEOMETRIC_SHAPES)

(def *-miscellaneous-symbols
  "Static Constant.

  Constant for the \"Miscellaneous Symbols\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/MISCELLANEOUS_SYMBOLS)

(def *-dingbats
  "Static Constant.

  Constant for the \"Dingbats\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/DINGBATS)

(def *-cjk-symbols-and-punctuation
  "Static Constant.

  Constant for the \"CJK Symbols and Punctuation\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/CJK_SYMBOLS_AND_PUNCTUATION)

(def *-hiragana
  "Static Constant.

  Constant for the \"Hiragana\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/HIRAGANA)

(def *-katakana
  "Static Constant.

  Constant for the \"Katakana\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/KATAKANA)

(def *-bopomofo
  "Static Constant.

  Constant for the \"Bopomofo\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/BOPOMOFO)

(def *-hangul-compatibility-jamo
  "Static Constant.

  Constant for the \"Hangul Compatibility Jamo\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/HANGUL_COMPATIBILITY_JAMO)

(def *-kanbun
  "Static Constant.

  Constant for the \"Kanbun\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/KANBUN)

(def *-enclosed-cjk-letters-and-months
  "Static Constant.

  Constant for the \"Enclosed CJK Letters and Months\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/ENCLOSED_CJK_LETTERS_AND_MONTHS)

(def *-cjk-compatibility
  "Static Constant.

  Constant for the \"CJK Compatibility\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/CJK_COMPATIBILITY)

(def *-cjk-unified-ideographs
  "Static Constant.

  Constant for the \"CJK Unified Ideographs\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/CJK_UNIFIED_IDEOGRAPHS)

(def *-hangul-syllables
  "Static Constant.

  Constant for the \"Hangul Syllables\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/HANGUL_SYLLABLES)

(def *-private-use-area
  "Static Constant.

  Constant for the \"Private Use Area\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/PRIVATE_USE_AREA)

(def *-cjk-compatibility-ideographs
  "Static Constant.

  Constant for the \"CJK Compatibility Ideographs\" Unicode character
   block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/CJK_COMPATIBILITY_IDEOGRAPHS)

(def *-alphabetic-presentation-forms
  "Static Constant.

  Constant for the \"Alphabetic Presentation Forms\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/ALPHABETIC_PRESENTATION_FORMS)

(def *-arabic-presentation-forms-a
  "Static Constant.

  Constant for the \"Arabic Presentation Forms-A\" Unicode character
   block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/ARABIC_PRESENTATION_FORMS_A)

(def *-combining-half-marks
  "Static Constant.

  Constant for the \"Combining Half Marks\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/COMBINING_HALF_MARKS)

(def *-cjk-compatibility-forms
  "Static Constant.

  Constant for the \"CJK Compatibility Forms\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/CJK_COMPATIBILITY_FORMS)

(def *-small-form-variants
  "Static Constant.

  Constant for the \"Small Form Variants\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/SMALL_FORM_VARIANTS)

(def *-arabic-presentation-forms-b
  "Static Constant.

  Constant for the \"Arabic Presentation Forms-B\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/ARABIC_PRESENTATION_FORMS_B)

(def *-halfwidth-and-fullwidth-forms
  "Static Constant.

  Constant for the \"Halfwidth and Fullwidth Forms\" Unicode character
   block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/HALFWIDTH_AND_FULLWIDTH_FORMS)

(def *-specials
  "Static Constant.

  Constant for the \"Specials\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/SPECIALS)

(def *-surrogates-area
  "Static Constant.

  Deprecated. As of J2SE 5, use HIGH_SURROGATES,
               HIGH_PRIVATE_USE_SURROGATES, and
               LOW_SURROGATES. These new constants match
               the block definitions of the Unicode Standard.
               The of(char) and of(int) methods
               return the new constants, not SURROGATES_AREA.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/SURROGATES_AREA)

(def *-syriac
  "Static Constant.

  Constant for the \"Syriac\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/SYRIAC)

(def *-thaana
  "Static Constant.

  Constant for the \"Thaana\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/THAANA)

(def *-sinhala
  "Static Constant.

  Constant for the \"Sinhala\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/SINHALA)

(def *-myanmar
  "Static Constant.

  Constant for the \"Myanmar\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/MYANMAR)

(def *-ethiopic
  "Static Constant.

  Constant for the \"Ethiopic\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/ETHIOPIC)

(def *-cherokee
  "Static Constant.

  Constant for the \"Cherokee\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/CHEROKEE)

(def *-unified-canadian-aboriginal-syllabics
  "Static Constant.

  Constant for the \"Unified Canadian Aboriginal Syllabics\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS)

(def *-ogham
  "Static Constant.

  Constant for the \"Ogham\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/OGHAM)

(def *-runic
  "Static Constant.

  Constant for the \"Runic\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/RUNIC)

(def *-khmer
  "Static Constant.

  Constant for the \"Khmer\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/KHMER)

(def *-mongolian
  "Static Constant.

  Constant for the \"Mongolian\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/MONGOLIAN)

(def *-braille-patterns
  "Static Constant.

  Constant for the \"Braille Patterns\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/BRAILLE_PATTERNS)

(def *-cjk-radicals-supplement
  "Static Constant.

  Constant for the \"CJK Radicals Supplement\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/CJK_RADICALS_SUPPLEMENT)

(def *-kangxi-radicals
  "Static Constant.

  Constant for the \"Kangxi Radicals\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/KANGXI_RADICALS)

(def *-ideographic-description-characters
  "Static Constant.

  Constant for the \"Ideographic Description Characters\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/IDEOGRAPHIC_DESCRIPTION_CHARACTERS)

(def *-bopomofo-extended
  "Static Constant.

  Constant for the \"Bopomofo Extended\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/BOPOMOFO_EXTENDED)

(def *-cjk-unified-ideographs-extension-a
  "Static Constant.

  Constant for the \"CJK Unified Ideographs Extension A\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A)

(def *-yi-syllables
  "Static Constant.

  Constant for the \"Yi Syllables\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/YI_SYLLABLES)

(def *-yi-radicals
  "Static Constant.

  Constant for the \"Yi Radicals\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/YI_RADICALS)

(def *-cyrillic-supplementary
  "Static Constant.

  Constant for the \"Cyrillic Supplementary\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/CYRILLIC_SUPPLEMENTARY)

(def *-tagalog
  "Static Constant.

  Constant for the \"Tagalog\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/TAGALOG)

(def *-hanunoo
  "Static Constant.

  Constant for the \"Hanunoo\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/HANUNOO)

(def *-buhid
  "Static Constant.

  Constant for the \"Buhid\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/BUHID)

(def *-tagbanwa
  "Static Constant.

  Constant for the \"Tagbanwa\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/TAGBANWA)

(def *-limbu
  "Static Constant.

  Constant for the \"Limbu\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/LIMBU)

(def *-tai-le
  "Static Constant.

  Constant for the \"Tai Le\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/TAI_LE)

(def *-khmer-symbols
  "Static Constant.

  Constant for the \"Khmer Symbols\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/KHMER_SYMBOLS)

(def *-phonetic-extensions
  "Static Constant.

  Constant for the \"Phonetic Extensions\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/PHONETIC_EXTENSIONS)

(def *-miscellaneous-mathematical-symbols-a
  "Static Constant.

  Constant for the \"Miscellaneous Mathematical Symbols-A\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A)

(def *-supplemental-arrows-a
  "Static Constant.

  Constant for the \"Supplemental Arrows-A\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/SUPPLEMENTAL_ARROWS_A)

(def *-supplemental-arrows-b
  "Static Constant.

  Constant for the \"Supplemental Arrows-B\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/SUPPLEMENTAL_ARROWS_B)

(def *-miscellaneous-mathematical-symbols-b
  "Static Constant.

  Constant for the \"Miscellaneous Mathematical Symbols-B\" Unicode
   character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B)

(def *-supplemental-mathematical-operators
  "Static Constant.

  Constant for the \"Supplemental Mathematical Operators\" Unicode
   character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/SUPPLEMENTAL_MATHEMATICAL_OPERATORS)

(def *-miscellaneous-symbols-and-arrows
  "Static Constant.

  Constant for the \"Miscellaneous Symbols and Arrows\" Unicode character
   block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/MISCELLANEOUS_SYMBOLS_AND_ARROWS)

(def *-katakana-phonetic-extensions
  "Static Constant.

  Constant for the \"Katakana Phonetic Extensions\" Unicode character
   block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/KATAKANA_PHONETIC_EXTENSIONS)

(def *-yijing-hexagram-symbols
  "Static Constant.

  Constant for the \"Yijing Hexagram Symbols\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/YIJING_HEXAGRAM_SYMBOLS)

(def *-variation-selectors
  "Static Constant.

  Constant for the \"Variation Selectors\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/VARIATION_SELECTORS)

(def *-linear-b-syllabary
  "Static Constant.

  Constant for the \"Linear B Syllabary\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/LINEAR_B_SYLLABARY)

(def *-linear-b-ideograms
  "Static Constant.

  Constant for the \"Linear B Ideograms\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/LINEAR_B_IDEOGRAMS)

(def *-aegean-numbers
  "Static Constant.

  Constant for the \"Aegean Numbers\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/AEGEAN_NUMBERS)

(def *-old-italic
  "Static Constant.

  Constant for the \"Old Italic\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/OLD_ITALIC)

(def *-gothic
  "Static Constant.

  Constant for the \"Gothic\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/GOTHIC)

(def *-ugaritic
  "Static Constant.

  Constant for the \"Ugaritic\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/UGARITIC)

(def *-deseret
  "Static Constant.

  Constant for the \"Deseret\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/DESERET)

(def *-shavian
  "Static Constant.

  Constant for the \"Shavian\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/SHAVIAN)

(def *-osmanya
  "Static Constant.

  Constant for the \"Osmanya\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/OSMANYA)

(def *-cypriot-syllabary
  "Static Constant.

  Constant for the \"Cypriot Syllabary\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/CYPRIOT_SYLLABARY)

(def *-byzantine-musical-symbols
  "Static Constant.

  Constant for the \"Byzantine Musical Symbols\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/BYZANTINE_MUSICAL_SYMBOLS)

(def *-musical-symbols
  "Static Constant.

  Constant for the \"Musical Symbols\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/MUSICAL_SYMBOLS)

(def *-tai-xuan-jing-symbols
  "Static Constant.

  Constant for the \"Tai Xuan Jing Symbols\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/TAI_XUAN_JING_SYMBOLS)

(def *-mathematical-alphanumeric-symbols
  "Static Constant.

  Constant for the \"Mathematical Alphanumeric Symbols\" Unicode
   character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/MATHEMATICAL_ALPHANUMERIC_SYMBOLS)

(def *-cjk-unified-ideographs-extension-b
  "Static Constant.

  Constant for the \"CJK Unified Ideographs Extension B\" Unicode
   character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B)

(def *-cjk-compatibility-ideographs-supplement
  "Static Constant.

  Constant for the \"CJK Compatibility Ideographs Supplement\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT)

(def *-tags
  "Static Constant.

  Constant for the \"Tags\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/TAGS)

(def *-variation-selectors-supplement
  "Static Constant.

  Constant for the \"Variation Selectors Supplement\" Unicode character
   block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/VARIATION_SELECTORS_SUPPLEMENT)

(def *-supplementary-private-use-area-a
  "Static Constant.

  Constant for the \"Supplementary Private Use Area-A\" Unicode character
   block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/SUPPLEMENTARY_PRIVATE_USE_AREA_A)

(def *-supplementary-private-use-area-b
  "Static Constant.

  Constant for the \"Supplementary Private Use Area-B\" Unicode character
   block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/SUPPLEMENTARY_PRIVATE_USE_AREA_B)

(def *-high-surrogates
  "Static Constant.

  Constant for the \"High Surrogates\" Unicode character block.
   This block represents codepoint values in the high surrogate
   range: U+D800 through U+DB7F

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/HIGH_SURROGATES)

(def *-high-private-use-surrogates
  "Static Constant.

  Constant for the \"High Private Use Surrogates\" Unicode character
   block.
   This block represents codepoint values in the private use high
   surrogate range: U+DB80 through U+DBFF

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/HIGH_PRIVATE_USE_SURROGATES)

(def *-low-surrogates
  "Static Constant.

  Constant for the \"Low Surrogates\" Unicode character block.
   This block represents codepoint values in the low surrogate
   range: U+DC00 through U+DFFF

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/LOW_SURROGATES)

(def *-arabic-supplement
  "Static Constant.

  Constant for the \"Arabic Supplement\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/ARABIC_SUPPLEMENT)

(def *-nko
  "Static Constant.

  Constant for the \"NKo\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/NKO)

(def *-samaritan
  "Static Constant.

  Constant for the \"Samaritan\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/SAMARITAN)

(def *-mandaic
  "Static Constant.

  Constant for the \"Mandaic\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/MANDAIC)

(def *-ethiopic-supplement
  "Static Constant.

  Constant for the \"Ethiopic Supplement\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/ETHIOPIC_SUPPLEMENT)

(def *-unified-canadian-aboriginal-syllabics-extended
  "Static Constant.

  Constant for the \"Unified Canadian Aboriginal Syllabics Extended\"
   Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_EXTENDED)

(def *-new-tai-lue
  "Static Constant.

  Constant for the \"New Tai Lue\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/NEW_TAI_LUE)

(def *-buginese
  "Static Constant.

  Constant for the \"Buginese\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/BUGINESE)

(def *-tai-tham
  "Static Constant.

  Constant for the \"Tai Tham\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/TAI_THAM)

(def *-balinese
  "Static Constant.

  Constant for the \"Balinese\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/BALINESE)

(def *-sundanese
  "Static Constant.

  Constant for the \"Sundanese\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/SUNDANESE)

(def *-batak
  "Static Constant.

  Constant for the \"Batak\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/BATAK)

(def *-lepcha
  "Static Constant.

  Constant for the \"Lepcha\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/LEPCHA)

(def *-ol-chiki
  "Static Constant.

  Constant for the \"Ol Chiki\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/OL_CHIKI)

(def *-vedic-extensions
  "Static Constant.

  Constant for the \"Vedic Extensions\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/VEDIC_EXTENSIONS)

(def *-phonetic-extensions-supplement
  "Static Constant.

  Constant for the \"Phonetic Extensions Supplement\" Unicode character
   block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/PHONETIC_EXTENSIONS_SUPPLEMENT)

(def *-combining-diacritical-marks-supplement
  "Static Constant.

  Constant for the \"Combining Diacritical Marks Supplement\" Unicode
   character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/COMBINING_DIACRITICAL_MARKS_SUPPLEMENT)

(def *-glagolitic
  "Static Constant.

  Constant for the \"Glagolitic\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/GLAGOLITIC)

(def *-latin-extended-c
  "Static Constant.

  Constant for the \"Latin Extended-C\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/LATIN_EXTENDED_C)

(def *-coptic
  "Static Constant.

  Constant for the \"Coptic\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/COPTIC)

(def *-georgian-supplement
  "Static Constant.

  Constant for the \"Georgian Supplement\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/GEORGIAN_SUPPLEMENT)

(def *-tifinagh
  "Static Constant.

  Constant for the \"Tifinagh\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/TIFINAGH)

(def *-ethiopic-extended
  "Static Constant.

  Constant for the \"Ethiopic Extended\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/ETHIOPIC_EXTENDED)

(def *-cyrillic-extended-a
  "Static Constant.

  Constant for the \"Cyrillic Extended-A\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/CYRILLIC_EXTENDED_A)

(def *-supplemental-punctuation
  "Static Constant.

  Constant for the \"Supplemental Punctuation\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/SUPPLEMENTAL_PUNCTUATION)

(def *-cjk-strokes
  "Static Constant.

  Constant for the \"CJK Strokes\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/CJK_STROKES)

(def *-lisu
  "Static Constant.

  Constant for the \"Lisu\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/LISU)

(def *-vai
  "Static Constant.

  Constant for the \"Vai\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/VAI)

(def *-cyrillic-extended-b
  "Static Constant.

  Constant for the \"Cyrillic Extended-B\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/CYRILLIC_EXTENDED_B)

(def *-bamum
  "Static Constant.

  Constant for the \"Bamum\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/BAMUM)

(def *-modifier-tone-letters
  "Static Constant.

  Constant for the \"Modifier Tone Letters\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/MODIFIER_TONE_LETTERS)

(def *-latin-extended-d
  "Static Constant.

  Constant for the \"Latin Extended-D\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/LATIN_EXTENDED_D)

(def *-syloti-nagri
  "Static Constant.

  Constant for the \"Syloti Nagri\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/SYLOTI_NAGRI)

(def *-common-indic-number-forms
  "Static Constant.

  Constant for the \"Common Indic Number Forms\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/COMMON_INDIC_NUMBER_FORMS)

(def *-phags-pa
  "Static Constant.

  Constant for the \"Phags-pa\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/PHAGS_PA)

(def *-saurashtra
  "Static Constant.

  Constant for the \"Saurashtra\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/SAURASHTRA)

(def *-devanagari-extended
  "Static Constant.

  Constant for the \"Devanagari Extended\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/DEVANAGARI_EXTENDED)

(def *-kayah-li
  "Static Constant.

  Constant for the \"Kayah Li\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/KAYAH_LI)

(def *-rejang
  "Static Constant.

  Constant for the \"Rejang\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/REJANG)

(def *-hangul-jamo-extended-a
  "Static Constant.

  Constant for the \"Hangul Jamo Extended-A\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/HANGUL_JAMO_EXTENDED_A)

(def *-javanese
  "Static Constant.

  Constant for the \"Javanese\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/JAVANESE)

(def *-cham
  "Static Constant.

  Constant for the \"Cham\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/CHAM)

(def *-myanmar-extended-a
  "Static Constant.

  Constant for the \"Myanmar Extended-A\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/MYANMAR_EXTENDED_A)

(def *-tai-viet
  "Static Constant.

  Constant for the \"Tai Viet\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/TAI_VIET)

(def *-ethiopic-extended-a
  "Static Constant.

  Constant for the \"Ethiopic Extended-A\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/ETHIOPIC_EXTENDED_A)

(def *-meetei-mayek
  "Static Constant.

  Constant for the \"Meetei Mayek\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/MEETEI_MAYEK)

(def *-hangul-jamo-extended-b
  "Static Constant.

  Constant for the \"Hangul Jamo Extended-B\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/HANGUL_JAMO_EXTENDED_B)

(def *-vertical-forms
  "Static Constant.

  Constant for the \"Vertical Forms\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/VERTICAL_FORMS)

(def *-ancient-greek-numbers
  "Static Constant.

  Constant for the \"Ancient Greek Numbers\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/ANCIENT_GREEK_NUMBERS)

(def *-ancient-symbols
  "Static Constant.

  Constant for the \"Ancient Symbols\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/ANCIENT_SYMBOLS)

(def *-phaistos-disc
  "Static Constant.

  Constant for the \"Phaistos Disc\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/PHAISTOS_DISC)

(def *-lycian
  "Static Constant.

  Constant for the \"Lycian\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/LYCIAN)

(def *-carian
  "Static Constant.

  Constant for the \"Carian\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/CARIAN)

(def *-old-persian
  "Static Constant.

  Constant for the \"Old Persian\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/OLD_PERSIAN)

(def *-imperial-aramaic
  "Static Constant.

  Constant for the \"Imperial Aramaic\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/IMPERIAL_ARAMAIC)

(def *-phoenician
  "Static Constant.

  Constant for the \"Phoenician\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/PHOENICIAN)

(def *-lydian
  "Static Constant.

  Constant for the \"Lydian\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/LYDIAN)

(def *-kharoshthi
  "Static Constant.

  Constant for the \"Kharoshthi\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/KHAROSHTHI)

(def *-old-south-arabian
  "Static Constant.

  Constant for the \"Old South Arabian\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/OLD_SOUTH_ARABIAN)

(def *-avestan
  "Static Constant.

  Constant for the \"Avestan\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/AVESTAN)

(def *-inscriptional-parthian
  "Static Constant.

  Constant for the \"Inscriptional Parthian\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/INSCRIPTIONAL_PARTHIAN)

(def *-inscriptional-pahlavi
  "Static Constant.

  Constant for the \"Inscriptional Pahlavi\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/INSCRIPTIONAL_PAHLAVI)

(def *-old-turkic
  "Static Constant.

  Constant for the \"Old Turkic\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/OLD_TURKIC)

(def *-rumi-numeral-symbols
  "Static Constant.

  Constant for the \"Rumi Numeral Symbols\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/RUMI_NUMERAL_SYMBOLS)

(def *-brahmi
  "Static Constant.

  Constant for the \"Brahmi\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/BRAHMI)

(def *-kaithi
  "Static Constant.

  Constant for the \"Kaithi\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/KAITHI)

(def *-cuneiform
  "Static Constant.

  Constant for the \"Cuneiform\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/CUNEIFORM)

(def *-cuneiform-numbers-and-punctuation
  "Static Constant.

  Constant for the \"Cuneiform Numbers and Punctuation\" Unicode
   character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/CUNEIFORM_NUMBERS_AND_PUNCTUATION)

(def *-egyptian-hieroglyphs
  "Static Constant.

  Constant for the \"Egyptian Hieroglyphs\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/EGYPTIAN_HIEROGLYPHS)

(def *-bamum-supplement
  "Static Constant.

  Constant for the \"Bamum Supplement\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/BAMUM_SUPPLEMENT)

(def *-kana-supplement
  "Static Constant.

  Constant for the \"Kana Supplement\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/KANA_SUPPLEMENT)

(def *-ancient-greek-musical-notation
  "Static Constant.

  Constant for the \"Ancient Greek Musical Notation\" Unicode character
   block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/ANCIENT_GREEK_MUSICAL_NOTATION)

(def *-counting-rod-numerals
  "Static Constant.

  Constant for the \"Counting Rod Numerals\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/COUNTING_ROD_NUMERALS)

(def *-mahjong-tiles
  "Static Constant.

  Constant for the \"Mahjong Tiles\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/MAHJONG_TILES)

(def *-domino-tiles
  "Static Constant.

  Constant for the \"Domino Tiles\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/DOMINO_TILES)

(def *-playing-cards
  "Static Constant.

  Constant for the \"Playing Cards\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/PLAYING_CARDS)

(def *-enclosed-alphanumeric-supplement
  "Static Constant.

  Constant for the \"Enclosed Alphanumeric Supplement\" Unicode character
   block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/ENCLOSED_ALPHANUMERIC_SUPPLEMENT)

(def *-enclosed-ideographic-supplement
  "Static Constant.

  Constant for the \"Enclosed Ideographic Supplement\" Unicode character
   block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/ENCLOSED_IDEOGRAPHIC_SUPPLEMENT)

(def *-miscellaneous-symbols-and-pictographs
  "Static Constant.

  Constant for the \"Miscellaneous Symbols And Pictographs\" Unicode
   character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/MISCELLANEOUS_SYMBOLS_AND_PICTOGRAPHS)

(def *-emoticons
  "Static Constant.

  Constant for the \"Emoticons\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/EMOTICONS)

(def *-transport-and-map-symbols
  "Static Constant.

  Constant for the \"Transport And Map Symbols\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/TRANSPORT_AND_MAP_SYMBOLS)

(def *-alchemical-symbols
  "Static Constant.

  Constant for the \"Alchemical Symbols\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/ALCHEMICAL_SYMBOLS)

(def *-cjk-unified-ideographs-extension-c
  "Static Constant.

  Constant for the \"CJK Unified Ideographs Extension C\" Unicode
   character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/CJK_UNIFIED_IDEOGRAPHS_EXTENSION_C)

(def *-cjk-unified-ideographs-extension-d
  "Static Constant.

  Constant for the \"CJK Unified Ideographs Extension D\" Unicode
   character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/CJK_UNIFIED_IDEOGRAPHS_EXTENSION_D)

(def *-arabic-extended-a
  "Static Constant.

  Constant for the \"Arabic Extended-A\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/ARABIC_EXTENDED_A)

(def *-sundanese-supplement
  "Static Constant.

  Constant for the \"Sundanese Supplement\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/SUNDANESE_SUPPLEMENT)

(def *-meetei-mayek-extensions
  "Static Constant.

  Constant for the \"Meetei Mayek Extensions\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/MEETEI_MAYEK_EXTENSIONS)

(def *-meroitic-hieroglyphs
  "Static Constant.

  Constant for the \"Meroitic Hieroglyphs\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/MEROITIC_HIEROGLYPHS)

(def *-meroitic-cursive
  "Static Constant.

  Constant for the \"Meroitic Cursive\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/MEROITIC_CURSIVE)

(def *-sora-sompeng
  "Static Constant.

  Constant for the \"Sora Sompeng\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/SORA_SOMPENG)

(def *-chakma
  "Static Constant.

  Constant for the \"Chakma\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/CHAKMA)

(def *-sharada
  "Static Constant.

  Constant for the \"Sharada\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/SHARADA)

(def *-takri
  "Static Constant.

  Constant for the \"Takri\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/TAKRI)

(def *-miao
  "Static Constant.

  Constant for the \"Miao\" Unicode character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/MIAO)

(def *-arabic-mathematical-alphabetic-symbols
  "Static Constant.

  Constant for the \"Arabic Mathematical Alphabetic Symbols\" Unicode
   character block.

  type: java.lang.Character$UnicodeBlock"
  Character$UnicodeBlock/ARABIC_MATHEMATICAL_ALPHABETIC_SYMBOLS)

(defn *of
  "Returns the object representing the Unicode block containing the
   given character, or null if the character is not a
   member of a defined block.

   Note: This method cannot handle
    supplementary
   characters.  To support all Unicode characters, including
   supplementary characters, use the of(int) method.

  c - The character in question - `char`

  returns: The UnicodeBlock instance representing the
            Unicode block of which this character is a member, or
            null if the character is not a member of any
            Unicode block - `java.lang.Character$UnicodeBlock`"
  (^java.lang.Character$UnicodeBlock [^Character c]
    (Character$UnicodeBlock/of c)))

(defn *for-name
  "Returns the UnicodeBlock with the given name. Block
   names are determined by The Unicode Standard. The file
   Blocks-<version>.txt defines blocks for a particular
   version of the standard. The Character class specifies
   the version of the standard that it supports.

   This method accepts block names in the following forms:

    Canonical block names as defined by the Unicode Standard.
   For example, the standard defines a \"Basic Latin\" block. Therefore, this
   method accepts \"Basic Latin\" as a valid block name. The documentation of
   each UnicodeBlock provides the canonical name.
   Canonical block names with all spaces removed. For example, \"BasicLatin\"
   is a valid block name for the \"Basic Latin\" block.
   The text representation of each constant UnicodeBlock identifier.
   For example, this method will return the BASIC_LATIN block if
   provided with the \"BASIC_LATIN\" name. This form replaces all spaces and
   hyphens in the canonical name with underscores.

   Finally, character case is ignored for all of the valid block name forms.
   For example, \"BASIC_LATIN\" and \"basic_latin\" are both valid block names.
   The en_US locale's case mapping rules are used to provide case-insensitive
   string comparisons for block name validation.

   If the Unicode Standard changes block names, both the previous and
   current names will be accepted.

  block-name - A UnicodeBlock name. - `java.lang.String`

  returns: The UnicodeBlock instance identified
           by blockName - `java.lang.Character$UnicodeBlock`

  throws: java.lang.IllegalArgumentException - if blockName is an invalid name"
  (^java.lang.Character$UnicodeBlock [^java.lang.String block-name]
    (Character$UnicodeBlock/forName block-name)))

