(ns jdk.awt.event.HierarchyEvent
  "An event which indicates a change to the Component
  hierarchy to which Component belongs.

  Hierarchy Change Events (HierarchyListener)

       addition of an ancestor
       removal of an ancestor
       hierarchy made displayable
       hierarchy made undisplayable
       hierarchy shown on the screen (both visible and displayable)
       hierarchy hidden on the screen (either invisible or undisplayable)

  Ancestor Reshape Events (HierarchyBoundsListener)

       an ancestor was resized
       an ancestor was moved



  Hierarchy events are provided for notification purposes ONLY.
  The AWT will automatically handle changes to the hierarchy internally so
  that GUI layout and displayability works properly regardless of whether a
  program is receiving these events or not.

  This event is generated by a Container object (such as a Panel) when the
  Container is added, removed, moved, or resized, and passed down the
  hierarchy. It is also generated by a Component object when that object's
  addNotify, removeNotify, show, or
  hide method is called. The ANCESTOR_MOVED and
  ANCESTOR_RESIZED
  events are dispatched to every HierarchyBoundsListener or
  HierarchyBoundsAdapter object which registered to receive
  such events using the Component's addHierarchyBoundsListener
  method. (HierarchyBoundsAdapter objects implement the
  HierarchyBoundsListener interface.) The HIERARCHY_CHANGED events are
  dispatched to every HierarchyListener object which registered
  to receive such events using the Component's addHierarchyListener
   method. Each such listener object gets this HierarchyEvent
   when the event occurs.

  An unspecified behavior will be caused if the id parameter
  of any particular HierarchyEvent instance is not
  in the range from HIERARCHY_FIRST to HIERARCHY_LAST.

  The changeFlags parameter of any HierarchyEvent instance takes one of the following
  values:

   HierarchyEvent.PARENT_CHANGED
   HierarchyEvent.DISPLAYABILITY_CHANGED
   HierarchyEvent.SHOWING_CHANGED

  Assigning the value different from listed above will cause unspecified behavior."
  (:refer-clojure :only [require comment defn ->])
  (:import [java.awt.event HierarchyEvent]))

(defn ->hierarchy-event
  "Constructor.

  Constructs an HierarchyEvent object to identify
   a change in the Component hierarchy.
    This method throws an
   IllegalArgumentException if source
   is null.

  source - The Component object that originated the event - `java.awt.Component`
  id - An integer indicating the type of event. For information on allowable values, see the class description for HierarchyEvent - `int`
  changed - The Component at the top of the hierarchy which was changed - `java.awt.Component`
  changed-parent - The parent of the changed component. This may be the parent before or after the change, depending on the type of change - `java.awt.Container`
  change-flags - A bitmask which indicates the type(s) of the HIERARCHY_CHANGED events represented in this event object. For information on allowable values, see the class description for HierarchyEvent - `long`

  throws: java.lang.IllegalArgumentException - if source is null"
  (^HierarchyEvent [^java.awt.Component source ^Integer id ^java.awt.Component changed ^java.awt.Container changed-parent ^Long change-flags]
    (new HierarchyEvent source id changed changed-parent change-flags))
  (^HierarchyEvent [^java.awt.Component source ^Integer id ^java.awt.Component changed ^java.awt.Container changed-parent]
    (new HierarchyEvent source id changed changed-parent)))

(def *-hierarchy-first
  "Static Constant.

  Marks the first integer id for the range of hierarchy event ids.

  type: int"
  HierarchyEvent/HIERARCHY_FIRST)

(def *-hierarchy-changed
  "Static Constant.

  The event id indicating that modification was made to the
   entire hierarchy tree.

  type: int"
  HierarchyEvent/HIERARCHY_CHANGED)

(def *-ancestor-moved
  "Static Constant.

  The event id indicating an ancestor-Container was moved.

  type: int"
  HierarchyEvent/ANCESTOR_MOVED)

(def *-ancestor-resized
  "Static Constant.

  The event id indicating an ancestor-Container was resized.

  type: int"
  HierarchyEvent/ANCESTOR_RESIZED)

(def *-hierarchy-last
  "Static Constant.

  Marks the last integer id for the range of ancestor event ids.

  type: int"
  HierarchyEvent/HIERARCHY_LAST)

(def *-parent-changed
  "Static Constant.

  A change flag indicates that the HIERARCHY_CHANGED event
   was generated by a reparenting operation.

  type: int"
  HierarchyEvent/PARENT_CHANGED)

(def *-displayability-changed
  "Static Constant.

  A change flag indicates that the HIERARCHY_CHANGED event
   was generated due to the changing of the hierarchy displayability.
   To discern the
   current displayability of the hierarchy, call the
   Component.isDisplayable method. Displayability changes occur
   in response to explicit or implicit calls of the
   Component.addNotify and
   Component.removeNotify methods.

  type: int"
  HierarchyEvent/DISPLAYABILITY_CHANGED)

(def *-showing-changed
  "Static Constant.

  A change flag indicates that the HIERARCHY_CHANGED event
   was generated due to the changing of the hierarchy showing state.
   To discern the
   current showing state of the hierarchy, call the
   Component.isShowing method. Showing state changes occur
   when either the displayability or visibility of the
   hierarchy occurs. Visibility changes occur in response to explicit
   or implicit calls of the Component.show and
   Component.hide methods.

  type: int"
  HierarchyEvent/SHOWING_CHANGED)

(defn get-component
  "Returns the originator of the event.

  returns: the Component object that originated
   the event, or null if the object is not a
   Component. - `java.awt.Component`"
  (^java.awt.Component [^HierarchyEvent this]
    (-> this (.getComponent))))

(defn get-changed
  "Returns the Component at the top of the hierarchy which was
   changed.

  returns: the changed Component - `java.awt.Component`"
  (^java.awt.Component [^HierarchyEvent this]
    (-> this (.getChanged))))

(defn get-changed-parent
  "Returns the parent of the Component returned by
   getChanged(). For a HIERARCHY_CHANGED event where the
   change was of type PARENT_CHANGED via a call to
   Container.add, the parent returned is the parent
   after the add operation. For a HIERARCHY_CHANGED event where
   the change was of type PARENT_CHANGED via a call to
   Container.remove, the parent returned is the parent
   before the remove operation. For all other events and types,
   the parent returned is the parent during the operation.

  returns: the parent of the changed Component - `java.awt.Container`"
  (^java.awt.Container [^HierarchyEvent this]
    (-> this (.getChangedParent))))

(defn get-change-flags
  "Returns a bitmask which indicates the type(s) of
   HIERARCHY_CHANGED events represented in this event object.
   The bits have been bitwise-ored together.

  returns: the bitmask, or 0 if this is not an HIERARCHY_CHANGED
   event - `long`"
  (^Long [^HierarchyEvent this]
    (-> this (.getChangeFlags))))

(defn param-string
  "Returns a parameter string identifying this event.
   This method is useful for event-logging and for debugging.

  returns: a string identifying the event and its attributes - `java.lang.String`"
  (^java.lang.String [^HierarchyEvent this]
    (-> this (.paramString))))

