(ns jdk.awt.event.WindowEvent
  "A low-level event that indicates that a window has changed its status. This
  low-level event is generated by a Window object when it is opened, closed,
  activated, deactivated, iconified, or deiconified, or when focus is
  transfered into or out of the Window.

  The event is passed to every WindowListener
  or WindowAdapter object which registered to receive such
  events using the window's addWindowListener method.
  (WindowAdapter objects implement the
  WindowListener interface.) Each such listener object
  gets this WindowEvent when the event occurs.

  An unspecified behavior will be caused if the id parameter
  of any particular WindowEvent instance is not
  in the range from WINDOW_FIRST to WINDOW_LAST."
  (:refer-clojure :only [require comment defn ->])
  (:import [java.awt.event WindowEvent]))

(defn ->window-event
  "Constructor.

  Constructs a WindowEvent object.
   This method throws an
   IllegalArgumentException if source
   is null.

  source - The Window object that originated the event - `java.awt.Window`
  id - An integer indicating the type of event. For information on allowable values, see the class description for WindowEvent - `int`
  opposite - The other window involved in the focus or activation change, or null - `java.awt.Window`
  old-state - Previous state of the window for window state change event. See #getOldState() for allowable values - `int`
  new-state - New state of the window for window state change event. See #getNewState() for allowable values - `int`

  throws: java.lang.IllegalArgumentException - if source is null"
  ([^java.awt.Window source ^Integer id ^java.awt.Window opposite ^Integer old-state ^Integer new-state]
    (new WindowEvent source id opposite old-state new-state))
  ([^java.awt.Window source ^Integer id ^Integer old-state ^Integer new-state]
    (new WindowEvent source id old-state new-state))
  ([^java.awt.Window source ^Integer id ^java.awt.Window opposite]
    (new WindowEvent source id opposite))
  ([^java.awt.Window source ^Integer id]
    (new WindowEvent source id)))

(def *-window-first
  "Static Constant.

  The first number in the range of ids used for window events.

  type: int"
  WindowEvent/WINDOW_FIRST)

(def *-window-opened
  "Static Constant.

  The window opened event.  This event is delivered only
   the first time a window is made visible.

  type: java.lang.annotation.    int"
  WindowEvent/WINDOW_OPENED)

(def *-window-closing
  "Static Constant.

  The `window is closing` event. This event is delivered when
   the user attempts to close the window from the window's system menu.
   If the program does not explicitly hide or dispose the window
   while processing this event, the window close operation will be
   cancelled.

  type: java.lang.annotation.    int"
  WindowEvent/WINDOW_CLOSING)

(def *-window-closed
  "Static Constant.

  The window closed event. This event is delivered after the displayable
   window has been closed as the result of a call to dispose.

  type: java.lang.annotation.    int"
  WindowEvent/WINDOW_CLOSED)

(def *-window-iconified
  "Static Constant.

  The window iconified event. This event is delivered when
   the window has been changed from a normal to a minimized state.
   For many platforms, a minimized window is displayed as
   the icon specified in the window's iconImage property.

  type: java.lang.annotation.    int"
  WindowEvent/WINDOW_ICONIFIED)

(def *-window-deiconified
  "Static Constant.

  The window deiconified event type. This event is delivered when
   the window has been changed from a minimized to a normal state.

  type: java.lang.annotation.    int"
  WindowEvent/WINDOW_DEICONIFIED)

(def *-window-activated
  "Static Constant.

  The window-activated event type. This event is delivered when the Window
   becomes the active Window. Only a Frame or a Dialog can be the active
   Window. The native windowing system may denote the active Window or its
   children with special decorations, such as a highlighted title bar. The
   active Window is always either the focused Window, or the first Frame or
   Dialog that is an owner of the focused Window.

  type: java.lang.annotation.    int"
  WindowEvent/WINDOW_ACTIVATED)

(def *-window-deactivated
  "Static Constant.

  The window-deactivated event type. This event is delivered when the
   Window is no longer the active Window. Only a Frame or a Dialog can be
   the active Window. The native windowing system may denote the active
   Window or its children with special decorations, such as a highlighted
   title bar. The active Window is always either the focused Window, or the
   first Frame or Dialog that is an owner of the focused Window.

  type: java.lang.annotation.    int"
  WindowEvent/WINDOW_DEACTIVATED)

(def *-window-gained-focus
  "Static Constant.

  The window-gained-focus event type. This event is delivered when the
   Window becomes the focused Window, which means that the Window, or one
   of its subcomponents, will receive keyboard events.

  type: java.lang.annotation.    int"
  WindowEvent/WINDOW_GAINED_FOCUS)

(def *-window-lost-focus
  "Static Constant.

  The window-lost-focus event type. This event is delivered when a Window
   is no longer the focused Window, which means keyboard events will no
   longer be delivered to the Window or any of its subcomponents.

  type: java.lang.annotation.    int"
  WindowEvent/WINDOW_LOST_FOCUS)

(def *-window-state-changed
  "Static Constant.

  The window-state-changed event type.  This event is delivered
   when a Window's state is changed by virtue of it being
   iconified, maximized etc.

  type: java.lang.annotation.    int"
  WindowEvent/WINDOW_STATE_CHANGED)

(def *-window-last
  "Static Constant.

  The last number in the range of ids used for window events.

  type: int"
  WindowEvent/WINDOW_LAST)

(defn get-window
  "Returns the originator of the event.

  returns: the Window object that originated the event - `java.awt.Window`"
  (^java.awt.Window [^java.awt.event.WindowEvent this]
    (-> this (.getWindow))))

(defn get-opposite-window
  "Returns the other Window involved in this focus or activation change.
   For a WINDOW_ACTIVATED or WINDOW_GAINED_FOCUS event, this is the Window
   that lost activation or focus. For a WINDOW_DEACTIVATED or
   WINDOW_LOST_FOCUS event, this is the Window that gained activation or
   focus. For any other type of WindowEvent, or if the focus or activation
   change occurs with a native application, with a Java application in a
   different VM or context, or with no other Window, null is returned.

  returns: the other Window involved in the focus or activation change, or
           null - `java.awt.Window`"
  (^java.awt.Window [^java.awt.event.WindowEvent this]
    (-> this (.getOppositeWindow))))

(defn get-old-state
  "For WINDOW_STATE_CHANGED events returns the
   previous state of the window. The state is
   represented as a bitwise mask.

   NORMAL
   Indicates that no state bits are set.
   ICONIFIED
   MAXIMIZED_HORIZ
   MAXIMIZED_VERT
   MAXIMIZED_BOTH
   Concatenates MAXIMIZED_HORIZ
   and MAXIMIZED_VERT.

  returns: a bitwise mask of the previous window state - `int`"
  (^Integer [^java.awt.event.WindowEvent this]
    (-> this (.getOldState))))

(defn get-new-state
  "For WINDOW_STATE_CHANGED events returns the
   new state of the window. The state is
   represented as a bitwise mask.

   NORMAL
   Indicates that no state bits are set.
   ICONIFIED
   MAXIMIZED_HORIZ
   MAXIMIZED_VERT
   MAXIMIZED_BOTH
   Concatenates MAXIMIZED_HORIZ
   and MAXIMIZED_VERT.

  returns: a bitwise mask of the new window state - `int`"
  (^Integer [^java.awt.event.WindowEvent this]
    (-> this (.getNewState))))

(defn param-string
  "Returns a parameter string identifying this event.
   This method is useful for event-logging and for debugging.

  returns: a string identifying the event and its attributes - `java.lang.String`"
  (^java.lang.String [^java.awt.event.WindowEvent this]
    (-> this (.paramString))))

