(ns jdk.awt.event.TextEvent
  "A semantic event which indicates that an object's text changed.
  This high-level event is generated by an object (such as a TextComponent)
  when its text changes. The event is passed to
  every TextListener object which registered to receive such
  events using the component's addTextListener method.

  The object that implements the TextListener interface gets
  this TextEvent when the event occurs. The listener is
  spared the details of processing individual mouse movements and key strokes
  Instead, it can process a `meaningful` (semantic) event like `text changed`.

  An unspecified behavior will be caused if the id parameter
  of any particular TextEvent instance is not
  in the range from TEXT_FIRST to TEXT_LAST."
  (:refer-clojure :only [require comment defn ->])
  (:import [java.awt.event TextEvent]))

(defn ->text-event
  "Constructor.

  Constructs a TextEvent object.
    This method throws an
   IllegalArgumentException if source
   is null.

  source - The (TextComponent) object that originated the event - `java.lang.Object`
  id - An integer that identifies the event type. For information on allowable values, see the class description for TextEvent - `int`

  throws: java.lang.IllegalArgumentException - if source is null"
  ([^java.lang.Object source ^Integer id]
    (new TextEvent source id)))

(def *-text-first
  "Static Constant.

  The first number in the range of ids used for text events.

  type: int"
  TextEvent/TEXT_FIRST)

(def *-text-last
  "Static Constant.

  The last number in the range of ids used for text events.

  type: int"
  TextEvent/TEXT_LAST)

(def *-text-value-changed
  "Static Constant.

  This event id indicates that object's text changed.

  type: int"
  TextEvent/TEXT_VALUE_CHANGED)

(defn param-string
  "Returns a parameter string identifying this text event.
   This method is useful for event-logging and for debugging.

  returns: a string identifying the event and its attributes - `java.lang.String`"
  (^java.lang.String [^java.awt.event.TextEvent this]
    (-> this (.paramString))))

