(ns jdk.awt.event.InputMethodEvent
  "Input method events contain information about text that is being
  composed using an input method. Whenever the text changes, the
  input method sends an event. If the text component that's currently
  using the input method is an active client, the event is dispatched
  to that component. Otherwise, it is dispatched to a separate
  composition window.


  The text included with the input method event consists of two parts:
  committed text and composed text. Either part may be empty. The two
  parts together replace any uncommitted composed text sent in previous events,
  or the currently selected committed text.
  Committed text should be integrated into the text component's persistent
  data, it will not be sent again. Composed text may be sent repeatedly,
  with changes to reflect the user's editing operations. Committed text
  always precedes composed text."
  (:refer-clojure :only [require comment defn ->])
  (:import [java.awt.event InputMethodEvent]))

(defn ->input-method-event
  "Constructor.

  Constructs an InputMethodEvent with the specified
   source component, type, time, text, caret, and visiblePosition.

   The offsets of caret and visiblePosition are relative to the current
   composed text; that is, the composed text within text
   if this is an INPUT_METHOD_TEXT_CHANGED event,
   the composed text within the text of the
   preceding INPUT_METHOD_TEXT_CHANGED event otherwise.
   Note that passing in an invalid id results in
   unspecified behavior. This method throws an
   IllegalArgumentException if source
   is null.

  source - the object where the event originated - `java.awt.Component`
  id - the event type - `int`
  when - a long integer that specifies the time the event occurred - `long`
  text - the combined committed and composed text, committed text first; must be null when the event type is CARET_POSITION_CHANGED; may be null for INPUT_METHOD_TEXT_CHANGED if there's no committed or composed text - `java.text.AttributedCharacterIterator`
  committed-character-count - the number of committed characters in the text - `int`
  caret - the caret (a.k.a. insertion point); null if there's no caret within current composed text - `java.awt.font.TextHitInfo`
  visible-position - the position that's most important to be visible; null if there's no recommendation for a visible position within current composed text - `java.awt.font.TextHitInfo`

  throws: java.lang.IllegalArgumentException - if source is null"
  ([^java.awt.Component source ^Integer id ^Long when ^java.text.AttributedCharacterIterator text ^Integer committed-character-count ^java.awt.font.TextHitInfo caret ^java.awt.font.TextHitInfo visible-position]
    (new InputMethodEvent source id when text committed-character-count caret visible-position))
  ([^java.awt.Component source ^Integer id ^java.text.AttributedCharacterIterator text ^Integer committed-character-count ^java.awt.font.TextHitInfo caret ^java.awt.font.TextHitInfo visible-position]
    (new InputMethodEvent source id text committed-character-count caret visible-position))
  ([^java.awt.Component source ^Integer id ^java.awt.font.TextHitInfo caret ^java.awt.font.TextHitInfo visible-position]
    (new InputMethodEvent source id caret visible-position)))

(def *-input-method-first
  "Static Constant.

  Marks the first integer id for the range of input method event ids.

  type: java.lang.annotation.    int"
  InputMethodEvent/INPUT_METHOD_FIRST)

(def *-input-method-text-changed
  "Static Constant.

  The event type indicating changed input method text. This event is
   generated by input methods while processing input.

  type: java.lang.annotation.    int"
  InputMethodEvent/INPUT_METHOD_TEXT_CHANGED)

(def *-caret-position-changed
  "Static Constant.

  The event type indicating a changed insertion point in input method text.
   This event is
   generated by input methods while processing input if only the caret changed.

  type: java.lang.annotation.    int"
  InputMethodEvent/CARET_POSITION_CHANGED)

(def *-input-method-last
  "Static Constant.

  Marks the last integer id for the range of input method event ids.

  type: java.lang.annotation.    int"
  InputMethodEvent/INPUT_METHOD_LAST)

(defn get-text
  "Gets the combined committed and composed text.
   Characters from index 0 to index getCommittedCharacterCount() - 1 are committed
   text, the remaining characters are composed text.

  returns: the text.
   Always null for CARET_POSITION_CHANGED;
   may be null for INPUT_METHOD_TEXT_CHANGED if there's no composed or committed text. - `java.text.AttributedCharacterIterator`"
  (^java.text.AttributedCharacterIterator [^java.awt.event.InputMethodEvent this]
    (-> this (.getText))))

(defn get-committed-character-count
  "Gets the number of committed characters in the text.

  returns: `int`"
  (^Integer [^java.awt.event.InputMethodEvent this]
    (-> this (.getCommittedCharacterCount))))

(defn get-caret
  "Gets the caret.

   The offset of the caret is relative to the current
   composed text; that is, the composed text within getText()
   if this is an INPUT_METHOD_TEXT_CHANGED event,
   the composed text within getText() of the
   preceding INPUT_METHOD_TEXT_CHANGED event otherwise.

  returns: the caret (a.k.a. insertion point).
   Null if there's no caret within current composed text. - `java.awt.font.TextHitInfo`"
  (^java.awt.font.TextHitInfo [^java.awt.event.InputMethodEvent this]
    (-> this (.getCaret))))

(defn get-visible-position
  "Gets the position that's most important to be visible.

   The offset of the visible position is relative to the current
   composed text; that is, the composed text within getText()
   if this is an INPUT_METHOD_TEXT_CHANGED event,
   the composed text within getText() of the
   preceding INPUT_METHOD_TEXT_CHANGED event otherwise.

  returns: the position that's most important to be visible.
   Null if there's no recommendation for a visible position within current composed text. - `java.awt.font.TextHitInfo`"
  (^java.awt.font.TextHitInfo [^java.awt.event.InputMethodEvent this]
    (-> this (.getVisiblePosition))))

(defn consume
  "Consumes this event so that it will not be processed
   in the default manner by the source which originated it."
  ([^java.awt.event.InputMethodEvent this]
    (-> this (.consume))))

(defn consumed?
  "Returns whether or not this event has been consumed.

  returns: `boolean`"
  (^Boolean [^java.awt.event.InputMethodEvent this]
    (-> this (.isConsumed))))

(defn get-when
  "Returns the time stamp of when this event occurred.

  returns: this event's timestamp - `long`"
  (^Long [^java.awt.event.InputMethodEvent this]
    (-> this (.getWhen))))

(defn param-string
  "Returns a parameter string identifying this event.
   This method is useful for event-logging and for debugging.
   It contains the event ID in text form, the characters of the
   committed and composed text
   separated by `+`, the number of committed characters,
   the caret, and the visible position.

  returns: a string identifying the event and its attributes - `java.lang.String`"
  (^java.lang.String [^java.awt.event.InputMethodEvent this]
    (-> this (.paramString))))

