(ns jdk.awt.event.ComponentEvent
  "A low-level event which indicates that a component moved, changed
  size, or changed visibility (also, the root class for the other
  component-level events).

  Component events are provided for notification purposes ONLY;
  The AWT will automatically handle component moves and resizes
  internally so that GUI layout works properly regardless of
  whether a program is receiving these events or not.

  In addition to serving as the base class for other component-related
  events (InputEvent, FocusEvent, WindowEvent, ContainerEvent),
  this class defines the events that indicate changes in
  a component's size, position, or visibility.

  This low-level event is generated by a component object (such as a
  List) when the component is moved, resized, rendered invisible, or made
  visible again. The event is passed to every ComponentListener
  or ComponentAdapter object which registered to receive such
  events using the component's addComponentListener method.
  (ComponentAdapter objects implement the
  ComponentListener interface.) Each such listener object
  gets this ComponentEvent when the event occurs.

  An unspecified behavior will be caused if the id parameter
  of any particular ComponentEvent instance is not
  in the range from COMPONENT_FIRST to COMPONENT_LAST."
  (:refer-clojure :only [require comment defn ->])
  (:import [java.awt.event ComponentEvent]))

(defn ->component-event
  "Constructor.

  Constructs a ComponentEvent object.
    This method throws an
   IllegalArgumentException if source
   is null.

  source - The Component that originated the event - `java.awt.Component`
  id - An integer indicating the type of event. For information on allowable values, see the class description for ComponentEvent - `int`

  throws: java.lang.IllegalArgumentException - if source is null"
  ([^java.awt.Component source ^Integer id]
    (new ComponentEvent source id)))

(def *-component-first
  "Static Constant.

  The first number in the range of ids used for component events.

  type: int"
  ComponentEvent/COMPONENT_FIRST)

(def *-component-last
  "Static Constant.

  The last number in the range of ids used for component events.

  type: int"
  ComponentEvent/COMPONENT_LAST)

(def *-component-moved
  "Static Constant.

  This event indicates that the component's position changed.

  type: java.lang.annotation.    int"
  ComponentEvent/COMPONENT_MOVED)

(def *-component-resized
  "Static Constant.

  This event indicates that the component's size changed.

  type: java.lang.annotation.    int"
  ComponentEvent/COMPONENT_RESIZED)

(def *-component-shown
  "Static Constant.

  This event indicates that the component was made visible.

  type: java.lang.annotation.    int"
  ComponentEvent/COMPONENT_SHOWN)

(def *-component-hidden
  "Static Constant.

  This event indicates that the component was rendered invisible.

  type: java.lang.annotation.    int"
  ComponentEvent/COMPONENT_HIDDEN)

(defn get-component
  "Returns the originator of the event.

  returns: the Component object that originated
   the event, or null if the object is not a
   Component. - `java.awt.Component`"
  (^java.awt.Component [^java.awt.event.ComponentEvent this]
    (-> this (.getComponent))))

(defn param-string
  "Returns a parameter string identifying this event.
   This method is useful for event-logging and for debugging.

  returns: a string identifying the event and its attributes - `java.lang.String`"
  (^java.lang.String [^java.awt.event.ComponentEvent this]
    (-> this (.paramString))))

