(ns jdk.awt.TextField
  "A TextField object is a text component
  that allows for the editing of a single line of text.

  For example, the following image depicts a frame with four
  text fields of varying widths. Two of these text fields
  display the predefined text `Hello`.



  Here is the code that produces these four text fields:



  TextField tf1, tf2, tf3, tf4;
  // a blank text field
  tf1 = new TextField();
  // blank field of 20 columns
  tf2 = new TextField(``, 20);
  // predefined text displayed
  tf3 = new TextField(`Hello!`);
  // predefined text in 30 columns
  tf4 = new TextField(`Hello`, 30);

  Every time the user types a key in the text field, one or
  more key events are sent to the text field.  A KeyEvent
  may be one of three types: keyPressed, keyReleased, or keyTyped.
  The properties of a key event indicate which of these types
  it is, as well as additional information about the event,
  such as what modifiers are applied to the key event and the
  time at which the event occurred.

  The key event is passed to every KeyListener
  or KeyAdapter object which registered to receive such
  events using the component's addKeyListener method.
  (KeyAdapter objects implement the
  KeyListener interface.)

  It is also possible to fire an ActionEvent.
  If action events are enabled for the text field, they may
  be fired by pressing the Return key.

  The TextField class's processEvent
  method examines the action event and passes it along to
  processActionEvent. The latter method redirects the
  event to any ActionListener objects that have
  registered to receive action events generated by this
  text field."
  (:refer-clojure :only [require comment defn ->])
  (:import [java.awt TextField]))

(defn ->text-field
  "Constructor.

  Constructs a new text field initialized with the specified text
   to be displayed, and wide enough to hold the specified
   number of columns. A column is an approximate average character
   width that is platform-dependent.

  text - the text to be displayed. If text is null, the empty string `` will be displayed. - `java.lang.String`
  columns - the number of columns. If columns is less than 0, columns is set to 0. - `int`

  throws: java.awt.HeadlessException - if GraphicsEnvironment.isHeadless() returns true."
  ([^java.lang.String text ^Integer columns]
    (new TextField text columns))
  ([^java.lang.String text]
    (new TextField text))
  ([]
    (new TextField )))

(defn get-minimum-size
  "Gets the minimum dimensions for a text field with
   the specified number of columns.

  columns - the number of columns in this text field. - `int`

  returns: `java.awt.Dimension`"
  (^java.awt.Dimension [^java.awt.TextField this ^Integer columns]
    (-> this (.getMinimumSize columns)))
  (^java.awt.Dimension [^java.awt.TextField this]
    (-> this (.getMinimumSize))))

(defn get-echo-char
  "Gets the character that is to be used for echoing.

   An echo character is useful for text fields where
   user input should not be echoed to the screen, as in
   the case of a text field for entering a password.
   If echoChar = 0, user
   input is echoed to the screen unchanged.

   A Java platform implementation may support only a limited,
   non-empty set of echo characters. This function returns the
   echo character originally requested via setEchoChar(). The echo
   character actually used by the TextField implementation might be
   different.

  returns: the echo character for this text field. - `char`"
  (^Character [^java.awt.TextField this]
    (-> this (.getEchoChar))))

(defn set-columns
  "Sets the number of columns in this text field. A column is an
   approximate average character width that is platform-dependent.

  columns - the number of columns. - `int`

  throws: java.lang.IllegalArgumentException - if the value supplied for columns is less than 0."
  ([^java.awt.TextField this ^Integer columns]
    (-> this (.setColumns columns))))

(defn set-text
  "Sets the text that is presented by this
   text component to be the specified text.

  t - the new text. - `java.lang.String`"
  ([^java.awt.TextField this ^java.lang.String t]
    (-> this (.setText t))))

(defn set-echo-character
  "Deprecated. As of JDK version 1.1,
   replaced by setEchoChar(char).

  c - `char`

  returns: `java.lang.  void`"
  ([^java.awt.TextField this ^Character c]
    (-> this (.setEchoCharacter c))))

(defn get-columns
  "Gets the number of columns in this text field. A column is an
   approximate average character width that is platform-dependent.

  returns: the number of columns. - `int`"
  (^Integer [^java.awt.TextField this]
    (-> this (.getColumns))))

(defn add-action-listener
  "Adds the specified action listener to receive
   action events from this text field.
   If l is null, no exception is thrown and no action is performed.
   Refer to AWT Threading Issues for details on AWT's threading model.

  l - the action listener. - `java.awt.event.ActionListener`"
  ([^java.awt.TextField this ^java.awt.event.ActionListener l]
    (-> this (.addActionListener l))))

(defn add-notify
  "Creates the TextField's peer.  The peer allows us to modify the
   appearance of the TextField without changing its functionality."
  ([^java.awt.TextField this]
    (-> this (.addNotify))))

(defn set-echo-char
  "Sets the echo character for this text field.

   An echo character is useful for text fields where
   user input should not be echoed to the screen, as in
   the case of a text field for entering a password.
   Setting echoChar = 0 allows
   user input to be echoed to the screen again.

   A Java platform implementation may support only a limited,
   non-empty set of echo characters. Attempts to set an
   unsupported echo character will cause the default echo
   character to be used instead. Subsequent calls to getEchoChar()
   will return the echo character originally requested. This might
   or might not be identical to the echo character actually
   used by the TextField implementation.

  c - the echo character for this text field. - `char`"
  ([^java.awt.TextField this ^Character c]
    (-> this (.setEchoChar c))))

(defn get-action-listeners
  "Returns an array of all the action listeners
   registered on this textfield.

  returns: all of this textfield's ActionListeners
           or an empty array if no action
           listeners are currently registered - `java.awt.event.ActionListener[]`"
  ([^java.awt.TextField this]
    (-> this (.getActionListeners))))

(defn preferred-size
  "Deprecated. As of JDK version 1.1,
   replaced by getPreferredSize(int).

  columns - `int`

  returns: `java.lang.  java.awt.Dimension`"
  ([^java.awt.TextField this ^Integer columns]
    (-> this (.preferredSize columns)))
  ([^java.awt.TextField this]
    (-> this (.preferredSize))))

(defn get-accessible-context
  "Gets the AccessibleContext associated with this TextField.
   For text fields, the AccessibleContext takes the form of an
   AccessibleAWTTextField.
   A new AccessibleAWTTextField instance is created if necessary.

  returns: an AccessibleAWTTextField that serves as the
           AccessibleContext of this TextField - `javax.accessibility.AccessibleContext`"
  (^javax.accessibility.AccessibleContext [^java.awt.TextField this]
    (-> this (.getAccessibleContext))))

(defn echo-char-is-set
  "Indicates whether or not this text field has a
   character set for echoing.

   An echo character is useful for text fields where
   user input should not be echoed to the screen, as in
   the case of a text field for entering a password.

  returns: true if this text field has
                   a character set for echoing;
                   false otherwise. - `boolean`"
  (^Boolean [^java.awt.TextField this]
    (-> this (.echoCharIsSet))))

(defn remove-action-listener
  "Removes the specified action listener so that it no longer
   receives action events from this text field.
   If l is null, no exception is thrown and no action is performed.
   Refer to AWT Threading Issues for details on AWT's threading model.

  l - the action listener. - `java.awt.event.ActionListener`"
  ([^java.awt.TextField this ^java.awt.event.ActionListener l]
    (-> this (.removeActionListener l))))

(defn get-listeners
  "Returns an array of all the objects currently registered
   as FooListeners
   upon this TextField.
   FooListeners are registered using the
   addFooListener method.


   You can specify the listenerType argument
   with a class literal, such as
   FooListener.class.
   For example, you can query a
   TextField t
   for its action listeners with the following code:



  ActionListener[] als = (ActionListener[])(t.getListeners(ActionListener.class));

   If no such listeners exist, this method returns an empty array.

  listener-type - the type of listeners requested; this parameter should specify an interface that descends from java.util.EventListener - `java.lang.Class<T>`

  returns: an array of all objects registered as
            FooListeners on this textfield,
            or an empty array if no such
            listeners have been added - `<T extends java.util.EventListener> T[]`

  throws: java.lang.ClassCastException - if listenerType doesn't specify a class or interface that implements java.util.EventListener"
  ([^java.awt.TextField this ^java.lang.Class listener-type]
    (-> this (.getListeners listener-type))))

(defn minimum-size
  "Deprecated. As of JDK version 1.1,
   replaced by getMinimumSize(int).

  columns - `int`

  returns: `java.lang.  java.awt.Dimension`"
  ([^java.awt.TextField this ^Integer columns]
    (-> this (.minimumSize columns)))
  ([^java.awt.TextField this]
    (-> this (.minimumSize))))

(defn get-preferred-size
  "Gets the preferred size of this text field
   with the specified number of columns.

  columns - the number of columns in this text field. - `int`

  returns: the preferred dimensions for
                   displaying this text field. - `java.awt.Dimension`"
  (^java.awt.Dimension [^java.awt.TextField this ^Integer columns]
    (-> this (.getPreferredSize columns)))
  (^java.awt.Dimension [^java.awt.TextField this]
    (-> this (.getPreferredSize))))

