(ns jdk.awt.event.KeyEvent
  "An event which indicates that a keystroke occurred in a component.

  This low-level event is generated by a component object (such as a text
  field) when a key is pressed, released, or typed.
  The event is passed to every KeyListener
  or KeyAdapter object which registered to receive such
  events using the component's addKeyListener method.
  (KeyAdapter objects implement the
  KeyListener interface.)  Each such listener object
  gets this KeyEvent when the event occurs.

  `Key typed` events are higher-level and generally do not depend on
  the platform or keyboard layout.  They are generated when a Unicode character
  is entered, and are the preferred way to find out about character input.
  In the simplest case, a key typed event is produced by a single key press
  (e.g., 'a').  Often, however, characters are produced by series of key
  presses (e.g., 'shift'  'a'), and the mapping from key pressed events to
  key typed events may be many-to-one or many-to-many.  Key releases are not
  usually necessary to generate a key typed event, but there are some cases
  where the key typed event is not generated until a key is released (e.g.,
  entering ASCII sequences via the Alt-Numpad method in Windows).
  No key typed events are generated for keys that don't generate Unicode
  characters (e.g., action keys, modifier keys, etc.).

  The getKeyChar method always returns a valid Unicode character or
  CHAR_UNDEFINED.  Character input is reported by KEY_TYPED events:
  KEY_PRESSED and KEY_RELEASED events are not necessarily associated
  with character input.  Therefore, the result of the getKeyChar method
  is guaranteed to be meaningful only for KEY_TYPED events.

  For key pressed and key released events, the getKeyCode method returns
  the event's keyCode.  For key typed events, the getKeyCode method
  always returns VK_UNDEFINED. The getExtendedKeyCode method
  may also be used with many international keyboard layouts.


  `Key pressed` and `key released` events are lower-level and depend
  on the platform and keyboard layout. They are generated whenever a key is
  pressed or released, and are the only way to find out about keys that don't
  generate character input (e.g., action keys, modifier keys, etc.). The key
  being pressed or released is indicated by the getKeyCode and getExtendedKeyCode
  methods, which return a virtual key code.


  Virtual key codes are used to report which keyboard key has
  been pressed, rather than a character generated by the combination
  of one or more keystrokes (such as `A`, which comes from shift and `a`).


  For example, pressing the Shift key will cause a KEY_PRESSED event
  with a VK_SHIFT keyCode, while pressing the 'a' key will result in
  a VK_A keyCode.  After the 'a' key is released, a KEY_RELEASED event
  will be fired with VK_A. Separately, a KEY_TYPED event with a keyChar
  value of 'A' is generated.


  Pressing and releasing a key on the keyboard results in the generating
  the following key events (in order):


      KEY_PRESSED
      KEY_TYPED (is only generated if a valid Unicode character could be generated.)
      KEY_RELEASED

  But in some cases (e.g. auto-repeat or input method is activated) the order
  could be different (and platform dependent).


  Notes:

  Key combinations which do not result in Unicode characters, such as action
  keys like F1 and the HELP key, do not generate KEY_TYPED events.
  Not all keyboards or systems are capable of generating all
  virtual key codes.  No attempt is made in Java to generate these keys
  artificially.
  Virtual key codes do not identify a physical key: they depend on the
  platform and keyboard layout. For example, the key that generates VK_Q
  when using a U.S. keyboard layout will generate VK_A when using a French
  keyboard layout.
  The key that generates VK_Q when using a U.S. keyboard layout also
  generates a unique code for Russian or Hebrew layout. There is no a
  VK_ constant for these and many other codes in various layouts. These codes
  may be obtained by using getExtendedKeyCode and are used whenever
  a VK_ constant is used.
  Not all characters have a keycode associated with them.  For example,
  there is no keycode for the question mark because there is no keyboard
  for which it appears on the primary layer.
  In order to support the platform-independent handling of action keys,
  the Java platform uses a few additional virtual key constants for functions
  that would otherwise have to be recognized by interpreting virtual key codes
  and modifiers. For example, for Japanese Windows keyboards, VK_ALL_CANDIDATES
  is returned instead of VK_CONVERT with the ALT modifier.
  As specified in Focus Specification
  key events are dispatched to the focus owner by default.



  WARNING: Aside from those keys that are defined by the Java language
  (VK_ENTER, VK_BACK_SPACE, and VK_TAB), do not rely on the values of the VK_
  constants.  Sun reserves the right to change these values as needed
  to accommodate a wider range of keyboards in the future.

  An unspecified behavior will be caused if the id parameter
  of any particular KeyEvent instance is not
  in the range from KEY_FIRST to KEY_LAST."
  (:refer-clojure :only [require comment defn ->])
  (:import [java.awt.event KeyEvent]))

(defn ->key-event
  "Constructor.

  Constructs a KeyEvent object.
   This method throws an
   IllegalArgumentException if source
   is null.

  source - The Component that originated the event - `java.awt.Component`
  id - An integer indicating the type of event. For information on allowable values, see the class description for KeyEvent - `int`
  when - A long integer that specifies the time the event occurred. Passing negative or zero value is not recommended - `long`
  modifiers - The modifier keys down during event (shift, ctrl, alt, meta). Passing negative value is not recommended. Zero value means that no modifiers were passed. Use either an extended _DOWN_MASK or old _MASK modifiers, however do not mix models in the one event. The extended modifiers are preferred for using - `int`
  key-code - The integer code for an actual key, or VK_UNDEFINED (for a key-typed event) - `int`
  key-char - The Unicode character generated by this event, or CHAR_UNDEFINED (for key-pressed and key-released events which do not map to a valid Unicode character) - `char`
  key-location - Identifies the key location. The only legal values are KEY_LOCATION_UNKNOWN, KEY_LOCATION_STANDARD, KEY_LOCATION_LEFT, KEY_LOCATION_RIGHT, and KEY_LOCATION_NUMPAD. - `int`

  throws: java.lang.IllegalArgumentException - if source is null"
  ([^java.awt.Component source ^Integer id ^Long when ^Integer modifiers ^Integer key-code ^Character key-char ^Integer key-location]
    (new KeyEvent source id when modifiers key-code key-char key-location))
  ([^java.awt.Component source ^Integer id ^Long when ^Integer modifiers ^Integer key-code ^Character key-char]
    (new KeyEvent source id when modifiers key-code key-char))
  ([^java.awt.Component source ^Integer id ^Long when ^Integer modifiers ^Integer key-code]
    (new KeyEvent source id when modifiers key-code)))

(def *-key-first
  "Static Constant.

  The first number in the range of ids used for key events.

  type: int"
  KeyEvent/KEY_FIRST)

(def *-key-last
  "Static Constant.

  The last number in the range of ids used for key events.

  type: int"
  KeyEvent/KEY_LAST)

(def *-key-typed
  "Static Constant.

  The `key typed` event.  This event is generated when a character is
   entered.  In the simplest case, it is produced by a single key press.
   Often, however, characters are produced by series of key presses, and
   the mapping from key pressed events to key typed events may be
   many-to-one or many-to-many.

  type: int"
  KeyEvent/KEY_TYPED)

(def *-key-pressed
  "Static Constant.

  The `key pressed` event. This event is generated when a key
   is pushed down.

  type: int"
  KeyEvent/KEY_PRESSED)

(def *-key-released
  "Static Constant.

  The `key released` event. This event is generated when a key
   is let up.

  type: int"
  KeyEvent/KEY_RELEASED)

(def *-vk-enter
  "Static Constant.

  type: int"
  KeyEvent/VK_ENTER)

(def *-vk-back-space
  "Static Constant.

  type: int"
  KeyEvent/VK_BACK_SPACE)

(def *-vk-tab
  "Static Constant.

  type: int"
  KeyEvent/VK_TAB)

(def *-vk-cancel
  "Static Constant.

  type: int"
  KeyEvent/VK_CANCEL)

(def *-vk-clear
  "Static Constant.

  type: int"
  KeyEvent/VK_CLEAR)

(def *-vk-shift
  "Static Constant.

  type: int"
  KeyEvent/VK_SHIFT)

(def *-vk-control
  "Static Constant.

  type: int"
  KeyEvent/VK_CONTROL)

(def *-vk-alt
  "Static Constant.

  type: int"
  KeyEvent/VK_ALT)

(def *-vk-pause
  "Static Constant.

  type: int"
  KeyEvent/VK_PAUSE)

(def *-vk-caps-lock
  "Static Constant.

  type: int"
  KeyEvent/VK_CAPS_LOCK)

(def *-vk-escape
  "Static Constant.

  type: int"
  KeyEvent/VK_ESCAPE)

(def *-vk-space
  "Static Constant.

  type: int"
  KeyEvent/VK_SPACE)

(def *-vk-page-up
  "Static Constant.

  type: int"
  KeyEvent/VK_PAGE_UP)

(def *-vk-page-down
  "Static Constant.

  type: int"
  KeyEvent/VK_PAGE_DOWN)

(def *-vk-end
  "Static Constant.

  type: int"
  KeyEvent/VK_END)

(def *-vk-home
  "Static Constant.

  type: int"
  KeyEvent/VK_HOME)

(def *-vk-left
  "Static Constant.

  Constant for the non-numpad left arrow key.

  type: int"
  KeyEvent/VK_LEFT)

(def *-vk-up
  "Static Constant.

  Constant for the non-numpad up arrow key.

  type: int"
  KeyEvent/VK_UP)

(def *-vk-right
  "Static Constant.

  Constant for the non-numpad right arrow key.

  type: int"
  KeyEvent/VK_RIGHT)

(def *-vk-down
  "Static Constant.

  Constant for the non-numpad down arrow key.

  type: int"
  KeyEvent/VK_DOWN)

(def *-vk-comma
  "Static Constant.

  Constant for the comma key, `,`

  type: int"
  KeyEvent/VK_COMMA)

(def *-vk-minus
  "Static Constant.

  Constant for the minus key, `-`

  type: int"
  KeyEvent/VK_MINUS)

(def *-vk-period
  "Static Constant.

  Constant for the period key, `.`

  type: int"
  KeyEvent/VK_PERIOD)

(def *-vk-slash
  "Static Constant.

  Constant for the forward slash key, `/`

  type: int"
  KeyEvent/VK_SLASH)

(def *-vk-0
  "Static Constant.

  VK_0 thru VK_9 are the same as ASCII '0' thru '9' (0x30 - 0x39)

  type: int"
  KeyEvent/VK_0)

(def *-vk-1
  "Static Constant.

  type: int"
  KeyEvent/VK_1)

(def *-vk-2
  "Static Constant.

  type: int"
  KeyEvent/VK_2)

(def *-vk-3
  "Static Constant.

  type: int"
  KeyEvent/VK_3)

(def *-vk-4
  "Static Constant.

  type: int"
  KeyEvent/VK_4)

(def *-vk-5
  "Static Constant.

  type: int"
  KeyEvent/VK_5)

(def *-vk-6
  "Static Constant.

  type: int"
  KeyEvent/VK_6)

(def *-vk-7
  "Static Constant.

  type: int"
  KeyEvent/VK_7)

(def *-vk-8
  "Static Constant.

  type: int"
  KeyEvent/VK_8)

(def *-vk-9
  "Static Constant.

  type: int"
  KeyEvent/VK_9)

(def *-vk-semicolon
  "Static Constant.

  Constant for the semicolon key, `;`

  type: int"
  KeyEvent/VK_SEMICOLON)

(def *-vk-equals
  "Static Constant.

  Constant for the equals key, `=`

  type: int"
  KeyEvent/VK_EQUALS)

(def *-vk-a
  "Static Constant.

  VK_A thru VK_Z are the same as ASCII 'A' thru 'Z' (0x41 - 0x5A)

  type: int"
  KeyEvent/VK_A)

(def *-vk-b
  "Static Constant.

  type: int"
  KeyEvent/VK_B)

(def *-vk-c
  "Static Constant.

  type: int"
  KeyEvent/VK_C)

(def *-vk-d
  "Static Constant.

  type: int"
  KeyEvent/VK_D)

(def *-vk-e
  "Static Constant.

  type: int"
  KeyEvent/VK_E)

(def *-vk-f
  "Static Constant.

  type: int"
  KeyEvent/VK_F)

(def *-vk-g
  "Static Constant.

  type: int"
  KeyEvent/VK_G)

(def *-vk-h
  "Static Constant.

  type: int"
  KeyEvent/VK_H)

(def *-vk-i
  "Static Constant.

  type: int"
  KeyEvent/VK_I)

(def *-vk-j
  "Static Constant.

  type: int"
  KeyEvent/VK_J)

(def *-vk-k
  "Static Constant.

  type: int"
  KeyEvent/VK_K)

(def *-vk-l
  "Static Constant.

  type: int"
  KeyEvent/VK_L)

(def *-vk-m
  "Static Constant.

  type: int"
  KeyEvent/VK_M)

(def *-vk-n
  "Static Constant.

  type: int"
  KeyEvent/VK_N)

(def *-vk-o
  "Static Constant.

  type: int"
  KeyEvent/VK_O)

(def *-vk-p
  "Static Constant.

  type: int"
  KeyEvent/VK_P)

(def *-vk-q
  "Static Constant.

  type: int"
  KeyEvent/VK_Q)

(def *-vk-r
  "Static Constant.

  type: int"
  KeyEvent/VK_R)

(def *-vk-s
  "Static Constant.

  type: int"
  KeyEvent/VK_S)

(def *-vk-t
  "Static Constant.

  type: int"
  KeyEvent/VK_T)

(def *-vk-u
  "Static Constant.

  type: int"
  KeyEvent/VK_U)

(def *-vk-v
  "Static Constant.

  type: int"
  KeyEvent/VK_V)

(def *-vk-w
  "Static Constant.

  type: int"
  KeyEvent/VK_W)

(def *-vk-x
  "Static Constant.

  type: int"
  KeyEvent/VK_X)

(def *-vk-y
  "Static Constant.

  type: int"
  KeyEvent/VK_Y)

(def *-vk-z
  "Static Constant.

  type: int"
  KeyEvent/VK_Z)

(def *-vk-open-bracket
  "Static Constant.

  Constant for the open bracket key, `[`

  type: int"
  KeyEvent/VK_OPEN_BRACKET)

(def *-vk-back-slash
  "Static Constant.

  Constant for the back slash key, `\`

  type: int"
  KeyEvent/VK_BACK_SLASH)

(def *-vk-close-bracket
  "Static Constant.

  Constant for the close bracket key, `]`

  type: int"
  KeyEvent/VK_CLOSE_BRACKET)

(def *-vk-numpad-0
  "Static Constant.

  type: int"
  KeyEvent/VK_NUMPAD0)

(def *-vk-numpad-1
  "Static Constant.

  type: int"
  KeyEvent/VK_NUMPAD1)

(def *-vk-numpad-2
  "Static Constant.

  type: int"
  KeyEvent/VK_NUMPAD2)

(def *-vk-numpad-3
  "Static Constant.

  type: int"
  KeyEvent/VK_NUMPAD3)

(def *-vk-numpad-4
  "Static Constant.

  type: int"
  KeyEvent/VK_NUMPAD4)

(def *-vk-numpad-5
  "Static Constant.

  type: int"
  KeyEvent/VK_NUMPAD5)

(def *-vk-numpad-6
  "Static Constant.

  type: int"
  KeyEvent/VK_NUMPAD6)

(def *-vk-numpad-7
  "Static Constant.

  type: int"
  KeyEvent/VK_NUMPAD7)

(def *-vk-numpad-8
  "Static Constant.

  type: int"
  KeyEvent/VK_NUMPAD8)

(def *-vk-numpad-9
  "Static Constant.

  type: int"
  KeyEvent/VK_NUMPAD9)

(def *-vk-multiply
  "Static Constant.

  type: int"
  KeyEvent/VK_MULTIPLY)

(def *-vk-add
  "Static Constant.

  type: int"
  KeyEvent/VK_ADD)

(def *-vk-separater
  "Static Constant.

  This constant is obsolete, and is included only for backwards
   compatibility.

  type: int"
  KeyEvent/VK_SEPARATER)

(def *-vk-separator
  "Static Constant.

  Constant for the Numpad Separator key.

  type: int"
  KeyEvent/VK_SEPARATOR)

(def *-vk-subtract
  "Static Constant.

  type: int"
  KeyEvent/VK_SUBTRACT)

(def *-vk-decimal
  "Static Constant.

  type: int"
  KeyEvent/VK_DECIMAL)

(def *-vk-divide
  "Static Constant.

  type: int"
  KeyEvent/VK_DIVIDE)

(def *-vk-delete
  "Static Constant.

  type: int"
  KeyEvent/VK_DELETE)

(def *-vk-num-lock
  "Static Constant.

  type: int"
  KeyEvent/VK_NUM_LOCK)

(def *-vk-scroll-lock
  "Static Constant.

  type: int"
  KeyEvent/VK_SCROLL_LOCK)

(def *-vk-f-1
  "Static Constant.

  Constant for the F1 function key.

  type: int"
  KeyEvent/VK_F1)

(def *-vk-f-2
  "Static Constant.

  Constant for the F2 function key.

  type: int"
  KeyEvent/VK_F2)

(def *-vk-f-3
  "Static Constant.

  Constant for the F3 function key.

  type: int"
  KeyEvent/VK_F3)

(def *-vk-f-4
  "Static Constant.

  Constant for the F4 function key.

  type: int"
  KeyEvent/VK_F4)

(def *-vk-f-5
  "Static Constant.

  Constant for the F5 function key.

  type: int"
  KeyEvent/VK_F5)

(def *-vk-f-6
  "Static Constant.

  Constant for the F6 function key.

  type: int"
  KeyEvent/VK_F6)

(def *-vk-f-7
  "Static Constant.

  Constant for the F7 function key.

  type: int"
  KeyEvent/VK_F7)

(def *-vk-f-8
  "Static Constant.

  Constant for the F8 function key.

  type: int"
  KeyEvent/VK_F8)

(def *-vk-f-9
  "Static Constant.

  Constant for the F9 function key.

  type: int"
  KeyEvent/VK_F9)

(def *-vk-f-10
  "Static Constant.

  Constant for the F10 function key.

  type: int"
  KeyEvent/VK_F10)

(def *-vk-f-11
  "Static Constant.

  Constant for the F11 function key.

  type: int"
  KeyEvent/VK_F11)

(def *-vk-f-12
  "Static Constant.

  Constant for the F12 function key.

  type: int"
  KeyEvent/VK_F12)

(def *-vk-f-13
  "Static Constant.

  Constant for the F13 function key.

  type: int"
  KeyEvent/VK_F13)

(def *-vk-f-14
  "Static Constant.

  Constant for the F14 function key.

  type: int"
  KeyEvent/VK_F14)

(def *-vk-f-15
  "Static Constant.

  Constant for the F15 function key.

  type: int"
  KeyEvent/VK_F15)

(def *-vk-f-16
  "Static Constant.

  Constant for the F16 function key.

  type: int"
  KeyEvent/VK_F16)

(def *-vk-f-17
  "Static Constant.

  Constant for the F17 function key.

  type: int"
  KeyEvent/VK_F17)

(def *-vk-f-18
  "Static Constant.

  Constant for the F18 function key.

  type: int"
  KeyEvent/VK_F18)

(def *-vk-f-19
  "Static Constant.

  Constant for the F19 function key.

  type: int"
  KeyEvent/VK_F19)

(def *-vk-f-20
  "Static Constant.

  Constant for the F20 function key.

  type: int"
  KeyEvent/VK_F20)

(def *-vk-f-21
  "Static Constant.

  Constant for the F21 function key.

  type: int"
  KeyEvent/VK_F21)

(def *-vk-f-22
  "Static Constant.

  Constant for the F22 function key.

  type: int"
  KeyEvent/VK_F22)

(def *-vk-f-23
  "Static Constant.

  Constant for the F23 function key.

  type: int"
  KeyEvent/VK_F23)

(def *-vk-f-24
  "Static Constant.

  Constant for the F24 function key.

  type: int"
  KeyEvent/VK_F24)

(def *-vk-printscreen
  "Static Constant.

  type: int"
  KeyEvent/VK_PRINTSCREEN)

(def *-vk-insert
  "Static Constant.

  type: int"
  KeyEvent/VK_INSERT)

(def *-vk-help
  "Static Constant.

  type: int"
  KeyEvent/VK_HELP)

(def *-vk-meta
  "Static Constant.

  type: int"
  KeyEvent/VK_META)

(def *-vk-back-quote
  "Static Constant.

  type: int"
  KeyEvent/VK_BACK_QUOTE)

(def *-vk-quote
  "Static Constant.

  type: int"
  KeyEvent/VK_QUOTE)

(def *-vk-kp-up
  "Static Constant.

  Constant for the numeric keypad up arrow key.

  type: int"
  KeyEvent/VK_KP_UP)

(def *-vk-kp-down
  "Static Constant.

  Constant for the numeric keypad down arrow key.

  type: int"
  KeyEvent/VK_KP_DOWN)

(def *-vk-kp-left
  "Static Constant.

  Constant for the numeric keypad left arrow key.

  type: int"
  KeyEvent/VK_KP_LEFT)

(def *-vk-kp-right
  "Static Constant.

  Constant for the numeric keypad right arrow key.

  type: int"
  KeyEvent/VK_KP_RIGHT)

(def *-vk-dead-grave
  "Static Constant.

  type: int"
  KeyEvent/VK_DEAD_GRAVE)

(def *-vk-dead-acute
  "Static Constant.

  type: int"
  KeyEvent/VK_DEAD_ACUTE)

(def *-vk-dead-circumflex
  "Static Constant.

  type: int"
  KeyEvent/VK_DEAD_CIRCUMFLEX)

(def *-vk-dead-tilde
  "Static Constant.

  type: int"
  KeyEvent/VK_DEAD_TILDE)

(def *-vk-dead-macron
  "Static Constant.

  type: int"
  KeyEvent/VK_DEAD_MACRON)

(def *-vk-dead-breve
  "Static Constant.

  type: int"
  KeyEvent/VK_DEAD_BREVE)

(def *-vk-dead-abovedot
  "Static Constant.

  type: int"
  KeyEvent/VK_DEAD_ABOVEDOT)

(def *-vk-dead-diaeresis
  "Static Constant.

  type: int"
  KeyEvent/VK_DEAD_DIAERESIS)

(def *-vk-dead-abovering
  "Static Constant.

  type: int"
  KeyEvent/VK_DEAD_ABOVERING)

(def *-vk-dead-doubleacute
  "Static Constant.

  type: int"
  KeyEvent/VK_DEAD_DOUBLEACUTE)

(def *-vk-dead-caron
  "Static Constant.

  type: int"
  KeyEvent/VK_DEAD_CARON)

(def *-vk-dead-cedilla
  "Static Constant.

  type: int"
  KeyEvent/VK_DEAD_CEDILLA)

(def *-vk-dead-ogonek
  "Static Constant.

  type: int"
  KeyEvent/VK_DEAD_OGONEK)

(def *-vk-dead-iota
  "Static Constant.

  type: int"
  KeyEvent/VK_DEAD_IOTA)

(def *-vk-dead-voiced-sound
  "Static Constant.

  type: int"
  KeyEvent/VK_DEAD_VOICED_SOUND)

(def *-vk-dead-semivoiced-sound
  "Static Constant.

  type: int"
  KeyEvent/VK_DEAD_SEMIVOICED_SOUND)

(def *-vk-ampersand
  "Static Constant.

  type: int"
  KeyEvent/VK_AMPERSAND)

(def *-vk-asterisk
  "Static Constant.

  type: int"
  KeyEvent/VK_ASTERISK)

(def *-vk-quotedbl
  "Static Constant.

  type: int"
  KeyEvent/VK_QUOTEDBL)

(def *-vk-less
  "Static Constant.

  type: int"
  KeyEvent/VK_LESS)

(def *-vk-greater
  "Static Constant.

  type: int"
  KeyEvent/VK_GREATER)

(def *-vk-braceleft
  "Static Constant.

  type: int"
  KeyEvent/VK_BRACELEFT)

(def *-vk-braceright
  "Static Constant.

  type: int"
  KeyEvent/VK_BRACERIGHT)

(def *-vk-at
  "Static Constant.

  Constant for the `@` key.

  type: int"
  KeyEvent/VK_AT)

(def *-vk-colon
  "Static Constant.

  Constant for the `:` key.

  type: int"
  KeyEvent/VK_COLON)

(def *-vk-circumflex
  "Static Constant.

  Constant for the `^` key.

  type: int"
  KeyEvent/VK_CIRCUMFLEX)

(def *-vk-dollar
  "Static Constant.

  Constant for the `$` key.

  type: int"
  KeyEvent/VK_DOLLAR)

(def *-vk-euro-sign
  "Static Constant.

  Constant for the Euro currency sign key.

  type: int"
  KeyEvent/VK_EURO_SIGN)

(def *-vk-exclamation-mark
  "Static Constant.

  Constant for the `!` key.

  type: int"
  KeyEvent/VK_EXCLAMATION_MARK)

(def *-vk-inverted-exclamation-mark
  "Static Constant.

  Constant for the inverted exclamation mark key.

  type: int"
  KeyEvent/VK_INVERTED_EXCLAMATION_MARK)

(def *-vk-left-parenthesis
  "Static Constant.

  Constant for the `(` key.

  type: int"
  KeyEvent/VK_LEFT_PARENTHESIS)

(def *-vk-number-sign
  "Static Constant.

  Constant for the `#` key.

  type: int"
  KeyEvent/VK_NUMBER_SIGN)

(def *-vk-plus
  "Static Constant.

  Constant for the `+` key.

  type: int"
  KeyEvent/VK_PLUS)

(def *-vk-right-parenthesis
  "Static Constant.

  Constant for the `)` key.

  type: int"
  KeyEvent/VK_RIGHT_PARENTHESIS)

(def *-vk-underscore
  "Static Constant.

  Constant for the `_` key.

  type: int"
  KeyEvent/VK_UNDERSCORE)

(def *-vk-windows
  "Static Constant.

  Constant for the Microsoft Windows `Windows` key.
   It is used for both the left and right version of the key.

  type: int"
  KeyEvent/VK_WINDOWS)

(def *-vk-context-menu
  "Static Constant.

  Constant for the Microsoft Windows Context Menu key.

  type: int"
  KeyEvent/VK_CONTEXT_MENU)

(def *-vk-final
  "Static Constant.

  type: int"
  KeyEvent/VK_FINAL)

(def *-vk-convert
  "Static Constant.

  Constant for the Convert function key.

  type: int"
  KeyEvent/VK_CONVERT)

(def *-vk-nonconvert
  "Static Constant.

  Constant for the Don't Convert function key.

  type: int"
  KeyEvent/VK_NONCONVERT)

(def *-vk-accept
  "Static Constant.

  Constant for the Accept or Commit function key.

  type: int"
  KeyEvent/VK_ACCEPT)

(def *-vk-modechange
  "Static Constant.

  type: int"
  KeyEvent/VK_MODECHANGE)

(def *-vk-kana
  "Static Constant.

  type: int"
  KeyEvent/VK_KANA)

(def *-vk-kanji
  "Static Constant.

  type: int"
  KeyEvent/VK_KANJI)

(def *-vk-alphanumeric
  "Static Constant.

  Constant for the Alphanumeric function key.

  type: int"
  KeyEvent/VK_ALPHANUMERIC)

(def *-vk-katakana
  "Static Constant.

  Constant for the Katakana function key.

  type: int"
  KeyEvent/VK_KATAKANA)

(def *-vk-hiragana
  "Static Constant.

  Constant for the Hiragana function key.

  type: int"
  KeyEvent/VK_HIRAGANA)

(def *-vk-full-width
  "Static Constant.

  Constant for the Full-Width Characters function key.

  type: int"
  KeyEvent/VK_FULL_WIDTH)

(def *-vk-half-width
  "Static Constant.

  Constant for the Half-Width Characters function key.

  type: int"
  KeyEvent/VK_HALF_WIDTH)

(def *-vk-roman-characters
  "Static Constant.

  Constant for the Roman Characters function key.

  type: int"
  KeyEvent/VK_ROMAN_CHARACTERS)

(def *-vk-all-candidates
  "Static Constant.

  Constant for the All Candidates function key.

  type: int"
  KeyEvent/VK_ALL_CANDIDATES)

(def *-vk-previous-candidate
  "Static Constant.

  Constant for the Previous Candidate function key.

  type: int"
  KeyEvent/VK_PREVIOUS_CANDIDATE)

(def *-vk-code-input
  "Static Constant.

  Constant for the Code Input function key.

  type: int"
  KeyEvent/VK_CODE_INPUT)

(def *-vk-japanese-katakana
  "Static Constant.

  Constant for the Japanese-Katakana function key.
   This key switches to a Japanese input method and selects its Katakana input mode.

  type: int"
  KeyEvent/VK_JAPANESE_KATAKANA)

(def *-vk-japanese-hiragana
  "Static Constant.

  Constant for the Japanese-Hiragana function key.
   This key switches to a Japanese input method and selects its Hiragana input mode.

  type: int"
  KeyEvent/VK_JAPANESE_HIRAGANA)

(def *-vk-japanese-roman
  "Static Constant.

  Constant for the Japanese-Roman function key.
   This key switches to a Japanese input method and selects its Roman-Direct input mode.

  type: int"
  KeyEvent/VK_JAPANESE_ROMAN)

(def *-vk-kana-lock
  "Static Constant.

  Constant for the locking Kana function key.
   This key locks the keyboard into a Kana layout.

  type: int"
  KeyEvent/VK_KANA_LOCK)

(def *-vk-input-method-on-off
  "Static Constant.

  Constant for the input method on/off key.

  type: int"
  KeyEvent/VK_INPUT_METHOD_ON_OFF)

(def *-vk-cut
  "Static Constant.

  type: int"
  KeyEvent/VK_CUT)

(def *-vk-copy
  "Static Constant.

  type: int"
  KeyEvent/VK_COPY)

(def *-vk-paste
  "Static Constant.

  type: int"
  KeyEvent/VK_PASTE)

(def *-vk-undo
  "Static Constant.

  type: int"
  KeyEvent/VK_UNDO)

(def *-vk-again
  "Static Constant.

  type: int"
  KeyEvent/VK_AGAIN)

(def *-vk-find
  "Static Constant.

  type: int"
  KeyEvent/VK_FIND)

(def *-vk-props
  "Static Constant.

  type: int"
  KeyEvent/VK_PROPS)

(def *-vk-stop
  "Static Constant.

  type: int"
  KeyEvent/VK_STOP)

(def *-vk-compose
  "Static Constant.

  Constant for the Compose function key.

  type: int"
  KeyEvent/VK_COMPOSE)

(def *-vk-alt-graph
  "Static Constant.

  Constant for the AltGraph function key.

  type: int"
  KeyEvent/VK_ALT_GRAPH)

(def *-vk-begin
  "Static Constant.

  Constant for the Begin key.

  type: int"
  KeyEvent/VK_BEGIN)

(def *-vk-undefined
  "Static Constant.

  This value is used to indicate that the keyCode is unknown.
   KEY_TYPED events do not have a keyCode value; this value
   is used instead.

  type: int"
  KeyEvent/VK_UNDEFINED)

(def *-char-undefined
  "Static Constant.

  KEY_PRESSED and KEY_RELEASED events which do not map to a
   valid Unicode character use this for the keyChar value.

  type: char"
  KeyEvent/CHAR_UNDEFINED)

(def *-key-location-unknown
  "Static Constant.

  A constant indicating that the keyLocation is indeterminate
   or not relevant.
   KEY_TYPED events do not have a keyLocation; this value
   is used instead.

  type: int"
  KeyEvent/KEY_LOCATION_UNKNOWN)

(def *-key-location-standard
  "Static Constant.

  A constant indicating that the key pressed or released
   is not distinguished as the left or right version of a key,
   and did not originate on the numeric keypad (or did not
   originate with a virtual key corresponding to the numeric
   keypad).

  type: int"
  KeyEvent/KEY_LOCATION_STANDARD)

(def *-key-location-left
  "Static Constant.

  A constant indicating that the key pressed or released is in
   the left key location (there is more than one possible location
   for this key).  Example: the left shift key.

  type: int"
  KeyEvent/KEY_LOCATION_LEFT)

(def *-key-location-right
  "Static Constant.

  A constant indicating that the key pressed or released is in
   the right key location (there is more than one possible location
   for this key).  Example: the right shift key.

  type: int"
  KeyEvent/KEY_LOCATION_RIGHT)

(def *-key-location-numpad
  "Static Constant.

  A constant indicating that the key event originated on the
   numeric keypad or with a virtual key corresponding to the
   numeric keypad.

  type: int"
  KeyEvent/KEY_LOCATION_NUMPAD)

(defn *get-key-text
  "Returns a String describing the keyCode, such as `HOME`, `F1` or `A`.
   These strings can be localized by changing the awt.properties file.

  key-code - `int`

  returns: a string containing a text description for a physical key,
           identified by its keyCode - `java.lang.String`"
  ([^Integer key-code]
    (KeyEvent/getKeyText key-code)))

(defn *get-key-modifiers-text
  "Returns a String describing the modifier key(s),
   such as `Shift`, or `Ctrl+Shift`.  These strings can be
   localized by changing the awt.properties file.

   Note that InputEvent.ALT_MASK and
   InputEvent.BUTTON2_MASK have the same value,
   so the string `Alt` is returned for both modifiers.  Likewise,
   InputEvent.META_MASK and
   InputEvent.BUTTON3_MASK have the same value,
   so the string `Meta` is returned for both modifiers.

  modifiers - `int`

  returns: string a text description of the combination of modifier
                  keys that were held down during the event - `java.lang.String`"
  ([^Integer modifiers]
    (KeyEvent/getKeyModifiersText modifiers)))

(defn *get-extended-key-code-for-char
  "Returns an extended key code for a unicode character.

  c - `int`

  returns: for a unicode character with a corresponding VK_ constant -- this
     VK_ constant; for a character appearing on the primary
     level of a known keyboard layout -- a unique integer.
     If a character does not appear on the primary level of a known keyboard,
     VK_UNDEFINED is returned. - `int`"
  ([^Integer c]
    (KeyEvent/getExtendedKeyCodeForChar c)))

(defn set-key-code
  "Set the keyCode value to indicate a physical key.

  key-code - an integer corresponding to an actual key on the keyboard. - `int`"
  ([^java.awt.event.KeyEvent this ^Integer key-code]
    (-> this (.setKeyCode key-code))))

(defn get-key-location
  "Returns the location of the key that originated this key event.

   Some keys occur more than once on a keyboard, e.g. the left and
   right shift keys.  Additionally, some keys occur on the numeric
   keypad.  This provides a way of distinguishing such keys.

  returns: the location of the key that was pressed or released.
           Always returns KEY_LOCATION_UNKNOWN for
           KEY_TYPED events. - `int`"
  ([^java.awt.event.KeyEvent this]
    (-> this (.getKeyLocation))))

(defn get-key-char
  "Returns the character associated with the key in this event.
   For example, the KEY_TYPED event for shift  `a`
   returns the value for `A`.

   KEY_PRESSED and KEY_RELEASED events
   are not intended for reporting of character input.  Therefore,
   the values returned by this method are guaranteed to be
   meaningful only for KEY_TYPED events.

  returns: the Unicode character defined for this key event.
           If no valid Unicode character exists for this key event,
           CHAR_UNDEFINED is returned. - `char`"
  ([^java.awt.event.KeyEvent this]
    (-> this (.getKeyChar))))

(defn get-extended-key-code
  "Returns an extended key code for the event.
   The extended key code is a unique id assigned to  a key on the keyboard
   just like keyCode. However, unlike keyCode, this value depends on the
   current keyboard layout. For instance, pressing the left topmost letter key
   in a common English layout produces the same value as keyCode, VK_Q.
   Pressing the same key in a regular Russian layout gives another code, unique for the
   letter `Cyrillic I short`.

  returns: `int`"
  ([^java.awt.event.KeyEvent this]
    (-> this (.getExtendedKeyCode))))

(defn set-key-char
  "Set the keyChar value to indicate a logical character.

  key-char - a char corresponding to to the combination of keystrokes that make up this event. - `char`"
  ([^java.awt.event.KeyEvent this ^Character key-char]
    (-> this (.setKeyChar key-char))))

(defn get-key-code
  "Returns the integer keyCode associated with the key in this event.

  returns: the integer code for an actual key on the keyboard.
           (For KEY_TYPED events, the keyCode is
           VK_UNDEFINED.) - `int`"
  ([^java.awt.event.KeyEvent this]
    (-> this (.getKeyCode))))

(defn set-modifiers
  "Deprecated. as of JDK1.1.4

  modifiers - an integer combination of the modifier constants. - `int`

  returns: `java.lang.  void`"
  ([^java.awt.event.KeyEvent this ^Integer modifiers]
    (-> this (.setModifiers modifiers))))

(defn param-string
  "Returns a parameter string identifying this event.
   This method is useful for event logging and for debugging.

  returns: a string identifying the event and its attributes - `java.lang.String`"
  ([^java.awt.event.KeyEvent this]
    (-> this (.paramString))))

(defn action-key?
  "Returns whether the key in this event is an `action` key.
   Typically an action key does not fire a unicode character and is
   not a modifier key.

  returns: true if the key is an `action` key,
           false otherwise - `boolean`"
  ([^java.awt.event.KeyEvent this]
    (-> this (.isActionKey))))

