(ns jdk.awt.event.ActionEvent
  "A semantic event which indicates that a component-defined action occurred.
  This high-level event is generated by a component (such as a
  Button) when
  the component-specific action occurs (such as being pressed).
  The event is passed to every ActionListener object
  that registered to receive such events using the component's
  addActionListener method.

  Note: To invoke an ActionEvent on a
  Button using the keyboard, use the Space bar.

  The object that implements the ActionListener interface
  gets this ActionEvent when the event occurs. The listener
  is therefore spared the details of processing individual mouse movements
  and mouse clicks, and can instead process a `meaningful` (semantic)
  event like `button pressed`.

  An unspecified behavior will be caused if the id parameter
  of any particular ActionEvent instance is not
  in the range from ACTION_FIRST to ACTION_LAST."
  (:refer-clojure :only [require comment defn ->])
  (:import [java.awt.event ActionEvent]))

(defn ->action-event
  "Constructor.

  Constructs an ActionEvent object with the specified
   modifier keys and timestamp.

   This method throws an
   IllegalArgumentException if source
   is null.
   A null command string is legal,
   but not recommended.

  source - The object that originated the event - `java.lang.Object`
  id - An integer that identifies the event. For information on allowable values, see the class description for ActionEvent - `int`
  command - A string that may specify a command (possibly one of several) associated with the event - `java.lang.String`
  when - A long that gives the time the event occurred. Passing negative or zero value is not recommended - `long`
  modifiers - The modifier keys down during event (shift, ctrl, alt, meta). Passing negative parameter is not recommended. Zero value means that no modifiers were passed - `int`

  throws: java.lang.IllegalArgumentException - if source is null"
  ([source id command when modifiers]
    (new ActionEvent source id command when modifiers))
  ([source id command modifiers]
    (new ActionEvent source id command modifiers))
  ([source id command]
    (new ActionEvent source id command)))

(def *-shift-mask
  "Static Constant.

  The shift modifier. An indicator that the shift key was held
   down during the event.

  type: int"
  ActionEvent/SHIFT_MASK)

(def *-ctrl-mask
  "Static Constant.

  The control modifier. An indicator that the control key was held
   down during the event.

  type: int"
  ActionEvent/CTRL_MASK)

(def *-meta-mask
  "Static Constant.

  The meta modifier. An indicator that the meta key was held
   down during the event.

  type: int"
  ActionEvent/META_MASK)

(def *-alt-mask
  "Static Constant.

  The alt modifier. An indicator that the alt key was held
   down during the event.

  type: int"
  ActionEvent/ALT_MASK)

(def *-action-first
  "Static Constant.

  The first number in the range of ids used for action events.

  type: int"
  ActionEvent/ACTION_FIRST)

(def *-action-last
  "Static Constant.

  The last number in the range of ids used for action events.

  type: int"
  ActionEvent/ACTION_LAST)

(def *-action-performed
  "Static Constant.

  This event id indicates that a meaningful action occurred.

  type: java.lang.annotation.    int"
  ActionEvent/ACTION_PERFORMED)

(defn get-action-command
  "Returns the command string associated with this action.
   This string allows a `modal` component to specify one of several
   commands, depending on its state. For example, a single button might
   toggle between `show details` and `hide details`. The source object
   and the event would be the same in each case, but the command string
   would identify the intended action.

   Note that if a null command string was passed
   to the constructor for this ActionEvent, this
   this method returns null.

  returns: the string identifying the command for this event - `java.lang.String`"
  ([this]
    (-> this (.getActionCommand))))

(defn get-when
  "Returns the timestamp of when this event occurred. Because an
   ActionEvent is a high-level, semantic event, the timestamp is typically
   the same as an underlying InputEvent.

  returns: this event's timestamp - `long`"
  ([this]
    (-> this (.getWhen))))

(defn get-modifiers
  "Returns the modifier keys held down during this action event.

  returns: the bitwise-or of the modifier constants - `int`"
  ([this]
    (-> this (.getModifiers))))

(defn param-string
  "Returns a parameter string identifying this action event.
   This method is useful for event-logging and for debugging.

  returns: a string identifying the event and its associated command - `java.lang.String`"
  ([this]
    (-> this (.paramString))))

