(ns com.google.cloud.compute.v1.Tags$Builder
  (:refer-clojure :only [require comment defn ->])
  (:import [com.google.cloud.compute.v1 Tags$Builder]))

(defn merge-from
  "other - `com.google.cloud.compute.v1.Tags`

  returns: `com.google.cloud.compute.v1.Tags$Builder`"
  (^com.google.cloud.compute.v1.Tags$Builder [^Tags$Builder this ^com.google.cloud.compute.v1.Tags other]
    (-> this (.mergeFrom other))))

(defn get-fingerprint
  "Specifies a fingerprint for this request, which is essentially a hash of the tags' contents
   and used for optimistic locking. The fingerprint is initially generated by Compute Engine and
   changes after every request to modify or update tags. You must always provide an up-to-date
   fingerprint hash in order to update or change tags.

   To see the latest fingerprint, make get() request to the instance.

  returns: `java.lang.String`"
  (^java.lang.String [^Tags$Builder this]
    (-> this (.getFingerprint))))

(defn set-fingerprint
  "Specifies a fingerprint for this request, which is essentially a hash of the tags' contents
   and used for optimistic locking. The fingerprint is initially generated by Compute Engine and
   changes after every request to modify or update tags. You must always provide an up-to-date
   fingerprint hash in order to update or change tags.

   To see the latest fingerprint, make get() request to the instance.

  fingerprint - `java.lang.String`

  returns: `com.google.cloud.compute.v1.Tags$Builder`"
  (^com.google.cloud.compute.v1.Tags$Builder [^Tags$Builder this ^java.lang.String fingerprint]
    (-> this (.setFingerprint fingerprint))))

(defn get-items-list
  "An array of tags. Each tag must be 1-63 characters long, and comply with RFC1035.

  returns: `java.util.List<java.lang.String>`"
  (^java.util.List [^Tags$Builder this]
    (-> this (.getItemsList))))

(defn add-all-items
  "An array of tags. Each tag must be 1-63 characters long, and comply with RFC1035.

  items - `java.util.List`

  returns: `com.google.cloud.compute.v1.Tags$Builder`"
  (^com.google.cloud.compute.v1.Tags$Builder [^Tags$Builder this ^java.util.List items]
    (-> this (.addAllItems items))))

(defn add-items
  "An array of tags. Each tag must be 1-63 characters long, and comply with RFC1035.

  items - `java.lang.String`

  returns: `com.google.cloud.compute.v1.Tags$Builder`"
  (^com.google.cloud.compute.v1.Tags$Builder [^Tags$Builder this ^java.lang.String items]
    (-> this (.addItems items))))

(defn build
  "returns: `com.google.cloud.compute.v1.Tags`"
  (^com.google.cloud.compute.v1.Tags [^Tags$Builder this]
    (-> this (.build))))

(defn clone
  "returns: `com.google.cloud.compute.v1.Tags$Builder`"
  (^com.google.cloud.compute.v1.Tags$Builder [^Tags$Builder this]
    (-> this (.clone))))

