(ns com.google.cloud.compute.v1.NetworkInterface
  (:refer-clojure :only [require comment defn ->])
  (:import [com.google.cloud.compute.v1 NetworkInterface]))

(defn *new-builder
  "prototype - `com.google.cloud.compute.v1.NetworkInterface`

  returns: `com.google.cloud.compute.v1.NetworkInterface$Builder`"
  (^com.google.cloud.compute.v1.NetworkInterface$Builder [^com.google.cloud.compute.v1.NetworkInterface prototype]
    (NetworkInterface/newBuilder prototype))
  (^com.google.cloud.compute.v1.NetworkInterface$Builder []
    (NetworkInterface/newBuilder )))

(defn *get-default-instance
  "returns: `com.google.cloud.compute.v1.NetworkInterface`"
  (^com.google.cloud.compute.v1.NetworkInterface []
    (NetworkInterface/getDefaultInstance )))

(defn get-subnetwork
  "The URL of the Subnetwork resource for this instance. If the network resource is in legacy
   mode, do not provide this property. If the network is in auto subnet mode, providing the
   subnetwork is optional. If the network is in custom subnet mode, then this field should be
   specified. If you specify this property, you can specify the subnetwork as a full or partial
   URL. For example, the following are all valid URLs: -
   https://www.googleapis.com/compute/v1/projects/project/regions/region/subnetworks/subnetwork -
   regions/region/subnetworks/subnetwork

  returns: `java.lang.String`"
  (^java.lang.String [^NetworkInterface this]
    (-> this (.getSubnetwork))))

(defn get-network-ip
  "An IPv4 internal network address to assign to the instance for this network interface. If not
   specified by the user, an unused internal IP is assigned by the system.

  returns: `java.lang.String`"
  (^java.lang.String [^NetworkInterface this]
    (-> this (.getNetworkIP))))

(defn get-kind
  "[Output Only] Type of the resource. Always compute#networkInterface for network interfaces.

  returns: `java.lang.String`"
  (^java.lang.String [^NetworkInterface this]
    (-> this (.getKind))))

(defn get-fingerprint
  "Fingerprint hash of contents stored in this network interface. This field will be ignored when
   inserting an Instance or adding a NetworkInterface. An up-to-date fingerprint must be provided
   in order to update the NetworkInterface, otherwise the request will fail with error 412
   conditionNotMet.

  returns: `java.lang.String`"
  (^java.lang.String [^NetworkInterface this]
    (-> this (.getFingerprint))))

(defn get-field-mask
  "returns: `java.util.List<java.lang.String>`"
  (^java.util.List [^NetworkInterface this]
    (-> this (.getFieldMask))))

(defn to-string
  "returns: `java.lang.String`"
  (^java.lang.String [^NetworkInterface this]
    (-> this (.toString))))

(defn get-field-value
  "field-name - `java.lang.String`

  returns: `java.lang.Object`"
  (^java.lang.Object [^NetworkInterface this ^java.lang.String field-name]
    (-> this (.getFieldValue field-name))))

(defn get-name
  "[Output Only] The name of the network interface, generated by the server. For network devices,
   these are eth0, eth1, etc.

  returns: `java.lang.String`"
  (^java.lang.String [^NetworkInterface this]
    (-> this (.getName))))

(defn get-alias-ip-ranges-list
  "An array of alias IP ranges for this network interface. Can only be specified for network
   interfaces on subnet-mode networks.

  returns: `java.util.List<com.google.cloud.compute.v1.AliasIpRange>`"
  (^java.util.List [^NetworkInterface this]
    (-> this (.getAliasIpRangesList))))

(defn get-access-configs-list
  "An array of configurations for this interface. Currently, only one access config,
   ONE_TO_ONE_NAT, is supported. If there are no accessConfigs specified, then this instance will
   have no external internet access.

  returns: `java.util.List<com.google.cloud.compute.v1.AccessConfig>`"
  (^java.util.List [^NetworkInterface this]
    (-> this (.getAccessConfigsList))))

(defn get-api-message-request-body
  "returns: `com.google.api.gax.httpjson.ApiMessage`"
  (^com.google.api.gax.httpjson.ApiMessage [^NetworkInterface this]
    (-> this (.getApiMessageRequestBody))))

(defn get-network
  "URL of the network resource for this instance. When creating an instance, if neither the
   network nor the subnetwork is specified, the default network global/networks/default is used;
   if the network is not specified but the subnetwork is specified, the network is inferred.

   This field is optional when creating a firewall rule. If not specified when creating a
   firewall rule, the default network global/networks/default is used.

   If you specify this property, you can specify the network as a full or partial URL. For
   example, the following are all valid URLs: -
   https://www.googleapis.com/compute/v1/projects/project/global/networks/network -
   projects/project/global/networks/network - global/networks/default

  returns: `java.lang.String`"
  (^java.lang.String [^NetworkInterface this]
    (-> this (.getNetwork))))

(defn hash-code
  "returns: `int`"
  (^Integer [^NetworkInterface this]
    (-> this (.hashCode))))

(defn equals
  "o - `java.lang.Object`

  returns: `boolean`"
  (^Boolean [^NetworkInterface this ^java.lang.Object o]
    (-> this (.equals o))))

(defn to-builder
  "returns: `com.google.cloud.compute.v1.NetworkInterface$Builder`"
  (^com.google.cloud.compute.v1.NetworkInterface$Builder [^NetworkInterface this]
    (-> this (.toBuilder))))

