(ns com.google.cloud.compute.v1.NetworkInterface$Builder
  (:refer-clojure :only [require comment defn ->])
  (:import [com.google.cloud.compute.v1 NetworkInterface$Builder]))

(defn get-subnetwork
  "The URL of the Subnetwork resource for this instance. If the network resource is in legacy
   mode, do not provide this property. If the network is in auto subnet mode, providing the
   subnetwork is optional. If the network is in custom subnet mode, then this field should be
   specified. If you specify this property, you can specify the subnetwork as a full or partial
   URL. For example, the following are all valid URLs: -
   https://www.googleapis.com/compute/v1/projects/project/regions/region/subnetworks/subnetwork
   - regions/region/subnetworks/subnetwork

  returns: `java.lang.String`"
  (^java.lang.String [^NetworkInterface$Builder this]
    (-> this (.getSubnetwork))))

(defn get-network-ip
  "An IPv4 internal network address to assign to the instance for this network interface. If not
   specified by the user, an unused internal IP is assigned by the system.

  returns: `java.lang.String`"
  (^java.lang.String [^NetworkInterface$Builder this]
    (-> this (.getNetworkIP))))

(defn set-network-ip
  "An IPv4 internal network address to assign to the instance for this network interface. If not
   specified by the user, an unused internal IP is assigned by the system.

  network-ip - `java.lang.String`

  returns: `com.google.cloud.compute.v1.NetworkInterface$Builder`"
  (^com.google.cloud.compute.v1.NetworkInterface$Builder [^NetworkInterface$Builder this ^java.lang.String network-ip]
    (-> this (.setNetworkIP network-ip))))

(defn get-kind
  "[Output Only] Type of the resource. Always compute#networkInterface for network interfaces.

  returns: `java.lang.String`"
  (^java.lang.String [^NetworkInterface$Builder this]
    (-> this (.getKind))))

(defn add-alias-ip-ranges
  "An array of alias IP ranges for this network interface. Can only be specified for network
   interfaces on subnet-mode networks.

  alias-ip-ranges - `com.google.cloud.compute.v1.AliasIpRange`

  returns: `com.google.cloud.compute.v1.NetworkInterface$Builder`"
  (^com.google.cloud.compute.v1.NetworkInterface$Builder [^NetworkInterface$Builder this ^com.google.cloud.compute.v1.AliasIpRange alias-ip-ranges]
    (-> this (.addAliasIpRanges alias-ip-ranges))))

(defn set-fingerprint
  "Fingerprint hash of contents stored in this network interface. This field will be ignored
   when inserting an Instance or adding a NetworkInterface. An up-to-date fingerprint must be
   provided in order to update the NetworkInterface, otherwise the request will fail with error
   412 conditionNotMet.

  fingerprint - `java.lang.String`

  returns: `com.google.cloud.compute.v1.NetworkInterface$Builder`"
  (^com.google.cloud.compute.v1.NetworkInterface$Builder [^NetworkInterface$Builder this ^java.lang.String fingerprint]
    (-> this (.setFingerprint fingerprint))))

(defn set-network
  "URL of the network resource for this instance. When creating an instance, if neither the
   network nor the subnetwork is specified, the default network global/networks/default is used;
   if the network is not specified but the subnetwork is specified, the network is inferred.

   This field is optional when creating a firewall rule. If not specified when creating a
   firewall rule, the default network global/networks/default is used.

   If you specify this property, you can specify the network as a full or partial URL. For
   example, the following are all valid URLs: -
   https://www.googleapis.com/compute/v1/projects/project/global/networks/network -
   projects/project/global/networks/network - global/networks/default

  network - `java.lang.String`

  returns: `com.google.cloud.compute.v1.NetworkInterface$Builder`"
  (^com.google.cloud.compute.v1.NetworkInterface$Builder [^NetworkInterface$Builder this ^java.lang.String network]
    (-> this (.setNetwork network))))

(defn get-fingerprint
  "Fingerprint hash of contents stored in this network interface. This field will be ignored
   when inserting an Instance or adding a NetworkInterface. An up-to-date fingerprint must be
   provided in order to update the NetworkInterface, otherwise the request will fail with error
   412 conditionNotMet.

  returns: `java.lang.String`"
  (^java.lang.String [^NetworkInterface$Builder this]
    (-> this (.getFingerprint))))

(defn set-name
  "[Output Only] The name of the network interface, generated by the server. For network
   devices, these are eth0, eth1, etc.

  name - `java.lang.String`

  returns: `com.google.cloud.compute.v1.NetworkInterface$Builder`"
  (^com.google.cloud.compute.v1.NetworkInterface$Builder [^NetworkInterface$Builder this ^java.lang.String name]
    (-> this (.setName name))))

(defn set-kind
  "[Output Only] Type of the resource. Always compute#networkInterface for network interfaces.

  kind - `java.lang.String`

  returns: `com.google.cloud.compute.v1.NetworkInterface$Builder`"
  (^com.google.cloud.compute.v1.NetworkInterface$Builder [^NetworkInterface$Builder this ^java.lang.String kind]
    (-> this (.setKind kind))))

(defn get-name
  "[Output Only] The name of the network interface, generated by the server. For network
   devices, these are eth0, eth1, etc.

  returns: `java.lang.String`"
  (^java.lang.String [^NetworkInterface$Builder this]
    (-> this (.getName))))

(defn get-alias-ip-ranges-list
  "An array of alias IP ranges for this network interface. Can only be specified for network
   interfaces on subnet-mode networks.

  returns: `java.util.List<com.google.cloud.compute.v1.AliasIpRange>`"
  (^java.util.List [^NetworkInterface$Builder this]
    (-> this (.getAliasIpRangesList))))

(defn build
  "returns: `com.google.cloud.compute.v1.NetworkInterface`"
  (^com.google.cloud.compute.v1.NetworkInterface [^NetworkInterface$Builder this]
    (-> this (.build))))

(defn add-all-alias-ip-ranges
  "An array of alias IP ranges for this network interface. Can only be specified for network
   interfaces on subnet-mode networks.

  alias-ip-ranges - `java.util.List`

  returns: `com.google.cloud.compute.v1.NetworkInterface$Builder`"
  (^com.google.cloud.compute.v1.NetworkInterface$Builder [^NetworkInterface$Builder this ^java.util.List alias-ip-ranges]
    (-> this (.addAllAliasIpRanges alias-ip-ranges))))

(defn get-access-configs-list
  "An array of configurations for this interface. Currently, only one access config,
   ONE_TO_ONE_NAT, is supported. If there are no accessConfigs specified, then this instance
   will have no external internet access.

  returns: `java.util.List<com.google.cloud.compute.v1.AccessConfig>`"
  (^java.util.List [^NetworkInterface$Builder this]
    (-> this (.getAccessConfigsList))))

(defn add-all-access-configs
  "An array of configurations for this interface. Currently, only one access config,
   ONE_TO_ONE_NAT, is supported. If there are no accessConfigs specified, then this instance
   will have no external internet access.

  access-configs - `java.util.List`

  returns: `com.google.cloud.compute.v1.NetworkInterface$Builder`"
  (^com.google.cloud.compute.v1.NetworkInterface$Builder [^NetworkInterface$Builder this ^java.util.List access-configs]
    (-> this (.addAllAccessConfigs access-configs))))

(defn merge-from
  "other - `com.google.cloud.compute.v1.NetworkInterface`

  returns: `com.google.cloud.compute.v1.NetworkInterface$Builder`"
  (^com.google.cloud.compute.v1.NetworkInterface$Builder [^NetworkInterface$Builder this ^com.google.cloud.compute.v1.NetworkInterface other]
    (-> this (.mergeFrom other))))

(defn add-access-configs
  "An array of configurations for this interface. Currently, only one access config,
   ONE_TO_ONE_NAT, is supported. If there are no accessConfigs specified, then this instance
   will have no external internet access.

  access-configs - `com.google.cloud.compute.v1.AccessConfig`

  returns: `com.google.cloud.compute.v1.NetworkInterface$Builder`"
  (^com.google.cloud.compute.v1.NetworkInterface$Builder [^NetworkInterface$Builder this ^com.google.cloud.compute.v1.AccessConfig access-configs]
    (-> this (.addAccessConfigs access-configs))))

(defn get-network
  "URL of the network resource for this instance. When creating an instance, if neither the
   network nor the subnetwork is specified, the default network global/networks/default is used;
   if the network is not specified but the subnetwork is specified, the network is inferred.

   This field is optional when creating a firewall rule. If not specified when creating a
   firewall rule, the default network global/networks/default is used.

   If you specify this property, you can specify the network as a full or partial URL. For
   example, the following are all valid URLs: -
   https://www.googleapis.com/compute/v1/projects/project/global/networks/network -
   projects/project/global/networks/network - global/networks/default

  returns: `java.lang.String`"
  (^java.lang.String [^NetworkInterface$Builder this]
    (-> this (.getNetwork))))

(defn clone
  "returns: `com.google.cloud.compute.v1.NetworkInterface$Builder`"
  (^com.google.cloud.compute.v1.NetworkInterface$Builder [^NetworkInterface$Builder this]
    (-> this (.clone))))

(defn set-subnetwork
  "The URL of the Subnetwork resource for this instance. If the network resource is in legacy
   mode, do not provide this property. If the network is in auto subnet mode, providing the
   subnetwork is optional. If the network is in custom subnet mode, then this field should be
   specified. If you specify this property, you can specify the subnetwork as a full or partial
   URL. For example, the following are all valid URLs: -
   https://www.googleapis.com/compute/v1/projects/project/regions/region/subnetworks/subnetwork
   - regions/region/subnetworks/subnetwork

  subnetwork - `java.lang.String`

  returns: `com.google.cloud.compute.v1.NetworkInterface$Builder`"
  (^com.google.cloud.compute.v1.NetworkInterface$Builder [^NetworkInterface$Builder this ^java.lang.String subnetwork]
    (-> this (.setSubnetwork subnetwork))))

