(ns com.google.cloud.compute.v1.InterconnectOutageNotification
  (:refer-clojure :only [require comment defn ->])
  (:import [com.google.cloud.compute.v1 InterconnectOutageNotification]))

(defn *new-builder
  "prototype - `com.google.cloud.compute.v1.InterconnectOutageNotification`

  returns: `com.google.cloud.compute.v1.InterconnectOutageNotification$Builder`"
  (^com.google.cloud.compute.v1.InterconnectOutageNotification$Builder [^com.google.cloud.compute.v1.InterconnectOutageNotification prototype]
    (InterconnectOutageNotification/newBuilder prototype))
  (^com.google.cloud.compute.v1.InterconnectOutageNotification$Builder []
    (InterconnectOutageNotification/newBuilder )))

(defn *get-default-instance
  "returns: `com.google.cloud.compute.v1.InterconnectOutageNotification`"
  (^com.google.cloud.compute.v1.InterconnectOutageNotification []
    (InterconnectOutageNotification/getDefaultInstance )))

(defn get-start-time
  "Scheduled start time for the outage (milliseconds since Unix epoch).

  returns: `java.lang.String`"
  (^java.lang.String [^InterconnectOutageNotification this]
    (-> this (.getStartTime))))

(defn get-affected-circuits-list
  "If issue_type is IT_PARTIAL_OUTAGE, a list of the Google-side circuit IDs that will be
   affected.

  returns: `java.util.List<java.lang.String>`"
  (^java.util.List [^InterconnectOutageNotification this]
    (-> this (.getAffectedCircuitsList))))

(defn get-field-mask
  "returns: `java.util.List<java.lang.String>`"
  (^java.util.List [^InterconnectOutageNotification this]
    (-> this (.getFieldMask))))

(defn to-string
  "returns: `java.lang.String`"
  (^java.lang.String [^InterconnectOutageNotification this]
    (-> this (.toString))))

(defn get-field-value
  "field-name - `java.lang.String`

  returns: `java.lang.Object`"
  (^java.lang.Object [^InterconnectOutageNotification this ^java.lang.String field-name]
    (-> this (.getFieldValue field-name))))

(defn get-name
  "Unique identifier for this outage notification.

  returns: `java.lang.String`"
  (^java.lang.String [^InterconnectOutageNotification this]
    (-> this (.getName))))

(defn get-state
  "State of this notification, which can take one of the following values: - ACTIVE: This outage
   notification is active. The event could be in the past, present, or future. See start_time and
   end_time for scheduling. - CANCELLED: The outage associated with this notification was
   cancelled before the outage was due to start. Note that the versions of this enum prefixed with
   \"NS_\" have been deprecated in favor of the unprefixed values.

  returns: `java.lang.String`"
  (^java.lang.String [^InterconnectOutageNotification this]
    (-> this (.getState))))

(defn get-source
  "The party that generated this notification, which can take the following value: - GOOGLE: this
   notification as generated by Google. Note that the value of NSRC_GOOGLE has been deprecated in
   favor of GOOGLE.

  returns: `java.lang.String`"
  (^java.lang.String [^InterconnectOutageNotification this]
    (-> this (.getSource))))

(defn get-description
  "A description about the purpose of the outage.

  returns: `java.lang.String`"
  (^java.lang.String [^InterconnectOutageNotification this]
    (-> this (.getDescription))))

(defn get-api-message-request-body
  "returns: `com.google.api.gax.httpjson.ApiMessage`"
  (^com.google.api.gax.httpjson.ApiMessage [^InterconnectOutageNotification this]
    (-> this (.getApiMessageRequestBody))))

(defn get-end-time
  "Scheduled end time for the outage (milliseconds since Unix epoch).

  returns: `java.lang.String`"
  (^java.lang.String [^InterconnectOutageNotification this]
    (-> this (.getEndTime))))

(defn hash-code
  "returns: `int`"
  (^Integer [^InterconnectOutageNotification this]
    (-> this (.hashCode))))

(defn get-issue-type
  "Form this outage is expected to take, which can take one of the following values: - OUTAGE: The
   Interconnect may be completely out of service for some or all of the specified window. -
   PARTIAL_OUTAGE: Some circuits comprising the Interconnect as a whole should remain up, but with
   reduced bandwidth. Note that the versions of this enum prefixed with \"IT_\" have been deprecated
   in favor of the unprefixed values.

  returns: `java.lang.String`"
  (^java.lang.String [^InterconnectOutageNotification this]
    (-> this (.getIssueType))))

(defn equals
  "o - `java.lang.Object`

  returns: `boolean`"
  (^Boolean [^InterconnectOutageNotification this ^java.lang.Object o]
    (-> this (.equals o))))

(defn to-builder
  "returns: `com.google.cloud.compute.v1.InterconnectOutageNotification$Builder`"
  (^com.google.cloud.compute.v1.InterconnectOutageNotification$Builder [^InterconnectOutageNotification this]
    (-> this (.toBuilder))))

