(ns com.google.cloud.compute.v1.InstanceGroup$Builder
  (:refer-clojure :only [require comment defn ->])
  (:import [com.google.cloud.compute.v1 InstanceGroup$Builder]))

(defn set-description
  "An optional description of this resource. Provide this property when you create the resource.

  description - `java.lang.String`

  returns: `com.google.cloud.compute.v1.InstanceGroup$Builder`"
  (^com.google.cloud.compute.v1.InstanceGroup$Builder [^InstanceGroup$Builder this ^java.lang.String description]
    (-> this (.setDescription description))))

(defn get-subnetwork
  "[Output Only] The URL of the subnetwork to which all instances in the instance group belong.

  returns: `java.lang.String`"
  (^java.lang.String [^InstanceGroup$Builder this]
    (-> this (.getSubnetwork))))

(defn set-region
  "[Output Only] The URL of the region where the instance group is located (for regional
   resources).

  region - `java.lang.String`

  returns: `com.google.cloud.compute.v1.InstanceGroup$Builder`"
  (^com.google.cloud.compute.v1.InstanceGroup$Builder [^InstanceGroup$Builder this ^java.lang.String region]
    (-> this (.setRegion region))))

(defn set-creation-timestamp
  "[Output Only] The creation timestamp for this instance group in RFC3339 text format.

  creation-timestamp - `java.lang.String`

  returns: `com.google.cloud.compute.v1.InstanceGroup$Builder`"
  (^com.google.cloud.compute.v1.InstanceGroup$Builder [^InstanceGroup$Builder this ^java.lang.String creation-timestamp]
    (-> this (.setCreationTimestamp creation-timestamp))))

(defn get-kind
  "[Output Only] The resource type, which is always compute#instanceGroup for instance groups.

  returns: `java.lang.String`"
  (^java.lang.String [^InstanceGroup$Builder this]
    (-> this (.getKind))))

(defn set-fingerprint
  "[Output Only] The fingerprint of the named ports. The system uses this fingerprint to detect
   conflicts when multiple users change the named ports concurrently.

  fingerprint - `java.lang.String`

  returns: `com.google.cloud.compute.v1.InstanceGroup$Builder`"
  (^com.google.cloud.compute.v1.InstanceGroup$Builder [^InstanceGroup$Builder this ^java.lang.String fingerprint]
    (-> this (.setFingerprint fingerprint))))

(defn set-network
  "The URL of the network to which all instances in the instance group belong.

  network - `java.lang.String`

  returns: `com.google.cloud.compute.v1.InstanceGroup$Builder`"
  (^com.google.cloud.compute.v1.InstanceGroup$Builder [^InstanceGroup$Builder this ^java.lang.String network]
    (-> this (.setNetwork network))))

(defn get-fingerprint
  "[Output Only] The fingerprint of the named ports. The system uses this fingerprint to detect
   conflicts when multiple users change the named ports concurrently.

  returns: `java.lang.String`"
  (^java.lang.String [^InstanceGroup$Builder this]
    (-> this (.getFingerprint))))

(defn set-name
  "The name of the instance group. The name must be 1-63 characters long, and comply with
   RFC1035.

  name - `java.lang.String`

  returns: `com.google.cloud.compute.v1.InstanceGroup$Builder`"
  (^com.google.cloud.compute.v1.InstanceGroup$Builder [^InstanceGroup$Builder this ^java.lang.String name]
    (-> this (.setName name))))

(defn set-kind
  "[Output Only] The resource type, which is always compute#instanceGroup for instance groups.

  kind - `java.lang.String`

  returns: `com.google.cloud.compute.v1.InstanceGroup$Builder`"
  (^com.google.cloud.compute.v1.InstanceGroup$Builder [^InstanceGroup$Builder this ^java.lang.String kind]
    (-> this (.setKind kind))))

(defn get-name
  "The name of the instance group. The name must be 1-63 characters long, and comply with
   RFC1035.

  returns: `java.lang.String`"
  (^java.lang.String [^InstanceGroup$Builder this]
    (-> this (.getName))))

(defn set-id
  "[Output Only] A unique identifier for this instance group, generated by the server.

  id - `java.lang.String`

  returns: `com.google.cloud.compute.v1.InstanceGroup$Builder`"
  (^com.google.cloud.compute.v1.InstanceGroup$Builder [^InstanceGroup$Builder this ^java.lang.String id]
    (-> this (.setId id))))

(defn get-named-ports-list
  "Assigns a name to a port number. For example: {name: \"http\", port: 80}

   This allows the system to reference ports by the assigned name instead of a port number.
   Named ports can also contain multiple ports. For example: [{name: \"http\", port: 80},{name:
   \"http\", port: 8080}]

   Named ports apply to all instances in this instance group.

  returns: `java.util.List<com.google.cloud.compute.v1.NamedPort>`"
  (^java.util.List [^InstanceGroup$Builder this]
    (-> this (.getNamedPortsList))))

(defn build
  "returns: `com.google.cloud.compute.v1.InstanceGroup`"
  (^com.google.cloud.compute.v1.InstanceGroup [^InstanceGroup$Builder this]
    (-> this (.build))))

(defn get-description
  "An optional description of this resource. Provide this property when you create the resource.

  returns: `java.lang.String`"
  (^java.lang.String [^InstanceGroup$Builder this]
    (-> this (.getDescription))))

(defn get-id
  "[Output Only] A unique identifier for this instance group, generated by the server.

  returns: `java.lang.String`"
  (^java.lang.String [^InstanceGroup$Builder this]
    (-> this (.getId))))

(defn set-self-link
  "[Output Only] The URL for this instance group. The server generates this URL.

  self-link - `java.lang.String`

  returns: `com.google.cloud.compute.v1.InstanceGroup$Builder`"
  (^com.google.cloud.compute.v1.InstanceGroup$Builder [^InstanceGroup$Builder this ^java.lang.String self-link]
    (-> this (.setSelfLink self-link))))

(defn merge-from
  "other - `com.google.cloud.compute.v1.InstanceGroup`

  returns: `com.google.cloud.compute.v1.InstanceGroup$Builder`"
  (^com.google.cloud.compute.v1.InstanceGroup$Builder [^InstanceGroup$Builder this ^com.google.cloud.compute.v1.InstanceGroup other]
    (-> this (.mergeFrom other))))

(defn set-zone
  "[Output Only] The URL of the zone where the instance group is located (for zonal resources).

  zone - `java.lang.String`

  returns: `com.google.cloud.compute.v1.InstanceGroup$Builder`"
  (^com.google.cloud.compute.v1.InstanceGroup$Builder [^InstanceGroup$Builder this ^java.lang.String zone]
    (-> this (.setZone zone))))

(defn get-self-link
  "[Output Only] The URL for this instance group. The server generates this URL.

  returns: `java.lang.String`"
  (^java.lang.String [^InstanceGroup$Builder this]
    (-> this (.getSelfLink))))

(defn get-zone
  "[Output Only] The URL of the zone where the instance group is located (for zonal resources).

  returns: `java.lang.String`"
  (^java.lang.String [^InstanceGroup$Builder this]
    (-> this (.getZone))))

(defn set-size
  "[Output Only] The total number of instances in the instance group.

  size - `java.lang.Integer`

  returns: `com.google.cloud.compute.v1.InstanceGroup$Builder`"
  (^com.google.cloud.compute.v1.InstanceGroup$Builder [^InstanceGroup$Builder this ^java.lang.Integer size]
    (-> this (.setSize size))))

(defn get-network
  "The URL of the network to which all instances in the instance group belong.

  returns: `java.lang.String`"
  (^java.lang.String [^InstanceGroup$Builder this]
    (-> this (.getNetwork))))

(defn clone
  "returns: `com.google.cloud.compute.v1.InstanceGroup$Builder`"
  (^com.google.cloud.compute.v1.InstanceGroup$Builder [^InstanceGroup$Builder this]
    (-> this (.clone))))

(defn get-creation-timestamp
  "[Output Only] The creation timestamp for this instance group in RFC3339 text format.

  returns: `java.lang.String`"
  (^java.lang.String [^InstanceGroup$Builder this]
    (-> this (.getCreationTimestamp))))

(defn add-named-ports
  "Assigns a name to a port number. For example: {name: \"http\", port: 80}

   This allows the system to reference ports by the assigned name instead of a port number.
   Named ports can also contain multiple ports. For example: [{name: \"http\", port: 80},{name:
   \"http\", port: 8080}]

   Named ports apply to all instances in this instance group.

  named-ports - `com.google.cloud.compute.v1.NamedPort`

  returns: `com.google.cloud.compute.v1.InstanceGroup$Builder`"
  (^com.google.cloud.compute.v1.InstanceGroup$Builder [^InstanceGroup$Builder this ^com.google.cloud.compute.v1.NamedPort named-ports]
    (-> this (.addNamedPorts named-ports))))

(defn get-size
  "[Output Only] The total number of instances in the instance group.

  returns: `java.lang.Integer`"
  (^java.lang.Integer [^InstanceGroup$Builder this]
    (-> this (.getSize))))

(defn set-subnetwork
  "[Output Only] The URL of the subnetwork to which all instances in the instance group belong.

  subnetwork - `java.lang.String`

  returns: `com.google.cloud.compute.v1.InstanceGroup$Builder`"
  (^com.google.cloud.compute.v1.InstanceGroup$Builder [^InstanceGroup$Builder this ^java.lang.String subnetwork]
    (-> this (.setSubnetwork subnetwork))))

(defn get-region
  "[Output Only] The URL of the region where the instance group is located (for regional
   resources).

  returns: `java.lang.String`"
  (^java.lang.String [^InstanceGroup$Builder this]
    (-> this (.getRegion))))

(defn add-all-named-ports
  "Assigns a name to a port number. For example: {name: \"http\", port: 80}

   This allows the system to reference ports by the assigned name instead of a port number.
   Named ports can also contain multiple ports. For example: [{name: \"http\", port: 80},{name:
   \"http\", port: 8080}]

   Named ports apply to all instances in this instance group.

  named-ports - `java.util.List`

  returns: `com.google.cloud.compute.v1.InstanceGroup$Builder`"
  (^com.google.cloud.compute.v1.InstanceGroup$Builder [^InstanceGroup$Builder this ^java.util.List named-ports]
    (-> this (.addAllNamedPorts named-ports))))

