(ns com.google.cloud.compute.v1.Instance
  (:refer-clojure :only [require comment defn ->])
  (:import [com.google.cloud.compute.v1 Instance]))

(defn *new-builder
  "prototype - `com.google.cloud.compute.v1.Instance`

  returns: `com.google.cloud.compute.v1.Instance$Builder`"
  (^com.google.cloud.compute.v1.Instance$Builder [^com.google.cloud.compute.v1.Instance prototype]
    (Instance/newBuilder prototype))
  (^com.google.cloud.compute.v1.Instance$Builder []
    (Instance/newBuilder )))

(defn *get-default-instance
  "returns: `com.google.cloud.compute.v1.Instance`"
  (^com.google.cloud.compute.v1.Instance []
    (Instance/getDefaultInstance )))

(defn get-network-interfaces-list
  "An array of network configurations for this instance. These specify how interfaces are
   configured to interact with other network services, such as connecting to the internet.
   Multiple interfaces are supported per instance.

  returns: `java.util.List<com.google.cloud.compute.v1.NetworkInterface>`"
  (^java.util.List [^Instance this]
    (-> this (.getNetworkInterfacesList))))

(defn get-start-restricted?
  "[Output Only] Whether a VM has been restricted for start because Compute Engine has detected
   suspicious activity.

  returns: `java.lang.Boolean`"
  (^java.lang.Boolean [^Instance this]
    (-> this (.getStartRestricted))))

(defn get-shielded-instance-integrity-policy
  "returns: `com.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy`"
  (^com.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy [^Instance this]
    (-> this (.getShieldedInstanceIntegrityPolicy))))

(defn get-deletion-protection?
  "Whether the resource should be protected against deletion.

  returns: `java.lang.Boolean`"
  (^java.lang.Boolean [^Instance this]
    (-> this (.getDeletionProtection))))

(defn get-kind
  "[Output Only] Type of the resource. Always compute#instance for instances.

  returns: `java.lang.String`"
  (^java.lang.String [^Instance this]
    (-> this (.getKind))))

(defn get-cpu-platform
  "[Output Only] The CPU platform used by this instance.

  returns: `java.lang.String`"
  (^java.lang.String [^Instance this]
    (-> this (.getCpuPlatform))))

(defn get-status
  "[Output Only] The status of the instance. One of the following values: PROVISIONING, STAGING,
   RUNNING, STOPPING, STOPPED, SUSPENDING, SUSPENDED, and TERMINATED.

  returns: `java.lang.String`"
  (^java.lang.String [^Instance this]
    (-> this (.getStatus))))

(defn get-guest-accelerators-list
  "A list of the type and count of accelerator cards attached to the instance.

  returns: `java.util.List<com.google.cloud.compute.v1.AcceleratorConfig>`"
  (^java.util.List [^Instance this]
    (-> this (.getGuestAcceleratorsList))))

(defn get-hostname
  "returns: `java.lang.String`"
  (^java.lang.String [^Instance this]
    (-> this (.getHostname))))

(defn get-field-mask
  "returns: `java.util.List<java.lang.String>`"
  (^java.util.List [^Instance this]
    (-> this (.getFieldMask))))

(defn to-string
  "returns: `java.lang.String`"
  (^java.lang.String [^Instance this]
    (-> this (.toString))))

(defn get-labels-map
  "Labels to apply to this instance. These can be later modified by the setLabels method.

  returns: `java.util.Map<java.lang.String,java.lang.String>`"
  (^java.util.Map [^Instance this]
    (-> this (.getLabelsMap))))

(defn get-field-value
  "field-name - `java.lang.String`

  returns: `java.lang.Object`"
  (^java.lang.Object [^Instance this ^java.lang.String field-name]
    (-> this (.getFieldValue field-name))))

(defn get-shielded-instance-config
  "returns: `com.google.cloud.compute.v1.ShieldedInstanceConfig`"
  (^com.google.cloud.compute.v1.ShieldedInstanceConfig [^Instance this]
    (-> this (.getShieldedInstanceConfig))))

(defn get-name
  "The name of the resource, provided by the client when initially creating the resource. The
   resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name
   must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`
   which means the first character must be a lowercase letter, and all following characters must
   be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.

  returns: `java.lang.String`"
  (^java.lang.String [^Instance this]
    (-> this (.getName))))

(defn get-scheduling
  "Sets the scheduling options for this instance.

  returns: `com.google.cloud.compute.v1.Scheduling`"
  (^com.google.cloud.compute.v1.Scheduling [^Instance this]
    (-> this (.getScheduling))))

(defn get-label-fingerprint
  "A fingerprint for this request, which is essentially a hash of the label's contents and used
   for optimistic locking. The fingerprint is initially generated by Compute Engine and changes
   after every request to modify or update labels. You must always provide an up-to-date
   fingerprint hash in order to update or change labels.

   To see the latest fingerprint, make get() request to the instance.

  returns: `java.lang.String`"
  (^java.lang.String [^Instance this]
    (-> this (.getLabelFingerprint))))

(defn get-min-cpu-platform
  "Specifies a minimum CPU platform for the VM instance. Applicable values are the friendly names
   of CPU platforms, such as minCpuPlatform: \"Intel Haswell\" or minCpuPlatform: \"Intel Sandy
   Bridge\".

  returns: `java.lang.String`"
  (^java.lang.String [^Instance this]
    (-> this (.getMinCpuPlatform))))

(defn get-description
  "An optional description of this resource. Provide this property when you create the resource.

  returns: `java.lang.String`"
  (^java.lang.String [^Instance this]
    (-> this (.getDescription))))

(defn get-machine-type
  "Full or partial URL of the machine type resource to use for this instance, in the format:
   zones/zone/machineTypes/machine-type. This is provided by the client when the instance is
   created. For example, the following is a valid partial url to a predefined machine type:
   zones/us-central1-f/machineTypes/n1-standard-1

   To create a custom machine type, provide a URL to a machine type in the following format,
   where CPUS is 1 or an even number up to 32 (2, 4, 6, ... 24, etc), and MEMORY is the total
   memory for this instance. Memory must be a multiple of 256 MB and must be supplied in MB (e.g.
   5 GB of memory is 5120 MB): zones/zone/machineTypes/custom-CPUS-MEMORY

   For example: zones/us-central1-f/machineTypes/custom-4-5120

   For a full list of restrictions, read the Specifications for custom machine types.

  returns: `java.lang.String`"
  (^java.lang.String [^Instance this]
    (-> this (.getMachineType))))

(defn get-can-ip-forward?
  "Allows this instance to send and receive packets with non-matching destination or source IPs.
   This is required if you plan to use this instance to forward routes. For more information, see
   Enabling IP Forwarding.

  returns: `java.lang.Boolean`"
  (^java.lang.Boolean [^Instance this]
    (-> this (.getCanIpForward))))

(defn get-id
  "[Output Only] The unique identifier for the resource. This identifier is defined by the server.

  returns: `java.lang.String`"
  (^java.lang.String [^Instance this]
    (-> this (.getId))))

(defn get-api-message-request-body
  "returns: `com.google.api.gax.httpjson.ApiMessage`"
  (^com.google.api.gax.httpjson.ApiMessage [^Instance this]
    (-> this (.getApiMessageRequestBody))))

(defn get-tags
  "Tags to apply to this instance. Tags are used to identify valid sources or targets for network
   firewalls and are specified by the client during instance creation. The tags can be later
   modified by the setTags method. Each tag within the list must comply with RFC1035. Multiple
   tags can be specified via the 'tags.items' field.

  returns: `com.google.cloud.compute.v1.Tags`"
  (^com.google.cloud.compute.v1.Tags [^Instance this]
    (-> this (.getTags))))

(defn get-self-link
  "[Output Only] Server-defined URL for this resource.

  returns: `java.lang.String`"
  (^java.lang.String [^Instance this]
    (-> this (.getSelfLink))))

(defn get-disks-list
  "Array of disks associated with this instance. Persistent disks must be created before you can
   assign them.

  returns: `java.util.List<com.google.cloud.compute.v1.AttachedDisk>`"
  (^java.util.List [^Instance this]
    (-> this (.getDisksList))))

(defn get-zone
  "[Output Only] URL of the zone where the instance resides. You must specify this field as part
   of the HTTP request URL. It is not settable as a field in the request body.

  returns: `java.lang.String`"
  (^java.lang.String [^Instance this]
    (-> this (.getZone))))

(defn hash-code
  "returns: `int`"
  (^Integer [^Instance this]
    (-> this (.hashCode))))

(defn get-metadata
  "The metadata key/value pairs assigned to this instance. This includes custom metadata and
   predefined keys.

  returns: `com.google.cloud.compute.v1.Metadata`"
  (^com.google.cloud.compute.v1.Metadata [^Instance this]
    (-> this (.getMetadata))))

(defn get-creation-timestamp
  "[Output Only] Creation timestamp in RFC3339 text format.

  returns: `java.lang.String`"
  (^java.lang.String [^Instance this]
    (-> this (.getCreationTimestamp))))

(defn get-service-accounts-list
  "A list of service accounts, with their specified scopes, authorized for this instance. Only one
   service account per VM instance is supported.

   Service accounts generate access tokens that can be accessed through the metadata server and
   used to authenticate applications on the instance. See Service Accounts for more information.

  returns: `java.util.List<com.google.cloud.compute.v1.ServiceAccount>`"
  (^java.util.List [^Instance this]
    (-> this (.getServiceAccountsList))))

(defn equals
  "o - `java.lang.Object`

  returns: `boolean`"
  (^Boolean [^Instance this ^java.lang.Object o]
    (-> this (.equals o))))

(defn get-status-message
  "[Output Only] An optional, human-readable explanation of the status.

  returns: `java.lang.String`"
  (^java.lang.String [^Instance this]
    (-> this (.getStatusMessage))))

(defn to-builder
  "returns: `com.google.cloud.compute.v1.Instance$Builder`"
  (^com.google.cloud.compute.v1.Instance$Builder [^Instance this]
    (-> this (.toBuilder))))

