(ns web.keyboard.KeyboardEvent
  "KeyboardEvent objects describe a user interaction with the keyboard;
  event describes a single interaction between the user and a key
  combination of a key with modifier keys) on the keyboard."
  (:refer-clojure :exclude [char key repeat]))

(defn get-modifier-state
  "Method.

  The KeyboardEvent.getModifierState() method returns the current
  of the specified modifier key: true if the modifier is active
  is the modifier key is pressed or locked), otherwise, false.

  `var active = event.getModifierState(keyArg);`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/getModifierState`"
  [this key-arg]
  (-> this (.getModifierState key-arg)))

(defn init-key-event
  "Method.

  [Deprecated]
  [Non Standard]

  The KeyboardEvent.initKeyEvent() method is used to initialize
  value of an event created using `document.createEvent`(\\\"KeyboardEvent\\\").
  initialized in this way must have been created with the `document.createEvent`(\\\"KeyboardEvent\\\")
  initKeyEvent() must be called to set the event before it is dispatched.

  `event.initKeyEvent (type, bubbles, cancelable, viewArg,
  ctrlKeyArg, altKeyArg, shiftKeyArg, metaKeyArg,
  keyCodeArg, charCodeArg)`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/initKeyEvent`"
  [this & args]
  (-> this .-initKeyEvent (.apply this (clj->js args))))

(defn init-keyboard-event
  "Method.

  [Deprecated]

  The KeyboardEvent.initKeyboardEvent() method initializes the
  of a keyboard event object. This method was introduced in draft
  DOM Level 3 Events, but deprecated in newer draft. Gecko won't
  this feature since implementing this method as experimental broke
  web apps (see bug 999645). Web applications should use constructor
  of this if it's available.

  `kbdEvent.initKeyboardEvent(typeArg, canBubbleArg, cancelableArg,
  viewArg, charArg, keyArg,
  locationArg, modifiersListArg, repeat)`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/initKeyboardEvent`"
  [this & args]
  (-> this .-initKeyboardEvent (.apply this (clj->js args))))

(defn alt-key
  "Property.

  [Read Only]

  The KeyboardEvent.altKey read-only property is a `js.Boolean`
  indicates if the alt key (Option or ⌥ on OS X) was pressed (true)
  not (false) when the event occured.

  `var altKeyPressed = instanceOfKeyboardEvent.altKey`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/altKey`"
  [this]
  (-> this (.-altKey)))

(defn char
  "Property.

  Returns a DOMString representing the character value of the key.
  the key corresponds to a printable character, this value is a
  Unicode string containing that character. If the key doesn't
  a printable representation, this is an empty string.
  Note: If the key is used as a macro that inserts multiple characters,
  attribute's value is the entire string, not just the first character."
  [this]
  (-> this (.-char)))

(defn set-char!
  "Property.

  Returns a DOMString representing the character value of the key.
  the key corresponds to a printable character, this value is a
  Unicode string containing that character. If the key doesn't
  a printable representation, this is an empty string.
  Note: If the key is used as a macro that inserts multiple characters,
  attribute's value is the entire string, not just the first character."
  [this val]
  (aset this "char" val))

(defn char-code
  "Property.

  [Read Only]
  [Deprecated]
  [Non Standard]

  The charCode read-only property of the `web.keyboard.KeyboardEvent`
  returns the Unicode value of a character key pressed during a
  event.

  `var code = event.charCode;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/charCode`"
  [this]
  (-> this (.-charCode)))

(defn code
  "Property.

  [Read Only]

  The KeyboardEvent.code property represents a physical key on
  keyboard (as opposed to the character generated by pressing the
  In other words, this property returns a value which isn't altered
  keyboard layout or the state of the modifier keys.

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/code`"
  [this]
  (-> this (.-code)))

(defn ctrl-key
  "Property.

  [Read Only]

  The KeyboardEvent.ctrlKey read-only property returns a `js.Boolean`
  indicates if the control key was pressed (true) or not (false)
  the event occured.

  `var ctrlKeyPressed = instanceOfKeyboardEvent.ctrlKey`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/ctrlKey`"
  [this]
  (-> this (.-ctrlKey)))

(defn is-composing
  "Property.

  [Read Only]

  The KeyboardEvent.isComposing read-only property returns a `js.Boolean`
  indicating if the event is fired after compositionstart and before

  `var bool = event.isComposing;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/isComposing`"
  [this]
  (-> this (.-isComposing)))

(defn key
  "Property.

  [Read Only]

  The `web.keyboard.KeyboardEvent` interface's key read-only property
  the value of the key pressed by the user, taking into consideration
  state of modifier keys such as Shift as well as the keyboard
  and layout.

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/key`"
  [this]
  (-> this (.-key)))

(defn key-code
  "Property.

  [Read Only]
  [Deprecated]

  The deprecated KeyboardEvent.keyCode read-only property represents
  system and implementation dependent numerical code identifying
  unmodified value of the pressed key.

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/keyCode`"
  [this]
  (-> this (.-keyCode)))

(defn key-identifier
  "Property.

  [Read Only]
  [Deprecated]
  [Non Standard]

  The deprecated KeyboardEvent.keyIdentifier read-only property
  a \\\"key identifier\\\" string that can be used to determine what
  was pressed. Its non-deprecated replacement is `KeyboardEvent.key`.

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/keyIdentifier`"
  [this]
  (-> this (.-keyIdentifier)))

(defn key-location
  "Property.

  This is a non-standard deprecated alias for KeyboardEvent.location.
  was part of an old version of DOM Level 3 Events."
  [this]
  (-> this (.-keyLocation)))

(defn set-key-location!
  "Property.

  This is a non-standard deprecated alias for KeyboardEvent.location.
  was part of an old version of DOM Level 3 Events."
  [this val]
  (aset this "keyLocation" val))

(defn locale
  "Property.

  Returns a DOMString representing a locale string indicating the
  the keyboard is configured for. This may be the empty string
  the browser or device doesn't know the keyboard's locale.
  Note: This does not describe the locale of the data being entered.
  user may be using one keyboard layout while typing text in a
  language."
  [this]
  (-> this (.-locale)))

(defn set-locale!
  "Property.

  Returns a DOMString representing a locale string indicating the
  the keyboard is configured for. This may be the empty string
  the browser or device doesn't know the keyboard's locale.
  Note: This does not describe the locale of the data being entered.
  user may be using one keyboard layout while typing text in a
  language."
  [this val]
  (aset this "locale" val))

(defn location
  "Property.

  [Read Only]

  The KeyboardEvent.location read-only property returns an unsigned
  representing the location of the key on the keyboard or other
  device.

  `var location = event.location;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/location`"
  [this]
  (-> this (.-location)))

(defn meta-key
  "Property.

  [Read Only]

  The KeyboardEvent.metaKey read-only property returning a `js.Boolean`
  indicates if the Meta key was pressed (true) or not (false) when
  event occurred. Some operating systems may intercept the key
  it is never detected.

  `var metaKeyPressed = instanceOfKeyboardEvent.metaKey`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/metaKey`"
  [this]
  (-> this (.-metaKey)))

(defn repeat
  "Property.

  [Read Only]

  The repeat read-only property of the `web.keyboard.KeyboardEvent`
  returns a `js.Boolean` that is true if the given key is being
  down such that it is automatically repeating.

  `var repeat = event.repeat;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/repeat`"
  [this]
  (-> this (.-repeat)))

(defn shift-key
  "Property.

  [Read Only]

  The KeyboardEvent.shiftKey read-only property is a `js.Boolean`
  indicates if the shift key was pressed (true) or not (false)
  the event occurred.

  `var shiftKeyPressed = instanceOfKeyboardEvent.shiftKey`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/shiftKey`"
  [this]
  (-> this (.-shiftKey)))

(defn which
  "Property.

  [Read Only]
  [Deprecated]

  The which read-only property of the `web.keyboard.KeyboardEvent`
  returns the numeric keyCode of the key pressed, or the character
  (charCode) for an alphanumeric key pressed.

  `var keyResult = event.which;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/which`"
  [this]
  (-> this (.-which)))

