(ns web.media.TextTrack
  "This interface also inherits properties from `web.EventTarget`."
  (:refer-clojure :exclude []))

(defn add-cue
  "Method.

  Adds a cue (specified as a TextTrackCue object to the track's
  of cues."
  [this & args]
  (apply (-> this .-addCue) (concat [this] args)))

(defn remove-cue
  "Method.

  Removes a cue (specified as a TextTrackCue object from the track's
  of cues."
  [this & args]
  (apply (-> this .-removeCue) (concat [this] args)))

(defn active-cues
  "Property.

  A TextTrackCueList object listing the currently active set of
  track cues. Track cues are active if the current playback position
  the media is between the cues' start and end times. Thus, for
  cues such as captions or subtitles, the active cues are currently
  displayed."
  [this]
  (-> this (.-activeCues)))

(defn set-active-cues!
  "Property.

  A TextTrackCueList object listing the currently active set of
  track cues. Track cues are active if the current playback position
  the media is between the cues' start and end times. Thus, for
  cues such as captions or subtitles, the active cues are currently
  displayed."
  [this val]
  (aset this "activeCues" val))

(defn cues
  "Property.

  A TextTrackCueList which contains all of the track's cues."
  [this]
  (-> this (.-cues)))

(defn set-cues!
  "Property.

  A TextTrackCueList which contains all of the track's cues."
  [this val]
  (aset this "cues" val))

(defn id
  "Property.

  A DOMString which identifies the track, if it has one. If it
  have an ID, then this value is an empty string (\"\"). If the TextTrack
  associated with a <track> element, then the track's ID matches
  element's ID."
  [this]
  (-> this (.-id)))

(defn set-id!
  "Property.

  A DOMString which identifies the track, if it has one. If it
  have an ID, then this value is an empty string (\"\"). If the TextTrack
  associated with a <track> element, then the track's ID matches
  element's ID."
  [this val]
  (aset this "id" val))

(defn in-band-metadata-track-dispatch-type
  "Property.

  Returns a DOMString which indicates the track's in-band metadata
  dispatch type. needs details"
  [this]
  (-> this (.-inBandMetadataTrackDispatchType)))

(defn set-in-band-metadata-track-dispatch-type!
  "Property.

  Returns a DOMString which indicates the track's in-band metadata
  dispatch type. needs details"
  [this val]
  (aset this "inBandMetadataTrackDispatchType" val))

(defn kind
  "Property.

  Returns a DOMString indicating what kind of text track the TextTrack
  The value must be one of those in the TextTrackKind enum."
  [this]
  (-> this (.-kind)))

(defn set-kind!
  "Property.

  Returns a DOMString indicating what kind of text track the TextTrack
  The value must be one of those in the TextTrackKind enum."
  [this val]
  (aset this "kind" val))

(defn label
  "Property.

  A human-readable DOMString which contains the text track's label,
  one is present; otherwise, this is an empty string (\"\"), in which
  a custom label may need to be generated by your code using other
  of the track, if the track's label needs to be exposed to the"
  [this]
  (-> this (.-label)))

(defn set-label!
  "Property.

  A human-readable DOMString which contains the text track's label,
  one is present; otherwise, this is an empty string (\"\"), in which
  a custom label may need to be generated by your code using other
  of the track, if the track's label needs to be exposed to the"
  [this val]
  (aset this "label" val))

(defn language
  "Property.

  A DOMString which specifies the text language in which the text
  contents is written. The value must adhere to the format specified
  the Tags for Identifying Languages (BCP 47) document from the
  just like the HTML lang attribute. For example, this can be \"en-US\"
  United States English or \"pt-BR\" for Brazilian Portuguese."
  [this]
  (-> this (.-language)))

(defn set-language!
  "Property.

  A DOMString which specifies the text language in which the text
  contents is written. The value must adhere to the format specified
  the Tags for Identifying Languages (BCP 47) document from the
  just like the HTML lang attribute. For example, this can be \"en-US\"
  United States English or \"pt-BR\" for Brazilian Portuguese."
  [this val]
  (aset this "language" val))

(defn mode
  "Property.

  The `web.media.TextTrack` interface's mode property is a string
  and controlling the text track's mode: disabled, hidden, or showing.

  `var mode = textTrack.mode;

  textTrack.mode = \\\"disabled\\\" | \\\"hidden\\\" | \\\"showing\\\";`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/TextTrack/mode`"
  [this]
  (-> this (.-mode)))

(defn set-mode!
  "Property.

  The `web.media.TextTrack` interface's mode property is a string
  and controlling the text track's mode: disabled, hidden, or showing.

  `var mode = textTrack.mode;

  textTrack.mode = \\\"disabled\\\" | \\\"hidden\\\" | \\\"showing\\\";`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/TextTrack/mode`"
  [this val]
  (aset this "mode" val))

