(ns web.other.FileReaderSync
  "The FileReaderSync interface allows to read File or Blob objects
  a synchronous way."
  (:refer-clojure :exclude []))

(defn blob
  "Method.

  The DOM Blob or File to read into the ArrayBuffer."
  [this & args]
  (apply (-> this .-blob) (concat [this] args)))

(defn not-found-error
  "Method.

  is raised when the resource represented by the DOM Blob or File
  be found, e. g. because it has been erased."
  [this & args]
  (apply (-> this .-NotFoundError) (concat [this] args)))

