(ns web.dom.HTMLInputElement.ev
  "HTMLInputElement Events."
  (:refer-clojure :exclude []))

(def input
  "Event.

  The input event fires when the value of an `<input>`, `<select>`,
  `<textarea>` element has been changed.

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/HTMLElement/input_event`"

  "input")

(def invalid
  "Event.

  The invalid event fires when a submittable element has been checked
  validity and doesn't satisfy its constraints.

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/HTMLInputElement/invalid_event`"

  "invalid")

(def search
  "Event.

  The search event is fired when a search is initiated usinng an
  element of type=\\\"search\\\".

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/HTMLInputElement/search_event`"

  "search")

