(ns web.event.FocusEvent
  "The FocusEvent interface represents focus-related events, including
  blur, focusin, and focusout."
  (:refer-clojure :exclude []))

(defn constructor
  "Constructor.

  The FocusEvent() constructor returns a newly created `web.event.FocusEvent` object with an optional `web.EventTarget`. When the event has both a source and a destination, the relatedTarget value must be set to the other target.

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/FocusEvent/FocusEvent`"
  [& args]
  (new (js/Function.prototype.bind.apply js/FocusEvent (clj->js args))))

(defn related-target
  "Property.

  [Read Only]

  The FocusEvent.relatedTarget read-only property is the secondary
  depending on the type of event:

  `secondTarget = focusEvent.relatedTarget`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/FocusEvent/relatedTarget`"
  [this]
  (-> this (.-relatedTarget)))

