(ns web.event.CompositionEvent
  "The DOM CompositionEvent represents events that occur due to
  user indirectly entering text."
  (:refer-clojure :exclude []))

(defn constructor
  "Constructor.

  The CompositionEvent() constructor creates a new `web.event.CompositionEvent` object instance.

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/CompositionEvent/CompositionEvent`"
  [& args]
  (new (js/Function.prototype.bind.apply js/CompositionEvent (clj->js args))))

(defn init-composition-event
  "Method.

  [Deprecated]

  The initCompositionEvent() method of the `web.event.CompositionEvent`
  initializes the attributes of a CompositionEvent object instance.

  `compositionEventInstance.initCompositionEvent(typeArg, canBubbleArg, cancelableArg, viewArg, dataArg, localeArg)`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/CompositionEvent/initCompositionEvent`"
  [this type-arg can-bubble-arg cancelable-arg view-arg data-arg locale-arg]
  (-> this (.initCompositionEvent type-arg can-bubble-arg cancelable-arg view-arg data-arg locale-arg)))

(defn data
  "Property.

  [Read Only]

  The data read-only property of the `web.event.CompositionEvent`
  returns the characters generated by the input method that raised
  event; its exact nature varies depending on the type of event
  generated the CompositionEvent object.

  `myData = CompositionEvent.data`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/CompositionEvent/data`"
  [this]
  (-> this (.-data)))

(defn locale
  "Property.

  [Read Only]
  [Deprecated]

  The locale read-only property of the `web.event.CompositionEvent`
  returns the locale of current input method (for example, the
  layout locale if the composition is associated with IME).

  `myLocale = CompositionEvent.locale`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/CompositionEvent/locale`"
  [this]
  (-> this (.-locale)))

