(ns web.ar.XRRenderState
  "The XRRenderState interface of the WebXR Device API represents
  set of configurable values which affect how `web.ar.XRSession`'s
  is composited. The active render state for an XRSession changes
  frame boundaries. To queue updates for the next frame, call `XRSession.updateRenderState()`."
  (:refer-clojure :exclude []))

(defn base-layer
  "Property.

  [Read Only]
  [Draft]

  The baseLayer read-only property of the `web.ar.XRRenderState`
  returns the `XRWebGLLayer` instance that is the source of bitmap
  and a description of how the image is to be rendered in the device.

  `var xrWebGLLayer = XRRenderState.baseLayer;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/XRRenderState/baseLayer`"
  [this]
  (-> this (.-baseLayer)))

(defn depth-far
  "Property.

  [Read Only]
  [Draft]

  The depthFar read-only property of the `web.ar.XRRenderState`
  returns the distance in meters of the far clip plane from the

  `var aDouble = XRRenderState.depthFar;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/XRRenderState/depthFar`"
  [this]
  (-> this (.-depthFar)))

(defn depth-near
  "Property.

  [Read Only]
  [Draft]

  The depthNear read-only property of the `web.ar.XRRenderState`
  returns the distance in meters of the near clip plane from the

  `var aDouble = XRRenderState.depthNear;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/XRRenderState/depthNear`"
  [this]
  (-> this (.-depthNear)))

