(ns js.Uint8ClampedArray
  "The Uint8ClampedArray typed array represents an array of 8-bit
  integers clamped to 0-255; if you specified a value that is out
  the range of [0,255], 0 or 255 will be set instead; if you specify
  non-integer, the nearest integer will be set. The contents are
  to 0. Once established, you can reference elements in the array
  the object's methods, or using standard array index syntax (that
  using bracket notation)."
  (:refer-clojure :exclude []))

(defn from
  "Method.

  The TypedArray.from() method creates a new typed array from an
  or iterable object. This method is nearly the same as `Array.from()`.

  `TypedArray.from(source[, mapFn[, thisArg]])

  where TypedArray is one of:

  Int8Array
  Uint8Array
  Uint8ClampedArray
  Int16Array
  Uint16Array
  Int32Array
  Uint32Array
  Float32Array
  Float64Array
  BigInt64Array
  BigUint64Array`

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/from`"
  [this & args]
  (apply (-> this .-from) (concat [this] args)))

(defn bytes-per-element
  "Property.

  The TypedArray.BYTES_PER_ELEMENT property represents the size
  bytes of each element in an typed array.

  `TypedArray.BYTES_PER_ELEMENT;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/BYTES_PER_ELEMENT`"
  [this]
  (-> this (.BYTES_PER_ELEMENT)))

(defn set-bytes-per-element!
  "Property.

  The TypedArray.BYTES_PER_ELEMENT property represents the size
  bytes of each element in an typed array.

  `TypedArray.BYTES_PER_ELEMENT;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/BYTES_PER_ELEMENT`"
  [this val]
  (aset this "BYTES_PER_ELEMENT" val))

