(ns js.Symbol
  "The data type symbol is a primitive data type. The Symbol() function
  a value of type symbol, has static properties that expose several
  of built-in objects, has static methods that expose the global
  registry, and resembles a built-in object class but is incomplete
  a constructor because it does not support the syntax \\\"new Symbol()\\\"."
  (:refer-clojure :exclude [for]))

(defn for
  "Method.

  The Symbol.for(key) method searches for existing symbols in a
  symbol registry with the given key and returns it if found. Otherwise
  new symbol gets created in the global symbol registry with this

  `Symbol.for(key);`

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Symbol/for`"
  [this key]
  (-> this (.for key)))

(defn length
  "Property.

  Length property whose value is 0."
  [this]
  (-> this (.length)))

(defn set-length!
  "Property.

  Length property whose value is 0."
  [this val]
  (aset this "length" val))

(defn iterator
  "Property.

  The Symbol.iterator well-known symbol specifies the default iterator
  an object. Used by `for...of`.

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Symbol/iterator`"
  [this]
  (-> this (.iterator)))

(defn set-iterator!
  "Property.

  The Symbol.iterator well-known symbol specifies the default iterator
  an object. Used by `for...of`.

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Symbol/iterator`"
  [this val]
  (aset this "iterator" val))

(defn match
  "Property.

  The Symbol.match well-known symbol specifies the matching of
  regular expression against a string. This function is called
  the `String.prototype.match()` method.

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Symbol/match`"
  [this]
  (-> this (.match)))

(defn set-match!
  "Property.

  The Symbol.match well-known symbol specifies the matching of
  regular expression against a string. This function is called
  the `String.prototype.match()` method.

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Symbol/match`"
  [this val]
  (aset this "match" val))

(defn has-instance
  "Property.

  The Symbol.hasInstance well-known symbol is used to determine
  a constructor object recognizes an object as its instance. The
  operator's behavior can be customized by this symbol.

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Symbol/hasInstance`"
  [this]
  (-> this (.hasInstance)))

(defn set-has-instance!
  "Property.

  The Symbol.hasInstance well-known symbol is used to determine
  a constructor object recognizes an object as its instance. The
  operator's behavior can be customized by this symbol.

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Symbol/hasInstance`"
  [this val]
  (aset this "hasInstance" val))

