(ns js.String
  "The String global object is a constructor for strings or a sequence
  characters."
  (:refer-clojure :exclude []))

(defn from-char-code
  "Method.

  The static String.fromCharCode() method returns a string created
  the specified sequence of UTF-16 code units.

  `String.fromCharCode(num1[, ...[, numN]])`

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/fromCharCode`"
  [this & args]
  (apply (-> this .-fromCharCode) (concat [this] args)))

(defn prototype
  "Property.

  The String.prototype property represents the `js.String` prototype

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/prototype`"
  [this]
  (-> this (.prototype)))

(defn set-prototype!
  "Property.

  The String.prototype property represents the `js.String` prototype

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/prototype`"
  [this val]
  (aset this "prototype" val))

