(ns js.Reflect
  "Reflect is a built-in object that provides methods for interceptable
  operations. The methods are the same as those of proxy handlers.
  is not a function object, so it's not constructible."
  (:refer-clojure :exclude [apply]))

(defn apply
  "Method.

  The static Reflect.apply() method calls a target function with
  as specified.

  `Reflect.apply(target, thisArgument, argumentsList)`

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Reflect/apply`"
  [this target this-argument arguments-list]
  (-> this (.apply target this-argument arguments-list)))

