(ns js.Promise
  "The Promise object represents the eventual completion (or failure)
  an asynchronous operation, and its resulting value."
  (:refer-clojure :exclude []))

(defn all
  "Method.

  The Promise.all() method returns a single `js.Promise` that resolves
  all of the promises passed as an iterable have resolved or when
  iterable contains no promises. It rejects with the reason of
  first promise that rejects.

  `Promise.all(iterable);`

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise/all`"
  [this iterable]
  (-> this (.all iterable)))

(defn length
  "Property.

  Length property whose value is always 1 (number of constructor"
  [this]
  (-> this (.length)))

(defn set-length!
  "Property.

  Length property whose value is always 1 (number of constructor"
  [this val]
  (aset this "length" val))

