(ns js.Number
  "The Number JavaScript object is a wrapper object allowing you
  work with numerical values. A Number object is created using
  Number() constructor. A primitive type object number is created
  the Number() function."
  (:refer-clojure :exclude []))

(defn is-na-n
  "Method.

  The Number.isNaN() method determines whether the passed value
  `js.NaN` and its type is `js.Number`. It is a more robust version
  the original, global `isNaN()`.

  `Number.isNaN(value)`

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/isNaN`"
  [this value]
  (-> this (.isNaN value)))

(defn epsilon
  "Property.

  The Number.EPSILON property represents the difference between
  and the smallest floating point number greater than 1.

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/EPSILON`"
  [this]
  (-> this (.EPSILON)))

(defn set-epsilon!
  "Property.

  The Number.EPSILON property represents the difference between
  and the smallest floating point number greater than 1.

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/EPSILON`"
  [this val]
  (aset this "EPSILON" val))

