(ns js.Generator
  "The Generator object is returned by a generator function and
  conforms to both the iterable protocol and the iterator protocol."
  (:refer-clojure :exclude [next]))

(defn next
  "Method.

  The next() method returns an object with two properties done
  value. You can also provide a parameter to the next method to
  a value to the generator.

  `gen.next(value)`

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Generator/next`"
  [this value]
  (-> this (.next value)))

