(ns js.Date
  "Creates a JavaScript Date instance that represents a single moment
  time in a platform-independent format."
  (:refer-clojure :exclude []))

(defn now
  "Method.

  The Date.now() method returns the number of milliseconds elapsed
  January 1, 1970 00:00:00 UTC.

  `var timeInMs = Date.now();`

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/now`"
  [this ]
  (-> this (.now)))

(defn prototype
  "Property.

  The Date.prototype property represents the prototype for the
  constructor.

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/prototype`"
  [this]
  (-> this (.prototype)))

(defn set-prototype!
  "Property.

  The Date.prototype property represents the prototype for the
  constructor.

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/prototype`"
  [this val]
  (aset this "prototype" val))

