(ns js.DataView
  "The DataView view provides a low-level interface for reading
  writing multiple number types in a binary `js.ArrayBuffer`, without
  to care about the platform's endianness."
  (:refer-clojure :exclude []))

(defn get-int-8
  "Method.

  The getInt8() method gets a signed 8-bit integer (byte) at the
  byte offset from the start of the `js.DataView`.

  `dataview.getInt8(byteOffset)`

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/DataView/getInt8`"
  [this byte-offset]
  (-> this (.getInt8 byte-offset)))

(defn set-int-8
  "Method.

  The setInt8() method stores a signed 8-bit integer (byte) value
  the specified byte offset from the start of the `js.DataView`.

  `dataview.setInt8(byteOffset, value)`

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/DataView/setInt8`"
  [this byte-offset value]
  (-> this (.setInt8 byte-offset value)))

