(ns js.BigUint64Array
  "The BigUint64Array typed array represents an array of 64-bit
  integers in the platform byte order. If control over byte order
  needed, use `js.DataView` instead. The contents are initialized
  0n. Once established, you can reference elements in the array
  the object's methods, or by using standard array index syntax
  is, using bracket notation)."
  (:refer-clojure :exclude []))

(defn from
  "Method.

  The TypedArray.from() method creates a new typed array from an
  or iterable object. This method is nearly the same as `Array.from()`.

  `TypedArray.from(source[, mapFn[, thisArg]])

  where TypedArray is one of:

  Int8Array
  Uint8Array
  Uint8ClampedArray
  Int16Array
  Uint16Array
  Int32Array
  Uint32Array
  Float32Array
  Float64Array
  BigInt64Array
  BigUint64Array`

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/from`"
  [this & args]
  (apply (-> this .-from) (concat [this] args)))

(defn bytes-per-element
  "Property.

  The TypedArray.BYTES_PER_ELEMENT property represents the size
  bytes of each element in an typed array.

  `TypedArray.BYTES_PER_ELEMENT;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/BYTES_PER_ELEMENT`"
  [this]
  (-> this (.BYTES_PER_ELEMENT)))

(defn set-bytes-per-element!
  "Property.

  The TypedArray.BYTES_PER_ELEMENT property represents the size
  bytes of each element in an typed array.

  `TypedArray.BYTES_PER_ELEMENT;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/BYTES_PER_ELEMENT`"
  [this val]
  (aset this "BYTES_PER_ELEMENT" val))

